/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net;

import java.util.HashSet;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.Configurable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.Configuration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;

public abstract class AbstractDNSToSwitchMapping
implements DNSToSwitchMapping,
Configurable {
    private Configuration conf;
    private BookieAddressResolver bookieAddressResolver;

    protected AbstractDNSToSwitchMapping() {
    }

    protected AbstractDNSToSwitchMapping(Configuration conf) {
        this.conf = conf;
    }

    public BookieAddressResolver getBookieAddressResolver() {
        return this.bookieAddressResolver;
    }

    @Override
    public void setBookieAddressResolver(BookieAddressResolver bookieAddressResolver) {
        this.bookieAddressResolver = bookieAddressResolver;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.validateConf();
    }

    public boolean isSingleSwitch() {
        return false;
    }

    public Map<String, String> getSwitchMap() {
        return null;
    }

    public String dumpTopology() {
        Map<String, String> rack = this.getSwitchMap();
        StringBuilder builder = new StringBuilder();
        builder.append("Mapping: ").append(this.toString()).append("\n");
        if (rack != null) {
            builder.append("Map:\n");
            HashSet<String> switches = new HashSet<String>();
            for (Map.Entry<String, String> entry : rack.entrySet()) {
                builder.append("  ").append(entry.getKey()).append(" -> ").append(entry.getValue()).append("\n");
                switches.add(entry.getValue());
            }
            builder.append("Nodes: ").append(rack.size()).append("\n");
            builder.append("Switches: ").append(switches.size()).append("\n");
        } else {
            builder.append("No topology information");
        }
        return builder.toString();
    }

    protected boolean isSingleSwitchByScriptPolicy() {
        return this.conf != null && !StringUtils.isNotBlank(this.conf.getString("networkTopologyScriptFileName"));
    }

    public static boolean isMappingSingleSwitch(DNSToSwitchMapping mapping) {
        return mapping != null && mapping instanceof AbstractDNSToSwitchMapping && ((AbstractDNSToSwitchMapping)mapping).isSingleSwitch();
    }

    protected void validateConf() {
    }
}

