/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.Channel;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.RequestUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteLacProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WriteLacProcessorV3.class);

    public WriteLacProcessorV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
    }

    private BookkeeperProtocol.WriteLacResponse getWriteLacResponse() {
        final long startTimeNanos = MathUtils.nowInNano();
        BookkeeperProtocol.WriteLacRequest writeLacRequest = this.request.getWriteLacRequest();
        long lac = writeLacRequest.getLac();
        long ledgerId = writeLacRequest.getLedgerId();
        final BookkeeperProtocol.WriteLacResponse.Builder writeLacResponse = BookkeeperProtocol.WriteLacResponse.newBuilder().setLedgerId(ledgerId);
        if (!this.isVersionCompatible()) {
            writeLacResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
            return writeLacResponse.build();
        }
        if (this.requestProcessor.bookie.isReadOnly()) {
            logger.warn("BookieServer is running as readonly mode, so rejecting the request from the client!");
            writeLacResponse.setStatus(BookkeeperProtocol.StatusCode.EREADONLY);
            return writeLacResponse.build();
        }
        BookkeeperInternalCallbacks.WriteCallback writeCallback = new BookkeeperInternalCallbacks.WriteCallback(){

            @Override
            public void writeComplete(int rc, long ledgerId, long entryId, BookieId addr, Object ctx) {
                BookkeeperProtocol.StatusCode status;
                if (0 == rc) {
                    WriteLacProcessorV3.this.requestProcessor.getRequestStats().getWriteLacStats().registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
                } else {
                    WriteLacProcessorV3.this.requestProcessor.getRequestStats().getWriteLacStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
                }
                switch (rc) {
                    case 0: {
                        status = BookkeeperProtocol.StatusCode.EOK;
                        break;
                    }
                    case 101: {
                        status = BookkeeperProtocol.StatusCode.EIO;
                        break;
                    }
                    default: {
                        status = BookkeeperProtocol.StatusCode.EUA;
                    }
                }
                writeLacResponse.setStatus(status);
                BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(WriteLacProcessorV3.this.getHeader()).setStatus(writeLacResponse.getStatus()).setWriteLacResponse(writeLacResponse);
                BookkeeperProtocol.Response resp = response.build();
                WriteLacProcessorV3.this.sendResponse(status, resp, WriteLacProcessorV3.this.requestProcessor.getRequestStats().getWriteLacRequestStats());
            }
        };
        BookkeeperProtocol.StatusCode status = null;
        ByteBuffer lacToAdd = writeLacRequest.getBody().asReadOnlyByteBuffer();
        byte[] masterKey = writeLacRequest.getMasterKey().toByteArray();
        try {
            this.requestProcessor.bookie.setExplicitLac(Unpooled.wrappedBuffer(lacToAdd), writeCallback, this.channel, masterKey);
            status = BookkeeperProtocol.StatusCode.EOK;
        }
        catch (IOException e) {
            logger.error("Error saving lac {} for ledger:{}", new Object[]{lac, ledgerId, e});
            status = BookkeeperProtocol.StatusCode.EIO;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Interrupted while saving lac {} for ledger:{}", new Object[]{lac, ledgerId, e});
            status = BookkeeperProtocol.StatusCode.EIO;
        }
        catch (BookieException e) {
            logger.error("Unauthorized access to ledger:{} while adding lac:{}", new Object[]{ledgerId, lac, e});
            status = BookkeeperProtocol.StatusCode.EUA;
        }
        catch (Throwable t) {
            logger.error("Unexpected exception while writing lac {} for ledger:{}", new Object[]{lac, ledgerId, t});
            status = BookkeeperProtocol.StatusCode.EBADREQ;
        }
        if (!status.equals(BookkeeperProtocol.StatusCode.EOK)) {
            this.requestProcessor.getRequestStats().getWriteLacStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            writeLacResponse.setStatus(status);
            return writeLacResponse.build();
        }
        return null;
    }

    @Override
    public void safeRun() {
        BookkeeperProtocol.WriteLacResponse writeLacResponse = this.getWriteLacResponse();
        if (null != writeLacResponse) {
            BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(writeLacResponse.getStatus()).setWriteLacResponse(writeLacResponse);
            BookkeeperProtocol.Response resp = response.build();
            this.sendResponse(writeLacResponse.getStatus(), resp, this.requestProcessor.getRequestStats().getWriteLacRequestStats());
        }
    }

    @Override
    public String toString() {
        return RequestUtils.toSafeString(this.request);
    }
}

