/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.http.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnderReplicatedLedgerService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListUnderReplicatedLedgerService.class);
    protected ServerConfiguration conf;
    protected BookieServer bookieServer;

    public ListUnderReplicatedLedgerService(ServerConfiguration conf, BookieServer bookieServer) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bookieServer = bookieServer;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod()) {
            boolean printMissingReplica = false;
            String includingBookieId = params != null && params.containsKey("missingreplica") ? (String)params.get("missingreplica") : null;
            String excludingBookieId = params != null && params.containsKey("excludingmissingreplica") ? (String)params.get("excludingmissingreplica") : null;
            if (params != null && params.containsKey("printmissingreplica")) {
                printMissingReplica = true;
            }
            Predicate<List<String>> predicate = null;
            if (!StringUtils.isBlank(includingBookieId) && !StringUtils.isBlank(excludingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId) && !replicasList.contains(excludingBookieId);
            } else if (!StringUtils.isBlank(includingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId);
            } else if (!StringUtils.isBlank(excludingBookieId)) {
                predicate = replicasList -> !replicasList.contains(excludingBookieId);
            }
            try {
                boolean hasURLedgers = false;
                ArrayList<Long> outputLedgers = null;
                LinkedHashMap<Long, List<String>> outputLedgersWithMissingReplica = null;
                LedgerManagerFactory mFactory = this.bookieServer.getBookie().getLedgerManagerFactory();
                LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();
                Iterator<UnderreplicatedLedger> iter = underreplicationManager.listLedgersToRereplicate(predicate);
                hasURLedgers = iter.hasNext();
                if (hasURLedgers) {
                    if (printMissingReplica) {
                        outputLedgersWithMissingReplica = new LinkedHashMap<Long, List<String>>();
                    } else {
                        outputLedgers = Lists.newArrayList();
                    }
                }
                while (iter.hasNext()) {
                    if (printMissingReplica) {
                        UnderreplicatedLedger underreplicatedLedger = iter.next();
                        outputLedgersWithMissingReplica.put(underreplicatedLedger.getLedgerId(), underreplicatedLedger.getReplicaList());
                        continue;
                    }
                    outputLedgers.add(iter.next().getLedgerId());
                }
                if (!hasURLedgers) {
                    response.setCode(HttpServer.StatusCode.NOT_FOUND);
                    response.setBody("No under replicated ledgers found");
                    return response;
                }
                response.setCode(HttpServer.StatusCode.OK);
                String jsonResponse = JsonUtil.toJson(printMissingReplica ? outputLedgersWithMissingReplica : outputLedgers);
                LOG.debug("output body: " + jsonResponse);
                response.setBody(jsonResponse);
                return response;
            }
            catch (Exception e) {
                LOG.error("Exception occurred while listing under replicated ledgers", (Throwable)e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Exception when get." + e.getMessage());
                return response;
            }
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

