/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.service;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieService
extends ServerLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(BookieService.class);
    public static final String NAME = "bookie-server";
    private final BookieServer server;

    public BookieService(BookieConfiguration conf, StatsLogger statsLogger, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws Exception {
        super(NAME, conf, statsLogger);
        this.server = new BookieServer(conf.getServerConf(), statsLogger, bookieServiceInfoProvider);
    }

    @Override
    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        super.setExceptionHandler(handler);
        this.server.setExceptionHandler(handler);
    }

    public BookieServer getServer() {
        return this.server;
    }

    @Override
    protected void doStart() {
        try {
            this.server.start();
        }
        catch (InterruptedException exc) {
            throw new RuntimeException("Failed to start bookie server", exc);
        }
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        this.server.shutdown();
    }

    @Override
    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        try {
            BookieSocketAddress localAddress = this.getServer().getLocalAddress();
            ArrayList<String> extensions = new ArrayList<String>();
            if (((BookieConfiguration)this.conf).getServerConf().getTLSProviderFactoryClass() != null) {
                extensions.add("tls");
            }
            ComponentInfoPublisher.EndpointInfo endpoint = new ComponentInfoPublisher.EndpointInfo("bookie", localAddress.getPort(), localAddress.getHostName(), "bookie-rpc", null, extensions);
            componentInfoPublisher.publishEndpoint(endpoint);
        }
        catch (UnknownHostException err) {
            log.error("Cannot compute local address", (Throwable)err);
        }
    }
}

