/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util;

import java.lang.reflect.Method;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectMemoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DirectMemoryUtils.class);

    public static long maxDirectMemory() {
        try {
            Class<?> vm = Class.forName("sun.misc.VM");
            Method maxDirectMemory = vm.getDeclaredMethod("maxDirectMemory", new Class[0]);
            Object result = maxDirectMemory.invoke(null, (Object[])null);
            Preconditions.checkNotNull(result);
            Preconditions.checkArgument(result instanceof Long);
            return (Long)result;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to get maxDirectMemory size from sun.misc.VM, falling back to max heap size", (Throwable)e);
            }
            return Runtime.getRuntime().maxMemory();
        }
    }
}

