/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util;

import java.io.IOException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperProtocol;

public class StringUtils {
    public static final String LEDGER_NODE_PREFIX = "L";
    public static final String FLAT_LEDGER_NODE_REGEX = "L\\d{10}";
    public static final String LEGACYHIERARCHICAL_LEDGER_PARENT_NODE_REGEX = "\\d{2}";
    public static final String LONGHIERARCHICAL_LEDGER_PARENT_NODE_REGEX = "\\d{3}";
    public static final String HIERARCHICAL_LEDGER_PARENT_NODE_REGEX = "\\d{2,3}";

    public static String getZKStringId(long id) {
        return String.format("%010d", id);
    }

    public static String getZKStringIdForLongHierarchical(long id) {
        return String.format("%019d", id);
    }

    public static String getShortHierarchicalLedgerPath(long ledgerId) {
        String ledgerIdStr = StringUtils.getZKStringId(ledgerId);
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(ledgerIdStr.substring(0, 2)).append("/").append(ledgerIdStr.substring(2, 6)).append("/").append(LEDGER_NODE_PREFIX).append(ledgerIdStr.substring(6, 10));
        return sb.toString();
    }

    public static String getLongHierarchicalLedgerPath(long ledgerId) {
        String ledgerIdStr = StringUtils.getZKStringIdForLongHierarchical(ledgerId);
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(ledgerIdStr.substring(0, 3)).append("/").append(ledgerIdStr.substring(3, 7)).append("/").append(ledgerIdStr.substring(7, 11)).append("/").append(ledgerIdStr.substring(11, 15)).append("/").append(LEDGER_NODE_PREFIX).append(ledgerIdStr.substring(15, 19));
        return sb.toString();
    }

    public static String getHybridHierarchicalLedgerPath(long ledgerId) {
        if (ledgerId < Integer.MAX_VALUE) {
            return StringUtils.getShortHierarchicalLedgerPath(ledgerId);
        }
        return StringUtils.getLongHierarchicalLedgerPath(ledgerId);
    }

    public static long stringToHierarchicalLedgerId(String hierarchicalLedgerPath) throws IOException {
        String[] hierarchicalParts = hierarchicalLedgerPath.split("/");
        if (hierarchicalParts.length != 3) {
            throw new IOException("it is not a valid hierarchical path name : " + hierarchicalLedgerPath);
        }
        hierarchicalParts[2] = hierarchicalParts[2].substring(LEDGER_NODE_PREFIX.length());
        return StringUtils.stringToHierarchicalLedgerId(hierarchicalParts);
    }

    public static long stringToLongHierarchicalLedgerId(String longHierarchicalLedgerPath) throws IOException {
        String[] longHierarchicalParts = longHierarchicalLedgerPath.split("/");
        if (longHierarchicalParts.length != 5) {
            return StringUtils.stringToHierarchicalLedgerId(longHierarchicalLedgerPath);
        }
        longHierarchicalParts[4] = longHierarchicalParts[4].substring(LEDGER_NODE_PREFIX.length());
        return StringUtils.stringToHierarchicalLedgerId(longHierarchicalParts);
    }

    public static long stringToHierarchicalLedgerId(String ... levelNodes) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            for (String node : levelNodes) {
                sb.append(node);
            }
            return Long.parseLong(sb.toString());
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    public static String requestToString(Object request) {
        if (request instanceof BookkeeperProtocol.Request) {
            BookkeeperProtocol.BKPacketHeader header = ((BookkeeperProtocol.Request)request).getHeader();
            return String.format("Req(txnId=%d,op=%s,version=%s)", header.getTxnId(), header.getOperation(), header.getVersion());
        }
        return request.toString();
    }
}

