/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pulsar.functions.runtime.shaded.org.apache.jute.BinaryOutputArchive;
import org.apache.pulsar.functions.runtime.shaded.org.apache.jute.Record;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.MultiOperationRecord;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.Op;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.common.PathUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.common.StringUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.common.Time;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.data.ACL;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.data.Id;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.data.StatPersisted;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.CreateRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.CreateTTLRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.DeleteRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.ReconfigRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.SetACLRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.proto.SetDataRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.DataNode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.DataTree;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.DigestCalculator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.EphemeralType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.Request;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.RequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ServerMetrics;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooTrace;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.auth.ServerAuthenticationProvider;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CheckVersionTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CloseSessionTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateContainerTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateTTLTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.DeleteTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.ErrorTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.MultiTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.SetACLTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.SetDataTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.Txn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.TxnDigest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PrepRequestProcessor.class);
    private static boolean failCreate = false;
    LinkedBlockingQueue<Request> submittedRequests = new LinkedBlockingQueue();
    private final RequestProcessor nextProcessor;
    private final boolean digestEnabled;
    private DigestCalculator digestCalculator;
    ZooKeeperServer zks;

    public PrepRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ProcessThread(sid:" + zks.getServerId() + " cport:" + zks.getClientPort() + "):", zks.getZooKeeperServerListener());
        this.nextProcessor = nextProcessor;
        this.zks = zks;
        this.digestEnabled = ZooKeeperServer.isDigestEnabled();
        if (this.digestEnabled) {
            this.digestCalculator = new DigestCalculator();
        }
    }

    public static void setFailCreate(boolean b) {
        failCreate = b;
    }

    @Override
    public void run() {
        LOG.info(String.format("PrepRequestProcessor (sid:%d) started, reconfigEnabled=%s", this.zks.getServerId(), this.zks.reconfigEnabled));
        try {
            while (true) {
                ServerMetrics.getMetrics().PREP_PROCESSOR_QUEUE_SIZE.add(this.submittedRequests.size());
                Request request = this.submittedRequests.take();
                ServerMetrics.getMetrics().PREP_PROCESSOR_QUEUE_TIME.add(Time.currentElapsedTime() - request.prepQueueStartTime);
                long traceMask = 2L;
                if (request.type == 11) {
                    traceMask = 8L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, traceMask, 'P', request, "");
                }
                if (Request.requestOfDeath != request) {
                    request.prepStartTime = Time.currentElapsedTime();
                    this.pRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("PrepRequestProcessor exited loop!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperServer.ChangeRecord getRecordForPath(String path) throws KeeperException.NoNodeException {
        ZooKeeperServer.ChangeRecord lastChange = null;
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            DataNode n;
            lastChange = this.zks.outstandingChangesForPath.get(path);
            if (lastChange == null && (n = this.zks.getZKDatabase().getNode(path)) != null) {
                Set<String> children;
                DataNode dataNode = n;
                synchronized (dataNode) {
                    children = n.getChildren();
                }
                lastChange = new ZooKeeperServer.ChangeRecord(-1L, path, n.stat, children.size(), this.zks.getZKDatabase().aclForNode(n));
                if (this.digestEnabled) {
                    lastChange.precalculatedDigest = new ZooKeeperServer.PrecalculatedDigest(this.digestCalculator.calculateDigest(path, n), 0L);
                }
                lastChange.data = n.getData();
            }
        }
        if (lastChange == null || lastChange.stat == null) {
            throw new KeeperException.NoNodeException(path);
        }
        return lastChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperServer.ChangeRecord getOutstandingChange(String path) {
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            return this.zks.outstandingChangesForPath.get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChangeRecord(ZooKeeperServer.ChangeRecord c) {
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            this.zks.outstandingChanges.add(c);
            this.zks.outstandingChangesForPath.put(c.path, c);
            ServerMetrics.getMetrics().OUTSTANDING_CHANGES_QUEUED.add(1L);
        }
    }

    private Map<String, ZooKeeperServer.ChangeRecord> getPendingChanges(MultiOperationRecord multiRequest) {
        HashMap<String, ZooKeeperServer.ChangeRecord> pendingChangeRecords = new HashMap<String, ZooKeeperServer.ChangeRecord>();
        for (Op op : multiRequest) {
            String parentPath;
            ZooKeeperServer.ChangeRecord parentCr;
            int lastSlash;
            String path = op.getPath();
            ZooKeeperServer.ChangeRecord cr = this.getOutstandingChange(path);
            if (cr != null) {
                pendingChangeRecords.put(path, cr);
            }
            if ((lastSlash = path.lastIndexOf(47)) == -1 || path.indexOf(0) != -1 || (parentCr = this.getOutstandingChange(parentPath = path.substring(0, lastSlash))) == null) continue;
            pendingChangeRecords.put(parentPath, parentCr);
        }
        return pendingChangeRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPendingChanges(long zxid, Map<String, ZooKeeperServer.ChangeRecord> pendingChangeRecords) {
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            Iterator<ZooKeeperServer.ChangeRecord> iter = this.zks.outstandingChanges.descendingIterator();
            while (iter.hasNext()) {
                ZooKeeperServer.ChangeRecord c = iter.next();
                if (c.zxid != zxid) break;
                iter.remove();
                this.zks.outstandingChangesForPath.remove(c.path);
            }
            if (this.zks.outstandingChanges.isEmpty()) {
                return;
            }
            long firstZxid = this.zks.outstandingChanges.peek().zxid;
            for (ZooKeeperServer.ChangeRecord c : pendingChangeRecords.values()) {
                if (c.zxid < firstZxid) continue;
                this.zks.outstandingChangesForPath.put(c.path, c);
            }
        }
    }

    private String validatePathForCreate(String path, long sessionId) throws KeeperException.BadArgumentsException {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1 || path.indexOf(0) != -1 || failCreate) {
            LOG.info("Invalid path {} with session 0x{}", (Object)path, (Object)Long.toHexString(sessionId));
            throw new KeeperException.BadArgumentsException(path);
        }
        return path.substring(0, lastSlash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pRequest2Txn(int type, long zxid, Request request, Record record, boolean deserialize) throws KeeperException, IOException, RequestProcessor.RequestProcessorException {
        if (request.getHdr() == null) {
            request.setHdr(new TxnHeader(request.sessionId, request.cxid, zxid, Time.currentWallTime(), type));
        }
        switch (type) {
            case 1: 
            case 15: 
            case 19: 
            case 21: {
                this.pRequest2TxnCreate(type, request, record, deserialize);
                break;
            }
            case 20: {
                String path = new String(request.request.array());
                String parentPath = this.getParentPathAndValidate(path);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                if (nodeRecord.childCount > 0) {
                    throw new KeeperException.NotEmptyException(path);
                }
                if (EphemeralType.get(nodeRecord.stat.getEphemeralOwner()) == EphemeralType.NORMAL) {
                    throw new KeeperException.BadVersionException(path);
                }
                ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                request.setTxn(new DeleteTxn(path));
                parentRecord = parentRecord.duplicate(request.getHdr().getZxid());
                --parentRecord.childCount;
                parentRecord.stat.setPzxid(request.getHdr().getZxid());
                parentRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, parentPath, parentRecord.data, parentRecord.stat);
                this.addChangeRecord(parentRecord);
                nodeRecord = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path, null, -1, null);
                nodeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.REMOVE, path);
                this.setTxnDigest(request, nodeRecord.precalculatedDigest);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case 2: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                DeleteRequest deleteRequest = (DeleteRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, deleteRequest);
                }
                String path = deleteRequest.getPath();
                String parentPath = this.getParentPathAndValidate(path);
                ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                this.zks.checkACL(request.cnxn, parentRecord.acl, 8, request.authInfo, path, null);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getVersion(), deleteRequest.getVersion(), path);
                if (nodeRecord.childCount > 0) {
                    throw new KeeperException.NotEmptyException(path);
                }
                request.setTxn(new DeleteTxn(path));
                parentRecord = parentRecord.duplicate(request.getHdr().getZxid());
                --parentRecord.childCount;
                parentRecord.stat.setPzxid(request.getHdr().getZxid());
                parentRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, parentPath, parentRecord.data, parentRecord.stat);
                this.addChangeRecord(parentRecord);
                nodeRecord = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path, null, -1, null);
                nodeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.REMOVE, path);
                this.setTxnDigest(request, nodeRecord.precalculatedDigest);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case 5: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetDataRequest setDataRequest = (SetDataRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, setDataRequest);
                }
                String path = setDataRequest.getPath();
                this.validatePath(path, request.sessionId);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                this.zks.checkACL(request.cnxn, nodeRecord.acl, 2, request.authInfo, path, null);
                int newVersion = PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getVersion(), setDataRequest.getVersion(), path);
                request.setTxn(new SetDataTxn(path, setDataRequest.getData(), newVersion));
                nodeRecord = nodeRecord.duplicate(request.getHdr().getZxid());
                nodeRecord.stat.setVersion(newVersion);
                nodeRecord.stat.setMtime(request.getHdr().getTime());
                nodeRecord.stat.setMzxid(zxid);
                nodeRecord.data = setDataRequest.getData();
                nodeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, path, nodeRecord.data, nodeRecord.stat);
                this.setTxnDigest(request, nodeRecord.precalculatedDigest);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case 16: {
                String msg;
                LeaderZooKeeperServer lzks;
                if (!this.zks.isReconfigEnabled()) {
                    LOG.error("Reconfig operation requested but reconfig feature is disabled.");
                    throw new KeeperException.ReconfigDisabledException();
                }
                if (ZooKeeperServer.skipACL) {
                    LOG.warn("skipACL is set, reconfig operation will skip ACL checks!");
                }
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                try {
                    lzks = (LeaderZooKeeperServer)this.zks;
                }
                catch (ClassCastException e) {
                    throw new KeeperException.UnimplementedException();
                }
                QuorumVerifier lastSeenQV = lzks.self.getLastSeenQuorumVerifier();
                if (lastSeenQV.getVersion() != lzks.self.getQuorumVerifier().getVersion()) {
                    throw new KeeperException.ReconfigInProgress();
                }
                ReconfigRequest reconfigRequest = (ReconfigRequest)record;
                long configId = reconfigRequest.getCurConfigId();
                if (configId != -1L && configId != lzks.self.getLastSeenQuorumVerifier().getVersion()) {
                    String msg2 = "Reconfiguration from version " + configId + " failed -- last seen version is " + lzks.self.getLastSeenQuorumVerifier().getVersion();
                    throw new KeeperException.BadVersionException(msg2);
                }
                String newMembers = reconfigRequest.getNewMembers();
                if (newMembers != null) {
                    LOG.info("Non-incremental reconfig");
                    newMembers = newMembers.replaceAll(",", "\n");
                    try {
                        Properties props = new Properties();
                        props.load(new StringReader(newMembers));
                        request.qv = QuorumPeerConfig.parseDynamicConfig(props, lzks.self.getElectionType(), true, false);
                        request.qv.setVersion(request.getHdr().getZxid());
                    }
                    catch (IOException | QuorumPeerConfig.ConfigException e) {
                        throw new KeeperException.BadArgumentsException(e.getMessage());
                    }
                }
                LOG.info("Incremental reconfig");
                List<String> joiningServers = null;
                String joiningServersString = reconfigRequest.getJoiningServers();
                if (joiningServersString != null) {
                    joiningServers = StringUtils.split(joiningServersString, ",");
                }
                List<String> leavingServers = null;
                String leavingServersString = reconfigRequest.getLeavingServers();
                if (leavingServersString != null) {
                    leavingServers = StringUtils.split(leavingServersString, ",");
                }
                if (!(lastSeenQV instanceof QuorumMaj)) {
                    String msg3 = "Incremental reconfiguration requested but last configuration seen has a non-majority quorum system";
                    LOG.warn(msg3);
                    throw new KeeperException.BadArgumentsException(msg3);
                }
                HashMap<Long, QuorumPeer.QuorumServer> nextServers = new HashMap<Long, QuorumPeer.QuorumServer>(lastSeenQV.getAllMembers());
                try {
                    if (leavingServers != null) {
                        for (String leaving : leavingServers) {
                            long sid = Long.parseLong(leaving);
                            nextServers.remove(sid);
                        }
                    }
                    if (joiningServers != null) {
                        for (String joiner : joiningServers) {
                            String[] parts = StringUtils.split(joiner, "=").toArray(new String[0]);
                            if (parts.length != 2) {
                                throw new KeeperException.BadArgumentsException("Wrong format of server string");
                            }
                            Long sid = Long.parseLong(parts[0].substring(parts[0].lastIndexOf(46) + 1));
                            QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer((long)sid, parts[1]);
                            if (qs.clientAddr == null || qs.electionAddr == null || qs.addr == null) {
                                throw new KeeperException.BadArgumentsException("Wrong format of server string - each server should have 3 ports specified");
                            }
                            for (QuorumPeer.QuorumServer nqs : nextServers.values()) {
                                if (qs.id == nqs.id) continue;
                                qs.checkAddressDuplicate(nqs);
                            }
                            nextServers.remove(qs.id);
                            nextServers.put(qs.id, qs);
                        }
                    }
                }
                catch (QuorumPeerConfig.ConfigException e) {
                    throw new KeeperException.BadArgumentsException("Reconfiguration failed");
                }
                request.qv = new QuorumMaj(nextServers);
                request.qv.setVersion(request.getHdr().getZxid());
                if (QuorumPeerConfig.isStandaloneEnabled() && request.qv.getVotingMembers().size() < 2) {
                    msg = "Reconfig failed - new configuration must include at least 2 followers";
                    LOG.warn(msg);
                    throw new KeeperException.BadArgumentsException(msg);
                }
                if (request.qv.getVotingMembers().size() < 1) {
                    msg = "Reconfig failed - new configuration must include at least 1 follower";
                    LOG.warn(msg);
                    throw new KeeperException.BadArgumentsException(msg);
                }
                if (!lzks.getLeader().isQuorumSynced(request.qv)) {
                    String msg2 = "Reconfig failed - there must be a connected and synced quorum in new configuration";
                    LOG.warn(msg2);
                    throw new KeeperException.NewConfigNoQuorum();
                }
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath("/zookeeper/config");
                this.zks.checkACL(request.cnxn, nodeRecord.acl, 2, request.authInfo, null, null);
                SetDataTxn setDataTxn = new SetDataTxn("/zookeeper/config", request.qv.toString().getBytes(), -1);
                request.setTxn(setDataTxn);
                nodeRecord = nodeRecord.duplicate(request.getHdr().getZxid());
                nodeRecord.stat.setVersion(-1);
                nodeRecord.stat.setMtime(request.getHdr().getTime());
                nodeRecord.stat.setMzxid(zxid);
                nodeRecord.data = setDataTxn.getData();
                nodeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.NOOP, "/zookeeper/config", nodeRecord.data, nodeRecord.stat);
                this.setTxnDigest(request, nodeRecord.precalculatedDigest);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case 7: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                SetACLRequest setAclRequest = (SetACLRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, setAclRequest);
                }
                String path = setAclRequest.getPath();
                this.validatePath(path, request.sessionId);
                List<ACL> listACL = PrepRequestProcessor.fixupACL(path, request.authInfo, setAclRequest.getAcl());
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                this.zks.checkACL(request.cnxn, nodeRecord.acl, 16, request.authInfo, path, listACL);
                int newVersion = PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getAversion(), setAclRequest.getVersion(), path);
                request.setTxn(new SetACLTxn(path, listACL, newVersion));
                nodeRecord = nodeRecord.duplicate(request.getHdr().getZxid());
                nodeRecord.stat.setAversion(newVersion);
                nodeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, path, nodeRecord.data, nodeRecord.stat);
                this.setTxnDigest(request, nodeRecord.precalculatedDigest);
                this.addChangeRecord(nodeRecord);
                break;
            }
            case -10: {
                request.request.rewind();
                int to = request.request.getInt();
                request.setTxn(new CreateSessionTxn(to));
                request.request.rewind();
                this.zks.sessionTracker.trackSession(request.sessionId, to);
                this.zks.setOwner(request.sessionId, request.getOwner());
                break;
            }
            case -11: {
                long startTime = Time.currentElapsedTime();
                Deque<ZooKeeperServer.ChangeRecord> joiner = this.zks.outstandingChanges;
                synchronized (joiner) {
                    Set<String> es = this.zks.getZKDatabase().getEphemerals(request.sessionId);
                    for (ZooKeeperServer.ChangeRecord c : this.zks.outstandingChanges) {
                        if (c.stat == null) {
                            es.remove(c.path);
                            continue;
                        }
                        if (c.stat.getEphemeralOwner() != request.sessionId) continue;
                        es.add(c.path);
                    }
                    for (String path2Delete : es) {
                        if (this.digestEnabled) {
                            String parentPath = this.getParentPathAndValidate(path2Delete);
                            ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                            parentRecord = parentRecord.duplicate(request.getHdr().getZxid());
                            parentRecord.stat.setPzxid(request.getHdr().getZxid());
                            parentRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, parentPath, parentRecord.data, parentRecord.stat);
                            this.addChangeRecord(parentRecord);
                        }
                        ZooKeeperServer.ChangeRecord nodeRecord = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path2Delete, null, 0, null);
                        nodeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.REMOVE, path2Delete);
                        this.addChangeRecord(nodeRecord);
                    }
                    if (ZooKeeperServer.isCloseSessionTxnEnabled()) {
                        request.setTxn(new CloseSessionTxn(new ArrayList<String>(es)));
                    }
                    this.zks.sessionTracker.setSessionClosing(request.sessionId);
                }
                ServerMetrics.getMetrics().CLOSE_SESSION_PREP_TIME.add(Time.currentElapsedTime() - startTime);
                break;
            }
            case 13: {
                this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                CheckVersionRequest checkVersionRequest = (CheckVersionRequest)record;
                if (deserialize) {
                    ByteBufferInputStream.byteBuffer2Record(request.request, checkVersionRequest);
                }
                String path = checkVersionRequest.getPath();
                this.validatePath(path, request.sessionId);
                ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                this.zks.checkACL(request.cnxn, nodeRecord.acl, 1, request.authInfo, path, null);
                request.setTxn(new CheckVersionTxn(path, PrepRequestProcessor.checkAndIncVersion(nodeRecord.stat.getVersion(), checkVersionRequest.getVersion(), path)));
                break;
            }
            default: {
                LOG.warn("unknown type {}", (Object)type);
            }
        }
        if (request.getTxnDigest() == null && this.digestEnabled) {
            this.setTxnDigest(request);
        }
    }

    private void pRequest2TxnCreate(int type, Request request, Record record, boolean deserialize) throws IOException, KeeperException {
        boolean ephemeralParent;
        long ttl;
        byte[] data;
        List<ACL> acl;
        String path;
        int flags;
        if (deserialize) {
            ByteBufferInputStream.byteBuffer2Record(request.request, record);
        }
        if (type == 21) {
            CreateTTLRequest createTtlRequest = (CreateTTLRequest)record;
            flags = createTtlRequest.getFlags();
            path = createTtlRequest.getPath();
            acl = createTtlRequest.getAcl();
            data = createTtlRequest.getData();
            ttl = createTtlRequest.getTtl();
        } else {
            CreateRequest createRequest = (CreateRequest)record;
            flags = createRequest.getFlags();
            path = createRequest.getPath();
            acl = createRequest.getAcl();
            data = createRequest.getData();
            ttl = -1L;
        }
        CreateMode createMode = CreateMode.fromFlag(flags);
        this.validateCreateRequest(path, createMode, request, ttl);
        String parentPath = this.validatePathForCreate(path, request.sessionId);
        List<ACL> listACL = PrepRequestProcessor.fixupACL(path, request.authInfo, acl);
        ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
        this.zks.checkACL(request.cnxn, parentRecord.acl, 4, request.authInfo, path, listACL);
        int parentCVersion = parentRecord.stat.getCversion();
        if (createMode.isSequential()) {
            path = path + String.format(Locale.ENGLISH, "%010d", parentCVersion);
        }
        this.validatePath(path, request.sessionId);
        try {
            if (this.getRecordForPath(path) != null) {
                throw new KeeperException.NodeExistsException(path);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        boolean bl = ephemeralParent = EphemeralType.get(parentRecord.stat.getEphemeralOwner()) == EphemeralType.NORMAL;
        if (ephemeralParent) {
            throw new KeeperException.NoChildrenForEphemeralsException(path);
        }
        int newCversion = parentRecord.stat.getCversion() + 1;
        if (type == 19) {
            request.setTxn(new CreateContainerTxn(path, data, listACL, newCversion));
        } else if (type == 21) {
            request.setTxn(new CreateTTLTxn(path, data, listACL, newCversion, ttl));
        } else {
            request.setTxn(new CreateTxn(path, data, listACL, createMode.isEphemeral(), newCversion));
        }
        TxnHeader hdr = request.getHdr();
        long ephemeralOwner = 0L;
        if (createMode.isContainer()) {
            ephemeralOwner = Long.MIN_VALUE;
        } else if (createMode.isTTL()) {
            ephemeralOwner = EphemeralType.TTL.toEphemeralOwner(ttl);
        } else if (createMode.isEphemeral()) {
            ephemeralOwner = request.sessionId;
        }
        StatPersisted s = DataTree.createStat(hdr.getZxid(), hdr.getTime(), ephemeralOwner);
        parentRecord = parentRecord.duplicate(request.getHdr().getZxid());
        ++parentRecord.childCount;
        parentRecord.stat.setCversion(newCversion);
        parentRecord.stat.setPzxid(request.getHdr().getZxid());
        parentRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.UPDATE, parentPath, parentRecord.data, parentRecord.stat);
        this.addChangeRecord(parentRecord);
        ZooKeeperServer.ChangeRecord nodeRecord = new ZooKeeperServer.ChangeRecord(request.getHdr().getZxid(), path, s, 0, listACL);
        nodeRecord.data = data;
        nodeRecord.precalculatedDigest = this.precalculateDigest(DigestOpCode.ADD, path, nodeRecord.data, s);
        this.setTxnDigest(request, nodeRecord.precalculatedDigest);
        this.addChangeRecord(nodeRecord);
    }

    private void validatePath(String path, long sessionId) throws KeeperException.BadArgumentsException {
        try {
            PathUtils.validatePath(path);
        }
        catch (IllegalArgumentException ie) {
            LOG.info("Invalid path {} with session 0x{}, reason: {}", new Object[]{path, Long.toHexString(sessionId), ie.getMessage()});
            throw new KeeperException.BadArgumentsException(path);
        }
    }

    private String getParentPathAndValidate(String path) throws KeeperException.BadArgumentsException {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1 || path.indexOf(0) != -1 || this.zks.getZKDatabase().isSpecialPath(path)) {
            throw new KeeperException.BadArgumentsException(path);
        }
        return path.substring(0, lastSlash);
    }

    private static int checkAndIncVersion(int currentVersion, int expectedVersion, String path) throws KeeperException.BadVersionException {
        if (expectedVersion != -1 && expectedVersion != currentVersion) {
            throw new KeeperException.BadVersionException(path);
        }
        return currentVersion + 1;
    }

    protected void pRequest(Request request) throws RequestProcessor.RequestProcessorException {
        block40: {
            request.setHdr(null);
            request.setTxn(null);
            try {
                switch (request.type) {
                    case 1: 
                    case 15: 
                    case 19: {
                        CreateRequest create2Request = new CreateRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, create2Request, true);
                        break;
                    }
                    case 21: {
                        CreateTTLRequest createTtlRequest = new CreateTTLRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, createTtlRequest, true);
                        break;
                    }
                    case 2: 
                    case 20: {
                        DeleteRequest deleteRequest = new DeleteRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, deleteRequest, true);
                        break;
                    }
                    case 5: {
                        SetDataRequest setDataRequest = new SetDataRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setDataRequest, true);
                        break;
                    }
                    case 16: {
                        ReconfigRequest reconfigRequest = new ReconfigRequest();
                        ByteBufferInputStream.byteBuffer2Record(request.request, reconfigRequest);
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, reconfigRequest, true);
                        break;
                    }
                    case 7: {
                        SetACLRequest setAclRequest = new SetACLRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, setAclRequest, true);
                        break;
                    }
                    case 13: {
                        CheckVersionRequest checkRequest = new CheckVersionRequest();
                        this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, checkRequest, true);
                        break;
                    }
                    case 14: {
                        MultiOperationRecord multiRequest = new MultiOperationRecord();
                        try {
                            ByteBufferInputStream.byteBuffer2Record(request.request, multiRequest);
                        }
                        catch (IOException e) {
                            request.setHdr(new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), Time.currentWallTime(), 14));
                            throw e;
                        }
                        ArrayList<Txn> txns = new ArrayList<Txn>();
                        long zxid = this.zks.getNextZxid();
                        KeeperException ke = null;
                        Map<String, ZooKeeperServer.ChangeRecord> pendingChanges = this.getPendingChanges(multiRequest);
                        request.setHdr(new TxnHeader(request.sessionId, request.cxid, zxid, Time.currentWallTime(), request.type));
                        for (Op op : multiRequest) {
                            Record txn;
                            int type;
                            Record subrequest = op.toRequestRecord();
                            if (ke != null) {
                                type = -1;
                                txn = new ErrorTxn(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
                            } else {
                                try {
                                    this.pRequest2Txn(op.getType(), zxid, request, subrequest, false);
                                    type = op.getType();
                                    txn = request.getTxn();
                                }
                                catch (KeeperException e) {
                                    ke = e;
                                    type = -1;
                                    txn = new ErrorTxn(e.code().intValue());
                                    if (e.code().intValue() > KeeperException.Code.APIERROR.intValue()) {
                                        LOG.info("Got user-level KeeperException when processing {} aborting remaining multi ops. Error Path:{} Error:{}", new Object[]{request.toString(), e.getPath(), e.getMessage()});
                                    }
                                    request.setException(e);
                                    this.rollbackPendingChanges(zxid, pendingChanges);
                                }
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            Throwable throwable = null;
                            try {
                                BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
                                txn.serialize(boa, "request");
                                ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
                                txns.add(new Txn(type, bb.array()));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (baos == null) continue;
                                if (throwable != null) {
                                    try {
                                        baos.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                baos.close();
                            }
                        }
                        request.setTxn(new MultiTxn(txns));
                        if (this.digestEnabled) {
                            this.setTxnDigest(request);
                        }
                        break;
                    }
                    case -11: 
                    case -10: {
                        if (!request.isLocalSession()) {
                            this.pRequest2Txn(request.type, this.zks.getNextZxid(), request, null, true);
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: 
                    case 22: 
                    case 101: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                        break;
                    }
                    default: {
                        LOG.warn("unknown type {}", (Object)request.type);
                        break;
                    }
                }
            }
            catch (KeeperException e) {
                if (request.getHdr() != null) {
                    request.getHdr().setType(-1);
                    request.setTxn(new ErrorTxn(e.code().intValue()));
                }
                if (e.code().intValue() > KeeperException.Code.APIERROR.intValue()) {
                    LOG.info("Got user-level KeeperException when processing {} Error Path:{} Error:{}", new Object[]{request.toString(), e.getPath(), e.getMessage()});
                }
                request.setException(e);
            }
            catch (Exception e) {
                LOG.error("Failed to process {}", (Object)request, (Object)e);
                StringBuilder sb = new StringBuilder();
                ByteBuffer bb = request.request;
                if (bb != null) {
                    bb.rewind();
                    while (bb.hasRemaining()) {
                        sb.append(Integer.toHexString(bb.get() & 0xFF));
                    }
                } else {
                    sb.append("request buffer is null");
                }
                LOG.error("Dumping request buffer: 0x{}", (Object)sb.toString());
                if (request.getHdr() == null) break block40;
                request.getHdr().setType(-1);
                request.setTxn(new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue()));
            }
        }
        request.zxid = this.zks.getZxid();
        ServerMetrics.getMetrics().PREP_PROCESS_TIME.add(Time.currentElapsedTime() - request.prepStartTime);
        this.nextProcessor.processRequest(request);
    }

    private static List<ACL> removeDuplicates(List<ACL> acls) {
        if (acls == null || acls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ACL> retval = new ArrayList<ACL>(acls.size());
        for (ACL acl : acls) {
            if (retval.contains(acl)) continue;
            retval.add(acl);
        }
        return retval;
    }

    private void validateCreateRequest(String path, CreateMode createMode, Request request, long ttl) throws KeeperException {
        if (createMode.isTTL() && !EphemeralType.extendedEphemeralTypesEnabled()) {
            throw new KeeperException.UnimplementedException();
        }
        try {
            EphemeralType.validateTTL(createMode, ttl);
        }
        catch (IllegalArgumentException e) {
            throw new KeeperException.BadArgumentsException(path);
        }
        if (createMode.isEphemeral()) {
            if (request.getException() != null) {
                throw request.getException();
            }
            this.zks.sessionTracker.checkGlobalSession(request.sessionId, request.getOwner());
        } else {
            this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
        }
    }

    public static List<ACL> fixupACL(String path, List<Id> authInfo, List<ACL> acls) throws KeeperException.InvalidACLException {
        List<ACL> uniqacls = PrepRequestProcessor.removeDuplicates(acls);
        if (uniqacls == null || uniqacls.size() == 0) {
            throw new KeeperException.InvalidACLException(path);
        }
        ArrayList<ACL> rv = new ArrayList<ACL>();
        for (ACL a : uniqacls) {
            LOG.debug("Processing ACL: {}", (Object)a);
            if (a == null) {
                throw new KeeperException.InvalidACLException(path);
            }
            Id id = a.getId();
            if (id == null || id.getScheme() == null) {
                throw new KeeperException.InvalidACLException(path);
            }
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) {
                rv.add(a);
                continue;
            }
            if (id.getScheme().equals("auth")) {
                boolean authIdValid = false;
                for (Id cid : authInfo) {
                    ServerAuthenticationProvider ap = ProviderRegistry.getServerProvider(cid.getScheme());
                    if (ap == null) {
                        LOG.error("Missing AuthenticationProvider for {}", (Object)cid.getScheme());
                        continue;
                    }
                    if (!ap.isAuthenticated()) continue;
                    authIdValid = true;
                    rv.add(new ACL(a.getPerms(), cid));
                }
                if (authIdValid) continue;
                throw new KeeperException.InvalidACLException(path);
            }
            ServerAuthenticationProvider ap = ProviderRegistry.getServerProvider(id.getScheme());
            if (ap == null || !ap.isValid(id.getId())) {
                throw new KeeperException.InvalidACLException(path);
            }
            rv.add(a);
        }
        return rv;
    }

    @Override
    public void processRequest(Request request) {
        request.prepQueueStartTime = Time.currentElapsedTime();
        this.submittedRequests.add(request);
        ServerMetrics.getMetrics().PREP_PROCESSOR_QUEUED.add(1L);
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.submittedRequests.clear();
        this.submittedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }

    private ZooKeeperServer.PrecalculatedDigest precalculateDigest(DigestOpCode type, String path, byte[] data, StatPersisted s) throws KeeperException.NoNodeException {
        long newNodeDigest;
        long prevNodeDigest;
        if (!this.digestEnabled) {
            return null;
        }
        switch (type) {
            case ADD: {
                prevNodeDigest = 0L;
                newNodeDigest = this.digestCalculator.calculateDigest(path, data, s);
                break;
            }
            case REMOVE: {
                prevNodeDigest = this.getRecordForPath((String)path).precalculatedDigest.nodeDigest;
                newNodeDigest = 0L;
                break;
            }
            case UPDATE: {
                prevNodeDigest = this.getRecordForPath((String)path).precalculatedDigest.nodeDigest;
                newNodeDigest = this.digestCalculator.calculateDigest(path, data, s);
                break;
            }
            case NOOP: {
                prevNodeDigest = 0L;
                newNodeDigest = 0L;
                break;
            }
            default: {
                return null;
            }
        }
        long treeDigest = this.getCurrentTreeDigest() - prevNodeDigest + newNodeDigest;
        return new ZooKeeperServer.PrecalculatedDigest(newNodeDigest, treeDigest);
    }

    private ZooKeeperServer.PrecalculatedDigest precalculateDigest(DigestOpCode type, String path) throws KeeperException.NoNodeException {
        return this.precalculateDigest(type, path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentTreeDigest() {
        long digest;
        Deque<ZooKeeperServer.ChangeRecord> deque = this.zks.outstandingChanges;
        synchronized (deque) {
            if (this.zks.outstandingChanges.isEmpty()) {
                digest = this.zks.getZKDatabase().getDataTree().getTreeDigest();
                LOG.debug("Digest got from data tree is: {}", (Object)digest);
            } else {
                digest = this.zks.outstandingChanges.peekLast().precalculatedDigest.treeDigest;
                LOG.debug("Digest got from outstandingChanges is: {}", (Object)digest);
            }
        }
        return digest;
    }

    private void setTxnDigest(Request request) {
        request.setTxnDigest(new TxnDigest(this.digestCalculator.getDigestVersion(), this.getCurrentTreeDigest()));
    }

    private void setTxnDigest(Request request, ZooKeeperServer.PrecalculatedDigest preCalculatedDigest) {
        if (preCalculatedDigest == null) {
            return;
        }
        request.setTxnDigest(new TxnDigest(this.digestCalculator.getDigestVersion(), preCalculatedDigest.treeDigest));
    }

    public static enum DigestOpCode {
        NOOP,
        ADD,
        REMOVE,
        UPDATE;

    }
}

