/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.common.util.RateLimitFunction;
import org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.MoreObjects;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;

public class RateLimiter
implements AutoCloseable {
    private final ScheduledExecutorService executorService;
    private long rateTime;
    private TimeUnit timeUnit;
    private final boolean externalExecutor;
    private ScheduledFuture<?> renewTask;
    private volatile long permits;
    private volatile long acquiredPermits;
    private boolean isClosed;
    private Supplier<Long> permitUpdater;
    private RateLimitFunction rateLimitFunction;
    private boolean isDispatchOrPrecisePublishRateLimiter;

    RateLimiter(ScheduledExecutorService scheduledExecutorService, long permits, long rateTime, TimeUnit timeUnit, Supplier<Long> permitUpdater, boolean isDispatchOrPrecisePublishRateLimiter, RateLimitFunction rateLimitFunction) {
        Preconditions.checkArgument(permits > 0L, "rate must be > 0");
        Preconditions.checkArgument(rateTime > 0L, "Renew permit time must be > 0");
        this.rateTime = rateTime;
        this.timeUnit = timeUnit;
        this.permits = permits;
        this.permitUpdater = permitUpdater;
        this.isDispatchOrPrecisePublishRateLimiter = isDispatchOrPrecisePublishRateLimiter;
        if (scheduledExecutorService != null) {
            this.executorService = scheduledExecutorService;
            this.externalExecutor = true;
        } else {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
            executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executorService = executor;
            this.externalExecutor = false;
        }
        this.rateLimitFunction = rateLimitFunction;
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            if (!this.externalExecutor) {
                this.executorService.shutdownNow();
            }
            if (this.renewTask != null) {
                this.renewTask.cancel(false);
            }
            this.isClosed = true;
            if (this.rateLimitFunction != null) {
                this.rateLimitFunction.apply();
            }
        }
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void acquire() throws InterruptedException {
        this.acquire(1L);
    }

    public synchronized void acquire(long acquirePermit) throws InterruptedException {
        Preconditions.checkArgument(!this.isClosed(), "Rate limiter is already shutdown");
        Preconditions.checkArgument(acquirePermit <= this.permits, "acquiring permits must be less or equal than initialized rate =" + this.permits);
        if (this.renewTask == null) {
            this.renewTask = this.createTask();
        }
        boolean canAcquire = false;
        do {
            boolean bl = canAcquire = acquirePermit < 0L || this.acquiredPermits < this.permits;
            if (!canAcquire) {
                this.wait();
                continue;
            }
            this.acquiredPermits += acquirePermit;
        } while (!canAcquire);
    }

    public synchronized boolean tryAcquire() {
        return this.tryAcquire(1L);
    }

    public synchronized boolean tryAcquire(long acquirePermit) {
        boolean canAcquire;
        Preconditions.checkArgument(!this.isClosed(), "Rate limiter is already shutdown");
        if (this.renewTask == null) {
            this.renewTask = this.createTask();
        }
        boolean bl = canAcquire = acquirePermit < 0L || this.acquiredPermits < this.permits;
        if (this.isDispatchOrPrecisePublishRateLimiter) {
            this.acquiredPermits += acquirePermit;
            canAcquire = acquirePermit < 0L || this.acquiredPermits < this.permits;
        } else {
            if (acquirePermit + this.acquiredPermits > this.permits) {
                return false;
            }
            if (canAcquire) {
                this.acquiredPermits += acquirePermit;
            }
        }
        return canAcquire;
    }

    public long getAvailablePermits() {
        return Math.max(0L, this.permits - this.acquiredPermits);
    }

    public synchronized void setRate(long permits) {
        this.permits = permits;
    }

    public synchronized void setRate(long permits, long rateTime, TimeUnit timeUnit, Supplier<Long> permitUpdaterByte) {
        if (this.renewTask != null) {
            this.renewTask.cancel(false);
        }
        this.permits = permits;
        this.rateTime = rateTime;
        this.timeUnit = timeUnit;
        this.permitUpdater = permitUpdaterByte;
        this.renewTask = this.createTask();
    }

    public synchronized long getRate() {
        return this.permits;
    }

    public synchronized long getRateTime() {
        return this.rateTime;
    }

    public synchronized TimeUnit getRateTimeUnit() {
        return this.timeUnit;
    }

    protected ScheduledFuture<?> createTask() {
        return this.executorService.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(this::renew), this.rateTime, this.rateTime, this.timeUnit);
    }

    synchronized void renew() {
        long newPermitRate;
        long l = this.acquiredPermits = this.isDispatchOrPrecisePublishRateLimiter ? Math.max(0L, this.acquiredPermits - this.permits) : 0L;
        if (this.permitUpdater != null && (newPermitRate = this.permitUpdater.get().longValue()) > 0L) {
            this.setRate(newPermitRate);
        }
        if (this.rateLimitFunction != null && this.getAvailablePermits() > 0L) {
            this.rateLimitFunction.apply();
        }
        this.notifyAll();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rateTime", this.rateTime).add("permits", this.permits).add("acquiredPermits", this.acquiredPermits).toString();
    }

    public static RateLimiterBuilder builder() {
        return new RateLimiterBuilder();
    }

    public static class RateLimiterBuilder {
        private ScheduledExecutorService scheduledExecutorService;
        private long permits;
        private Supplier<Long> permitUpdater;
        private boolean isDispatchOrPrecisePublishRateLimiter;
        private RateLimitFunction rateLimitFunction;
        private long rateTime = 1L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;

        RateLimiterBuilder() {
        }

        public RateLimiterBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public RateLimiterBuilder permits(long permits) {
            this.permits = permits;
            return this;
        }

        public RateLimiterBuilder rateTime(long rateTime) {
            this.rateTime = rateTime;
            return this;
        }

        public RateLimiterBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public RateLimiterBuilder permitUpdater(Supplier<Long> permitUpdater) {
            this.permitUpdater = permitUpdater;
            return this;
        }

        public RateLimiterBuilder isDispatchOrPrecisePublishRateLimiter(boolean isDispatchOrPrecisePublishRateLimiter) {
            this.isDispatchOrPrecisePublishRateLimiter = isDispatchOrPrecisePublishRateLimiter;
            return this;
        }

        public RateLimiterBuilder rateLimitFunction(RateLimitFunction rateLimitFunction) {
            this.rateLimitFunction = rateLimitFunction;
            return this;
        }

        public RateLimiter build() {
            return new RateLimiter(this.scheduledExecutorService, this.permits, this.rateTime, this.timeUnit, this.permitUpdater, this.isDispatchOrPrecisePublishRateLimiter, this.rateLimitFunction);
        }

        public String toString() {
            return "RateLimiter.RateLimiterBuilder(scheduledExecutorService=" + this.scheduledExecutorService + ", permits=" + this.permits + ", rateTime=" + this.rateTime + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", permitUpdater=" + this.permitUpdater + ", isDispatchOrPrecisePublishRateLimiter=" + this.isDispatchOrPrecisePublishRateLimiter + ", rateLimitFunction=" + this.rateLimitFunction + ")";
        }
    }
}

