/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.process;

import java.nio.file.Paths;
import java.util.Optional;
import org.apache.pulsar.functions.auth.FunctionAuthProvider;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.runtime.RuntimeCustomizer;
import org.apache.pulsar.functions.runtime.RuntimeFactory;
import org.apache.pulsar.functions.runtime.RuntimeUtils;
import org.apache.pulsar.functions.runtime.process.ProcessRuntime;
import org.apache.pulsar.functions.runtime.process.ProcessRuntimeFactoryConfig;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;
import org.apache.pulsar.functions.worker.ConnectorsManager;
import org.apache.pulsar.functions.worker.FunctionsManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRuntimeFactory
implements RuntimeFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessRuntimeFactory.class);
    private String pulsarServiceUrl;
    private String pulsarWebServiceUrl;
    private String stateStorageServiceUrl;
    private boolean authenticationEnabled;
    private AuthenticationConfig authConfig;
    private String javaInstanceJarFile;
    private String pythonInstanceFile;
    private String logDirectory;
    private String extraDependenciesDir;
    private String narExtractionDirectory;
    private SecretsProviderConfigurator secretsProviderConfigurator;
    private Optional<FunctionAuthProvider> authProvider;
    private Optional<RuntimeCustomizer> runtimeCustomizer;

    @VisibleForTesting
    public ProcessRuntimeFactory(String pulsarServiceUrl, String pulsarWebServiceUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, String javaInstanceJarFile, String pythonInstanceFile, String logDirectory, String extraDependenciesDir, String narExtractionDirectory, SecretsProviderConfigurator secretsProviderConfigurator, boolean authenticationEnabled, Optional<FunctionAuthProvider> functionAuthProvider, Optional<RuntimeCustomizer> runtimeCustomizer) {
        this.initialize(pulsarServiceUrl, pulsarWebServiceUrl, stateStorageServiceUrl, authConfig, javaInstanceJarFile, pythonInstanceFile, logDirectory, extraDependenciesDir, narExtractionDirectory, secretsProviderConfigurator, authenticationEnabled, functionAuthProvider, runtimeCustomizer);
    }

    @Override
    public void initialize(WorkerConfig workerConfig, AuthenticationConfig authenticationConfig, SecretsProviderConfigurator secretsProviderConfigurator, ConnectorsManager connectorsManager, FunctionsManager functionsManager, Optional<FunctionAuthProvider> authProvider, Optional<RuntimeCustomizer> runtimeCustomizer) {
        ProcessRuntimeFactoryConfig factoryConfig = RuntimeUtils.getRuntimeFunctionConfig(workerConfig.getFunctionRuntimeFactoryConfigs(), ProcessRuntimeFactoryConfig.class);
        this.initialize(workerConfig.getPulsarServiceUrl(), workerConfig.getPulsarWebServiceUrl(), workerConfig.getStateStorageServiceUrl(), authenticationConfig, factoryConfig.getJavaInstanceJarLocation(), factoryConfig.getPythonInstanceLocation(), factoryConfig.getLogDirectory(), factoryConfig.getExtraFunctionDependenciesDir(), workerConfig.getNarExtractionDirectory(), secretsProviderConfigurator, workerConfig.isAuthenticationEnabled(), authProvider, runtimeCustomizer);
    }

    private void initialize(String pulsarServiceUrl, String pulsarWebServiceUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, String javaInstanceJarFile, String pythonInstanceFile, String logDirectory, String extraDependenciesDir, String narExtractionDirectory, SecretsProviderConfigurator secretsProviderConfigurator, boolean authenticationEnabled, Optional<FunctionAuthProvider> functionAuthProvider, Optional<RuntimeCustomizer> runtimeCustomizer) {
        this.pulsarServiceUrl = pulsarServiceUrl;
        this.pulsarWebServiceUrl = pulsarWebServiceUrl;
        this.stateStorageServiceUrl = stateStorageServiceUrl;
        this.authConfig = authConfig;
        this.secretsProviderConfigurator = secretsProviderConfigurator;
        this.javaInstanceJarFile = javaInstanceJarFile;
        this.pythonInstanceFile = pythonInstanceFile;
        this.extraDependenciesDir = extraDependenciesDir;
        this.narExtractionDirectory = narExtractionDirectory;
        this.logDirectory = logDirectory;
        this.authenticationEnabled = authenticationEnabled;
        if (this.javaInstanceJarFile == null) {
            String envJavaInstanceJarLocation = System.getProperty("pulsar.functions.java.instance.jar");
            if (null != envJavaInstanceJarLocation) {
                log.info("Java instance jar location is not defined, using the location defined in system environment : {}", (Object)envJavaInstanceJarLocation);
                this.javaInstanceJarFile = envJavaInstanceJarLocation;
            } else {
                throw new RuntimeException("No JavaInstanceJar specified");
            }
        }
        if (this.pythonInstanceFile == null) {
            String envPythonInstanceLocation = System.getProperty("pulsar.functions.python.instance.file");
            if (null != envPythonInstanceLocation) {
                log.info("Python instance file location is not defined using the location defined in system environment : {}", (Object)envPythonInstanceLocation);
                this.pythonInstanceFile = envPythonInstanceLocation;
            } else {
                throw new RuntimeException("No PythonInstanceFile specified");
            }
        }
        if (this.logDirectory == null) {
            String envProcessContainerLogDirectory = System.getProperty("pulsar.functions.process.container.log.dir");
            this.logDirectory = null != envProcessContainerLogDirectory ? envProcessContainerLogDirectory : Paths.get("logs", new String[0]).toFile().getAbsolutePath();
        }
        this.logDirectory = this.logDirectory + "/functions";
        if (this.extraDependenciesDir == null) {
            String envProcessContainerExtraDependenciesDir = System.getProperty("pulsar.functions.extra.dependencies.dir");
            if (null != envProcessContainerExtraDependenciesDir) {
                log.info("Extra dependencies location is not defined using the location defined in system environment : {}", (Object)envProcessContainerExtraDependenciesDir);
                this.extraDependenciesDir = envProcessContainerExtraDependenciesDir;
            } else {
                log.info("No extra dependencies location is defined in either function worker config or system environment");
            }
        }
        this.authProvider = functionAuthProvider;
        this.runtimeCustomizer = runtimeCustomizer;
    }

    @Override
    public ProcessRuntime createContainer(InstanceConfig instanceConfig, String codeFile, String originalCodeFileName, Long expectedHealthCheckInterval) throws Exception {
        String instanceFile = null;
        switch (instanceConfig.getFunctionDetails().getRuntime()) {
            case JAVA: {
                instanceFile = this.javaInstanceJarFile;
                break;
            }
            case PYTHON: {
                instanceFile = this.pythonInstanceFile;
                break;
            }
            case GO: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Runtime " + instanceConfig.getFunctionDetails().getRuntime());
            }
        }
        if (this.authenticationEnabled) {
            this.authProvider.ifPresent(functionAuthProvider -> functionAuthProvider.configureAuthenticationConfig(this.authConfig, Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(instanceConfig.getFunctionAuthenticationSpec())))));
        }
        return new ProcessRuntime(instanceConfig, instanceFile, this.extraDependenciesDir, this.narExtractionDirectory, this.logDirectory, codeFile, this.pulsarServiceUrl, this.stateStorageServiceUrl, this.authConfig, this.secretsProviderConfigurator, expectedHealthCheckInterval, this.pulsarWebServiceUrl);
    }

    public Optional<FunctionAuthProvider> getAuthProvider() {
        return this.authProvider;
    }

    public Optional<RuntimeCustomizer> getRuntimeCustomizer() {
        return this.runtimeCustomizer;
    }

    @Override
    public void close() {
    }

    public ProcessRuntimeFactory() {
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getPulsarWebServiceUrl() {
        return this.pulsarWebServiceUrl;
    }

    public String getStateStorageServiceUrl() {
        return this.stateStorageServiceUrl;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public AuthenticationConfig getAuthConfig() {
        return this.authConfig;
    }

    public String getJavaInstanceJarFile() {
        return this.javaInstanceJarFile;
    }

    public String getPythonInstanceFile() {
        return this.pythonInstanceFile;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public String getExtraDependenciesDir() {
        return this.extraDependenciesDir;
    }

    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    public SecretsProviderConfigurator getSecretsProviderConfigurator() {
        return this.secretsProviderConfigurator;
    }

    public void setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
    }

    public void setPulsarWebServiceUrl(String pulsarWebServiceUrl) {
        this.pulsarWebServiceUrl = pulsarWebServiceUrl;
    }

    public void setStateStorageServiceUrl(String stateStorageServiceUrl) {
        this.stateStorageServiceUrl = stateStorageServiceUrl;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setAuthConfig(AuthenticationConfig authConfig) {
        this.authConfig = authConfig;
    }

    public void setJavaInstanceJarFile(String javaInstanceJarFile) {
        this.javaInstanceJarFile = javaInstanceJarFile;
    }

    public void setPythonInstanceFile(String pythonInstanceFile) {
        this.pythonInstanceFile = pythonInstanceFile;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public void setExtraDependenciesDir(String extraDependenciesDir) {
        this.extraDependenciesDir = extraDependenciesDir;
    }

    public void setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
    }

    public void setSecretsProviderConfigurator(SecretsProviderConfigurator secretsProviderConfigurator) {
        this.secretsProviderConfigurator = secretsProviderConfigurator;
    }

    public void setAuthProvider(Optional<FunctionAuthProvider> authProvider) {
        this.authProvider = authProvider;
    }

    public void setRuntimeCustomizer(Optional<RuntimeCustomizer> runtimeCustomizer) {
        this.runtimeCustomizer = runtimeCustomizer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessRuntimeFactory)) {
            return false;
        }
        ProcessRuntimeFactory other = (ProcessRuntimeFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthenticationEnabled() != other.isAuthenticationEnabled()) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        String other$pulsarWebServiceUrl = other.getPulsarWebServiceUrl();
        if (this$pulsarWebServiceUrl == null ? other$pulsarWebServiceUrl != null : !this$pulsarWebServiceUrl.equals(other$pulsarWebServiceUrl)) {
            return false;
        }
        String this$stateStorageServiceUrl = this.getStateStorageServiceUrl();
        String other$stateStorageServiceUrl = other.getStateStorageServiceUrl();
        if (this$stateStorageServiceUrl == null ? other$stateStorageServiceUrl != null : !this$stateStorageServiceUrl.equals(other$stateStorageServiceUrl)) {
            return false;
        }
        AuthenticationConfig this$authConfig = this.getAuthConfig();
        AuthenticationConfig other$authConfig = other.getAuthConfig();
        if (this$authConfig == null ? other$authConfig != null : !((Object)this$authConfig).equals(other$authConfig)) {
            return false;
        }
        String this$javaInstanceJarFile = this.getJavaInstanceJarFile();
        String other$javaInstanceJarFile = other.getJavaInstanceJarFile();
        if (this$javaInstanceJarFile == null ? other$javaInstanceJarFile != null : !this$javaInstanceJarFile.equals(other$javaInstanceJarFile)) {
            return false;
        }
        String this$pythonInstanceFile = this.getPythonInstanceFile();
        String other$pythonInstanceFile = other.getPythonInstanceFile();
        if (this$pythonInstanceFile == null ? other$pythonInstanceFile != null : !this$pythonInstanceFile.equals(other$pythonInstanceFile)) {
            return false;
        }
        String this$logDirectory = this.getLogDirectory();
        String other$logDirectory = other.getLogDirectory();
        if (this$logDirectory == null ? other$logDirectory != null : !this$logDirectory.equals(other$logDirectory)) {
            return false;
        }
        String this$extraDependenciesDir = this.getExtraDependenciesDir();
        String other$extraDependenciesDir = other.getExtraDependenciesDir();
        if (this$extraDependenciesDir == null ? other$extraDependenciesDir != null : !this$extraDependenciesDir.equals(other$extraDependenciesDir)) {
            return false;
        }
        String this$narExtractionDirectory = this.getNarExtractionDirectory();
        String other$narExtractionDirectory = other.getNarExtractionDirectory();
        return !(this$narExtractionDirectory == null ? other$narExtractionDirectory != null : !this$narExtractionDirectory.equals(other$narExtractionDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessRuntimeFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthenticationEnabled() ? 79 : 97);
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        result = result * 59 + ($pulsarWebServiceUrl == null ? 43 : $pulsarWebServiceUrl.hashCode());
        String $stateStorageServiceUrl = this.getStateStorageServiceUrl();
        result = result * 59 + ($stateStorageServiceUrl == null ? 43 : $stateStorageServiceUrl.hashCode());
        AuthenticationConfig $authConfig = this.getAuthConfig();
        result = result * 59 + ($authConfig == null ? 43 : ((Object)$authConfig).hashCode());
        String $javaInstanceJarFile = this.getJavaInstanceJarFile();
        result = result * 59 + ($javaInstanceJarFile == null ? 43 : $javaInstanceJarFile.hashCode());
        String $pythonInstanceFile = this.getPythonInstanceFile();
        result = result * 59 + ($pythonInstanceFile == null ? 43 : $pythonInstanceFile.hashCode());
        String $logDirectory = this.getLogDirectory();
        result = result * 59 + ($logDirectory == null ? 43 : $logDirectory.hashCode());
        String $extraDependenciesDir = this.getExtraDependenciesDir();
        result = result * 59 + ($extraDependenciesDir == null ? 43 : $extraDependenciesDir.hashCode());
        String $narExtractionDirectory = this.getNarExtractionDirectory();
        result = result * 59 + ($narExtractionDirectory == null ? 43 : $narExtractionDirectory.hashCode());
        return result;
    }

    public String toString() {
        return "ProcessRuntimeFactory(pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pulsarWebServiceUrl=" + this.getPulsarWebServiceUrl() + ", stateStorageServiceUrl=" + this.getStateStorageServiceUrl() + ", authenticationEnabled=" + this.isAuthenticationEnabled() + ", authConfig=" + this.getAuthConfig() + ", javaInstanceJarFile=" + this.getJavaInstanceJarFile() + ", pythonInstanceFile=" + this.getPythonInstanceFile() + ", logDirectory=" + this.getLogDirectory() + ", extraDependenciesDir=" + this.getExtraDependenciesDir() + ", narExtractionDirectory=" + this.getNarExtractionDirectory() + ")";
    }
}

