/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.Channel;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBookieInfoProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GetBookieInfoProcessorV3.class);

    public GetBookieInfoProcessorV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
    }

    private BookkeeperProtocol.GetBookieInfoResponse getGetBookieInfoResponse() {
        long startTimeNanos = MathUtils.nowInNano();
        BookkeeperProtocol.GetBookieInfoRequest getBookieInfoRequest = this.request.getGetBookieInfoRequest();
        long requested = getBookieInfoRequest.getRequested();
        BookkeeperProtocol.GetBookieInfoResponse.Builder getBookieInfoResponse = BookkeeperProtocol.GetBookieInfoResponse.newBuilder();
        if (!this.isVersionCompatible()) {
            getBookieInfoResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
            this.requestProcessor.getRequestStats().getGetBookieInfoStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
            return getBookieInfoResponse.build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received new getBookieInfo request: {}", (Object)this.request);
        }
        BookkeeperProtocol.StatusCode status = BookkeeperProtocol.StatusCode.EOK;
        long freeDiskSpace = 0L;
        long totalDiskSpace = 0L;
        try {
            if ((requested & 2L) != 0L) {
                freeDiskSpace = this.requestProcessor.getBookie().getTotalFreeSpace();
                getBookieInfoResponse.setFreeDiskSpace(freeDiskSpace);
            }
            if ((requested & 1L) != 0L) {
                totalDiskSpace = this.requestProcessor.getBookie().getTotalDiskSpace();
                getBookieInfoResponse.setTotalDiskCapacity(totalDiskSpace);
            }
            LOG.debug("FreeDiskSpace info is " + freeDiskSpace + " totalDiskSpace is: " + totalDiskSpace);
            this.requestProcessor.getRequestStats().getGetBookieInfoStats().registerSuccessfulEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        }
        catch (IOException e) {
            status = BookkeeperProtocol.StatusCode.EIO;
            LOG.error("IOException while getting  freespace/totalspace", (Throwable)e);
            this.requestProcessor.getRequestStats().getGetBookieInfoStats().registerFailedEvent(MathUtils.elapsedNanos(startTimeNanos), TimeUnit.NANOSECONDS);
        }
        getBookieInfoResponse.setStatus(status);
        return getBookieInfoResponse.build();
    }

    @Override
    public void safeRun() {
        BookkeeperProtocol.GetBookieInfoResponse getBookieInfoResponse = this.getGetBookieInfoResponse();
        this.sendResponse(getBookieInfoResponse);
    }

    private void sendResponse(BookkeeperProtocol.GetBookieInfoResponse getBookieInfoResponse) {
        BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(getBookieInfoResponse.getStatus()).setGetBookieInfoResponse(getBookieInfoResponse);
        this.sendResponse(response.getStatus(), response.build(), this.requestProcessor.getRequestStats().getGetBookieInfoRequestStats());
    }
}

