/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.source;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.functions.source.RecordWithEncryptionContext;
import org.apache.pulsar.functions.utils.FunctionCommon;

public class PulsarRecord<T>
implements RecordWithEncryptionContext<T> {
    private final String topicName;
    private final int partition;
    private final Message<T> message;
    private final Schema<T> schema;
    private final Runnable failFunction;
    private final Runnable ackFunction;
    private final Consumer<Boolean> customAckFunction;

    @Override
    public Optional<String> getKey() {
        if (this.message.hasKey()) {
            return Optional.of(this.message.getKey());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getTopicName() {
        return Optional.of(this.topicName);
    }

    @Override
    public Optional<Integer> getPartitionIndex() {
        return Optional.of(this.partition);
    }

    @Override
    public Optional<String> getPartitionId() {
        return Optional.of(String.format("%s-%s", this.topicName, this.partition));
    }

    @Override
    public Optional<Long> getRecordSequence() {
        return Optional.of(FunctionCommon.getSequenceId(this.message.getMessageId()));
    }

    @Override
    public T getValue() {
        return this.message.getValue();
    }

    @Override
    public Schema<T> getSchema() {
        return this.schema;
    }

    @Override
    public Optional<Long> getEventTime() {
        if (this.message.getEventTime() != 0L) {
            return Optional.of(this.message.getEventTime());
        }
        return Optional.empty();
    }

    public void cumulativeAck() {
        this.customAckFunction.accept(true);
    }

    public void individualAck() {
        this.customAckFunction.accept(false);
    }

    @Override
    public Optional<EncryptionContext> getEncryptionCtx() {
        return this.message.getEncryptionCtx();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.message.getProperties();
    }

    public MessageId getMessageId() {
        return this.message.getMessageId();
    }

    @Override
    public void ack() {
        this.ackFunction.run();
    }

    @Override
    public void fail() {
        this.failFunction.run();
    }

    @Override
    public Optional<Message<T>> getMessage() {
        return Optional.of(this.message);
    }

    PulsarRecord(String topicName, int partition, Message<T> message, Schema<T> schema, Runnable failFunction, Runnable ackFunction, Consumer<Boolean> customAckFunction) {
        this.topicName = topicName;
        this.partition = partition;
        this.message = message;
        this.schema = schema;
        this.failFunction = failFunction;
        this.ackFunction = ackFunction;
        this.customAckFunction = customAckFunction;
    }

    public static <T> PulsarRecordBuilder<T> builder() {
        return new PulsarRecordBuilder();
    }

    public int getPartition() {
        return this.partition;
    }

    public Runnable getFailFunction() {
        return this.failFunction;
    }

    public Runnable getAckFunction() {
        return this.ackFunction;
    }

    public Consumer<Boolean> getCustomAckFunction() {
        return this.customAckFunction;
    }

    public String toString() {
        return "PulsarRecord(topicName=" + this.getTopicName() + ", partition=" + this.getPartition() + ", message=" + this.getMessage() + ", schema=" + this.getSchema() + ", failFunction=" + this.getFailFunction() + ", ackFunction=" + this.getAckFunction() + ", customAckFunction=" + this.getCustomAckFunction() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarRecord)) {
            return false;
        }
        PulsarRecord other = (PulsarRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartition() != other.getPartition()) {
            return false;
        }
        Optional<String> this$topicName = this.getTopicName();
        Optional<String> other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !((Object)this$topicName).equals(other$topicName)) {
            return false;
        }
        Optional<Message<T>> this$message = this.getMessage();
        Optional<Message<T>> other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Schema<T> this$schema = this.getSchema();
        Schema<T> other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        Runnable this$failFunction = this.getFailFunction();
        Runnable other$failFunction = other.getFailFunction();
        if (this$failFunction == null ? other$failFunction != null : !this$failFunction.equals(other$failFunction)) {
            return false;
        }
        Runnable this$ackFunction = this.getAckFunction();
        Runnable other$ackFunction = other.getAckFunction();
        if (this$ackFunction == null ? other$ackFunction != null : !this$ackFunction.equals(other$ackFunction)) {
            return false;
        }
        Consumer<Boolean> this$customAckFunction = this.getCustomAckFunction();
        Consumer<Boolean> other$customAckFunction = other.getCustomAckFunction();
        return !(this$customAckFunction == null ? other$customAckFunction != null : !this$customAckFunction.equals(other$customAckFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartition();
        Optional<String> $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : ((Object)$topicName).hashCode());
        Optional<Message<T>> $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Schema<T> $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        Runnable $failFunction = this.getFailFunction();
        result = result * 59 + ($failFunction == null ? 43 : $failFunction.hashCode());
        Runnable $ackFunction = this.getAckFunction();
        result = result * 59 + ($ackFunction == null ? 43 : $ackFunction.hashCode());
        Consumer<Boolean> $customAckFunction = this.getCustomAckFunction();
        result = result * 59 + ($customAckFunction == null ? 43 : $customAckFunction.hashCode());
        return result;
    }

    public static class PulsarRecordBuilder<T> {
        private String topicName;
        private int partition;
        private Message<T> message;
        private Schema<T> schema;
        private Runnable failFunction;
        private Runnable ackFunction;
        private Consumer<Boolean> customAckFunction;

        PulsarRecordBuilder() {
        }

        public PulsarRecordBuilder<T> topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public PulsarRecordBuilder<T> partition(int partition) {
            this.partition = partition;
            return this;
        }

        public PulsarRecordBuilder<T> message(Message<T> message) {
            this.message = message;
            return this;
        }

        public PulsarRecordBuilder<T> schema(Schema<T> schema) {
            this.schema = schema;
            return this;
        }

        public PulsarRecordBuilder<T> failFunction(Runnable failFunction) {
            this.failFunction = failFunction;
            return this;
        }

        public PulsarRecordBuilder<T> ackFunction(Runnable ackFunction) {
            this.ackFunction = ackFunction;
            return this;
        }

        public PulsarRecordBuilder<T> customAckFunction(Consumer<Boolean> customAckFunction) {
            this.customAckFunction = customAckFunction;
            return this;
        }

        public PulsarRecord<T> build() {
            return new PulsarRecord<T>(this.topicName, this.partition, this.message, this.schema, this.failFunction, this.ackFunction, this.customAckFunction);
        }

        public String toString() {
            return "PulsarRecord.PulsarRecordBuilder(topicName=" + this.topicName + ", partition=" + this.partition + ", message=" + this.message + ", schema=" + this.schema + ", failFunction=" + this.failFunction + ", ackFunction=" + this.ackFunction + ", customAckFunction=" + this.customAckFunction + ")";
        }
    }
}

