/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.SourceContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(IOConfigUtils.class);

    public static <T> T loadWithSecrets(Map<String, Object> map, Class<T> clazz, SourceContext sourceContext) {
        return IOConfigUtils.loadWithSecrets(map, clazz, (String secretName) -> sourceContext.getSecret((String)secretName));
    }

    public static <T> T loadWithSecrets(Map<String, Object> map, Class<T> clazz, SinkContext sinkContext) {
        return IOConfigUtils.loadWithSecrets(map, clazz, (String secretName) -> sinkContext.getSecret((String)secretName));
    }

    public static Map<String, Object> loadConfigFromJsonString(String config) throws JsonProcessingException {
        if (!StringUtils.isBlank(config)) {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readValue(config, new TypeReference<Map<String, Object>>(){});
        }
        return Collections.emptyMap();
    }

    private static <T> T loadWithSecrets(Map<String, Object> map, Class<T> clazz, Function<String, String> secretsGetter) {
        HashMap<String, Object> configs = new HashMap<String, Object>(map);
        block2: for (Field field : Reflections.getAllFields(clazz)) {
            field.setAccessible(true);
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().equals(FieldDoc.class)) continue;
                FieldDoc fieldDoc = (FieldDoc)annotation;
                if (fieldDoc.sensitive()) {
                    String secret;
                    try {
                        secret = secretsGetter.apply(field.getName());
                    }
                    catch (Exception e) {
                        log.warn("Failed to read secret {}", (Object)field.getName(), (Object)e);
                        continue block2;
                    }
                    if (secret != null) {
                        configs.put(field.getName(), secret);
                    }
                }
                configs.computeIfAbsent(field.getName(), key -> {
                    if (fieldDoc.required()) {
                        throw new IllegalArgumentException(field.getName() + " cannot be null");
                    }
                    String value = fieldDoc.defaultValue();
                    if (!StringUtils.isEmpty(value)) {
                        return value;
                    }
                    return null;
                });
            }
        }
        return new ObjectMapper().convertValue(configs, clazz);
    }
}

