/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import org.apache.pulsar.broker.authentication.AuthenticationDataCommand;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletRequest;

public class OneStageAuthenticationState
implements AuthenticationState {
    private final AuthenticationDataSource authenticationDataSource;
    private final String authRole;

    public OneStageAuthenticationState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession, AuthenticationProvider provider) throws AuthenticationException {
        this.authenticationDataSource = new AuthenticationDataCommand(new String(authData.getBytes(), StandardCharsets.UTF_8), remoteAddress, sslSession);
        this.authRole = provider.authenticate(this.authenticationDataSource);
    }

    public OneStageAuthenticationState(HttpServletRequest request, AuthenticationProvider provider) throws AuthenticationException {
        this.authenticationDataSource = new AuthenticationDataHttps(request);
        this.authRole = provider.authenticate(this.authenticationDataSource);
    }

    @Override
    public String getAuthRole() {
        return this.authRole;
    }

    @Override
    public AuthenticationDataSource getAuthDataSource() {
        return this.authenticationDataSource;
    }

    @Override
    public AuthData authenticate(AuthData authData) {
        return null;
    }

    @Override
    public boolean isComplete() {
        return true;
    }
}

