/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.Filter;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.FilterChain;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.FilterConfig;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletException;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletRequest;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletResponse;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableDebugHttpMethodFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DisableDebugHttpMethodFilter.class);
    private final ServiceConfiguration serviceConfiguration;

    public DisableDebugHttpMethodFilter(ServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.serviceConfiguration.isDisableHttpDebugMethods()) {
            if ("TRACE".equalsIgnoreCase(httpRequest.getMethod())) {
                httpResponse.setStatus(405);
                log.info("[{}] Rejected HTTP request using TRACE Method", (Object)request.getRemoteAddr());
                return;
            }
            if ("TRACK".equalsIgnoreCase(httpRequest.getMethod())) {
                httpResponse.setStatus(405);
                log.info("[{}] Rejected HTTP request using TRACK Method", (Object)request.getRemoteAddr());
                return;
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public void init(FilterConfig arg) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}

