/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.kubernetes;

import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.functions.auth.FunctionAuthProvider;
import org.apache.pulsar.functions.auth.FunctionAuthUtils;
import org.apache.pulsar.functions.auth.KubernetesFunctionAuthProvider;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.RuntimeCustomizer;
import org.apache.pulsar.functions.runtime.RuntimeFactory;
import org.apache.pulsar.functions.runtime.RuntimeUtils;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesManifestCustomizer;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntime;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntimeFactoryConfig;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.ApiClient;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.Configuration;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.apis.AppsV1Api;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.apis.CoreV1Api;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1ConfigMap;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.util.Config;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;
import org.apache.pulsar.functions.worker.ConnectorsManager;
import org.apache.pulsar.functions.worker.FunctionsManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesRuntimeFactory
implements RuntimeFactory {
    private static final Logger log = LoggerFactory.getLogger(KubernetesRuntimeFactory.class);
    static int numRetries = 5;
    static long sleepBetweenRetriesMs = 500L;
    private String k8Uri;
    private String jobNamespace;
    private String jobName;
    private String pulsarDockerImageName;
    private Map<String, String> functionDockerImages;
    private String imagePullPolicy;
    private String pulsarRootDir;
    private String configAdminCLI;
    private String pulsarAdminUrl;
    private String pulsarServiceUrl;
    private String pythonDependencyRepository;
    private String pythonExtraDependencyRepository;
    private String extraDependenciesDir;
    private String changeConfigMap;
    private String changeConfigMapNamespace;
    private int percentMemoryPadding;
    private double cpuOverCommitRatio;
    private double memoryOverCommitRatio;
    private Boolean submittingInsidePod;
    private Boolean installUserCodeDependencies;
    private Map<String, String> customLabels;
    private Integer expectedMetricsCollectionInterval;
    private String stateStorageServiceUri;
    private AuthenticationConfig authConfig;
    private String javaInstanceJarFile;
    private String pythonInstanceFile;
    private final String logDirectory = "logs/functions";
    private Resources functionInstanceMinResources;
    private Resources functionInstanceMaxResources;
    private Resources functionInstanceResourceGranularities;
    private boolean functionInstanceResourceChangeInLockStep;
    private boolean authenticationEnabled;
    private Integer grpcPort;
    private Integer metricsPort;
    private String narExtractionDirectory;
    private String functionInstanceClassPath;
    private String downloadDirectory;
    private int gracePeriodSeconds;
    private Timer changeConfigMapTimer;
    private AppsV1Api appsClient;
    private CoreV1Api coreClient;
    private SecretsProviderConfigurator secretsProviderConfigurator;
    private Optional<KubernetesFunctionAuthProvider> authProvider;
    private Optional<KubernetesManifestCustomizer> manifestCustomizer;
    private byte[] serverCaBytes;

    @Override
    public boolean externallyManaged() {
        return true;
    }

    @Override
    public void initialize(WorkerConfig workerConfig, AuthenticationConfig authenticationConfig, SecretsProviderConfigurator secretsProviderConfigurator, ConnectorsManager connectorsManager, FunctionsManager functionsManager, Optional<FunctionAuthProvider> functionAuthProvider, Optional<RuntimeCustomizer> runtimeCustomizer) {
        KubernetesRuntimeFactoryConfig factoryConfig = RuntimeUtils.getRuntimeFunctionConfig(workerConfig.getFunctionRuntimeFactoryConfigs(), KubernetesRuntimeFactoryConfig.class);
        this.k8Uri = factoryConfig.getK8Uri();
        this.jobNamespace = !StringUtils.isEmpty(factoryConfig.getJobNamespace()) ? factoryConfig.getJobNamespace() : "default";
        this.jobName = !StringUtils.isEmpty(factoryConfig.getJobName()) ? factoryConfig.getJobName() : null;
        this.pulsarDockerImageName = !StringUtils.isEmpty(factoryConfig.getPulsarDockerImageName()) ? factoryConfig.getPulsarDockerImageName() : "apachepulsar/pulsar";
        this.functionDockerImages = factoryConfig.getFunctionDockerImages();
        this.imagePullPolicy = !StringUtils.isEmpty(factoryConfig.getImagePullPolicy()) ? factoryConfig.getImagePullPolicy() : "IfNotPresent";
        this.pulsarRootDir = !StringUtils.isEmpty(factoryConfig.getPulsarRootDir()) ? factoryConfig.getPulsarRootDir() : "/pulsar";
        this.configAdminCLI = !StringUtils.isEmpty(factoryConfig.getConfigAdminCLI()) ? factoryConfig.getConfigAdminCLI() : "/bin/pulsar-admin";
        String string = this.downloadDirectory = StringUtils.isNotEmpty(workerConfig.getDownloadDirectory()) ? workerConfig.getDownloadDirectory() : this.pulsarRootDir;
        if (!Paths.get(this.downloadDirectory, new String[0]).isAbsolute()) {
            this.downloadDirectory = this.pulsarRootDir + "/" + this.downloadDirectory;
        }
        this.submittingInsidePod = factoryConfig.getSubmittingInsidePod();
        this.installUserCodeDependencies = factoryConfig.getInstallUserCodeDependencies();
        this.pythonDependencyRepository = factoryConfig.getPythonDependencyRepository();
        this.pythonExtraDependencyRepository = factoryConfig.getPythonExtraDependencyRepository();
        this.extraDependenciesDir = StringUtils.isNotEmpty(factoryConfig.getExtraFunctionDependenciesDir()) ? (Paths.get(factoryConfig.getExtraFunctionDependenciesDir(), new String[0]).isAbsolute() ? factoryConfig.getExtraFunctionDependenciesDir() : this.pulsarRootDir + "/" + factoryConfig.getExtraFunctionDependenciesDir()) : this.pulsarRootDir + "/instances/deps";
        this.customLabels = factoryConfig.getCustomLabels();
        this.percentMemoryPadding = factoryConfig.getPercentMemoryPadding();
        this.cpuOverCommitRatio = factoryConfig.getCpuOverCommitRatio();
        this.memoryOverCommitRatio = factoryConfig.getMemoryOverCommitRatio();
        this.gracePeriodSeconds = factoryConfig.getGracePeriodSeconds();
        this.pulsarServiceUrl = StringUtils.isEmpty(factoryConfig.getPulsarServiceUrl()) ? workerConfig.getPulsarServiceUrl() : factoryConfig.getPulsarServiceUrl();
        this.pulsarAdminUrl = StringUtils.isEmpty(factoryConfig.getPulsarAdminUrl()) ? workerConfig.getPulsarWebServiceUrl() : factoryConfig.getPulsarAdminUrl();
        this.stateStorageServiceUri = workerConfig.getStateStorageServiceUrl();
        this.authConfig = authenticationConfig;
        this.expectedMetricsCollectionInterval = factoryConfig.getExpectedMetricsCollectionInterval() == null ? -1 : factoryConfig.getExpectedMetricsCollectionInterval();
        this.changeConfigMap = factoryConfig.getChangeConfigMap();
        this.changeConfigMapNamespace = factoryConfig.getChangeConfigMapNamespace();
        this.functionInstanceMinResources = workerConfig.getFunctionInstanceMinResources();
        this.functionInstanceMaxResources = workerConfig.getFunctionInstanceMaxResources();
        this.functionInstanceResourceGranularities = workerConfig.getFunctionInstanceResourceGranularities();
        this.functionInstanceResourceChangeInLockStep = workerConfig.isFunctionInstanceResourceChangeInLockStep();
        this.secretsProviderConfigurator = secretsProviderConfigurator;
        this.authenticationEnabled = workerConfig.isAuthenticationEnabled();
        this.javaInstanceJarFile = this.pulsarRootDir + "/instances/java-instance.jar";
        this.pythonInstanceFile = this.pulsarRootDir + "/instances/python-instance/python_instance_main.py";
        this.serverCaBytes = workerConfig.getTlsTrustChainBytes();
        try {
            this.setupClient();
        }
        catch (Exception e) {
            log.error("Failed to setup client", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (runtimeCustomizer.isPresent()) {
            if (!(runtimeCustomizer.get() instanceof KubernetesManifestCustomizer)) {
                throw new IllegalArgumentException("Function runtime customizer " + runtimeCustomizer.get().getClass().getName() + " must implement KubernetesManifestCustomizer");
            }
            KubernetesManifestCustomizer manifestCustomizer = (KubernetesManifestCustomizer)runtimeCustomizer.get();
            this.manifestCustomizer = Optional.of(manifestCustomizer);
        } else {
            this.manifestCustomizer = Optional.empty();
        }
        if (functionAuthProvider.isPresent()) {
            if (!(functionAuthProvider.get() instanceof KubernetesFunctionAuthProvider)) {
                throw new IllegalArgumentException("Function authentication provider " + functionAuthProvider.get().getClass().getName() + " must implement KubernetesFunctionAuthProvider");
            }
            KubernetesFunctionAuthProvider kubernetesFunctionAuthProvider = (KubernetesFunctionAuthProvider)functionAuthProvider.get();
            kubernetesFunctionAuthProvider.initialize(this.coreClient, this.serverCaBytes, funcDetails -> this.getRuntimeCustomizer().map(customizer -> customizer.customizeNamespace((Function.FunctionDetails)funcDetails, this.jobNamespace)).orElse(this.jobNamespace));
            this.authProvider = Optional.of(kubernetesFunctionAuthProvider);
        } else {
            this.authProvider = Optional.empty();
        }
        this.grpcPort = factoryConfig.getGrpcPort();
        this.metricsPort = factoryConfig.getMetricsPort();
        this.narExtractionDirectory = factoryConfig.getNarExtractionDirectory();
        this.functionInstanceClassPath = factoryConfig.getFunctionInstanceClassPath();
    }

    @Override
    public KubernetesRuntime createContainer(InstanceConfig instanceConfig, String codePkgUrl, String originalCodeFileName, Long expectedHealthCheckInterval) throws Exception {
        String instanceFile = null;
        switch (instanceConfig.getFunctionDetails().getRuntime()) {
            case JAVA: {
                instanceFile = this.javaInstanceJarFile;
                break;
            }
            case PYTHON: {
                instanceFile = this.pythonInstanceFile;
                break;
            }
            case GO: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Runtime " + instanceConfig.getFunctionDetails().getRuntime());
            }
        }
        if (this.authenticationEnabled) {
            this.authProvider.ifPresent(kubernetesFunctionAuthProvider -> kubernetesFunctionAuthProvider.configureAuthenticationConfig(this.authConfig, Optional.ofNullable(FunctionAuthUtils.getFunctionAuthData(Optional.ofNullable(instanceConfig.getFunctionAuthenticationSpec())))));
        }
        Optional<KubernetesManifestCustomizer> manifestCustomizer = this.getRuntimeCustomizer();
        String overriddenNamespace = manifestCustomizer.map(customizer -> customizer.customizeNamespace(instanceConfig.getFunctionDetails(), this.jobNamespace)).orElse(this.jobNamespace);
        String overriddenName = manifestCustomizer.map(customizer -> customizer.customizeName(instanceConfig.getFunctionDetails(), this.jobName)).orElse(this.jobName);
        if (this.grpcPort != null) {
            instanceConfig.setPort(this.grpcPort);
        }
        if (this.metricsPort != null) {
            instanceConfig.setMetricsPort(this.metricsPort);
        }
        return new KubernetesRuntime(this.appsClient, this.coreClient, overriddenNamespace, overriddenName, this.customLabels, this.installUserCodeDependencies, this.pythonDependencyRepository, this.pythonExtraDependencyRepository, this.pulsarDockerImageName, this.functionDockerImages, this.imagePullPolicy, this.pulsarRootDir, instanceConfig, instanceFile, this.extraDependenciesDir, "logs/functions", this.configAdminCLI, codePkgUrl, originalCodeFileName, this.pulsarServiceUrl, this.pulsarAdminUrl, this.stateStorageServiceUri, this.authConfig, this.secretsProviderConfigurator, this.expectedMetricsCollectionInterval, this.percentMemoryPadding, this.cpuOverCommitRatio, this.memoryOverCommitRatio, this.gracePeriodSeconds, this.authProvider, this.authenticationEnabled, this.grpcPort, this.narExtractionDirectory, manifestCustomizer, this.functionInstanceClassPath, this.downloadDirectory);
    }

    @Override
    public void close() {
    }

    @Override
    public void doAdmissionChecks(Function.FunctionDetails functionDetails) {
        String overriddenJobName = this.getOverriddenName(functionDetails);
        KubernetesRuntime.doChecks(functionDetails, overriddenJobName);
        this.validateMinResourcesRequired(functionDetails);
        this.validateMaxResourcesRequired(functionDetails);
        this.validateResourcesGranularityAndProportion(functionDetails);
        this.secretsProviderConfigurator.doAdmissionChecks(this.appsClient, this.coreClient, this.getOverriddenNamespace(functionDetails), overriddenJobName, functionDetails);
    }

    @VisibleForTesting
    public void setupClient() throws Exception {
        if (this.appsClient == null) {
            if (this.k8Uri == null) {
                ApiClient cli;
                log.info("k8Uri is null thus going by defaults");
                if (this.submittingInsidePod != null && this.submittingInsidePod.booleanValue()) {
                    log.info("Looks like we are inside a k8 pod ourselves. Initializing as cluster");
                    cli = Config.fromCluster();
                } else {
                    log.info("Using default cluster since we are not running inside k8");
                    cli = Config.defaultClient();
                }
                Configuration.setDefaultApiClient((ApiClient)cli);
                this.appsClient = new AppsV1Api();
                this.coreClient = new CoreV1Api();
            } else {
                log.info("Setting up k8Client using uri " + this.k8Uri);
                ApiClient apiClient = new ApiClient().setBasePath(this.k8Uri);
                this.appsClient = new AppsV1Api(apiClient);
                this.coreClient = new CoreV1Api(apiClient);
            }
            if (!StringUtils.isEmpty(this.changeConfigMap)) {
                this.changeConfigMapTimer = new Timer();
                final KubernetesRuntimeFactory kubernetesRuntimeFactory = this;
                this.changeConfigMapTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        KubernetesRuntimeFactory.fetchConfigMap(KubernetesRuntimeFactory.this.coreClient, KubernetesRuntimeFactory.this.changeConfigMap, KubernetesRuntimeFactory.this.changeConfigMapNamespace, kubernetesRuntimeFactory);
                    }
                }, 300000L, 300000L);
            }
        }
    }

    static void fetchConfigMap(CoreV1Api coreClient, String changeConfigMap, String changeConfigMapNamespace, KubernetesRuntimeFactory kubernetesRuntimeFactory) {
        try {
            V1ConfigMap v1ConfigMap = coreClient.readNamespacedConfigMap(changeConfigMap, changeConfigMapNamespace, null);
            Map data = v1ConfigMap.getData();
            if (data != null) {
                KubernetesRuntimeFactory.overRideKubernetesConfig(data, kubernetesRuntimeFactory);
            }
        }
        catch (Exception e) {
            log.error("Error while trying to fetch configmap {} at namespace {}", new Object[]{changeConfigMap, changeConfigMapNamespace, e});
        }
    }

    static void overRideKubernetesConfig(Map<String, String> data, KubernetesRuntimeFactory kubernetesRuntimeFactory) throws Exception {
        for (Field field : KubernetesRuntimeFactory.class.getDeclaredFields()) {
            field.setAccessible(true);
            if (!data.containsKey(field.getName()) || data.get(field.getName()).equals(field.get(kubernetesRuntimeFactory))) continue;
            log.info("Kubernetes Config {} changed from {} to {}", new Object[]{field.getName(), field.get(kubernetesRuntimeFactory), data.get(field.getName())});
            field.set(kubernetesRuntimeFactory, data.get(field.getName()));
        }
    }

    void validateMinResourcesRequired(Function.FunctionDetails functionDetails) {
        if (this.functionInstanceMinResources != null) {
            Double minCpu = this.functionInstanceMinResources.getCpu();
            Long minRam = this.functionInstanceMinResources.getRam();
            if (minCpu != null) {
                if (functionDetails.getResources() == null) {
                    throw new IllegalArgumentException(String.format("Per instance CPU requested is not specified. Must specify CPU requested for function to be at least %s", minCpu));
                }
                if (functionDetails.getResources().getCpu() < minCpu) {
                    throw new IllegalArgumentException(String.format("Per instance CPU requested, %s, for function is less than the minimum required, %s", functionDetails.getResources().getCpu(), minCpu));
                }
            }
            if (minRam != null) {
                if (functionDetails.getResources() == null) {
                    throw new IllegalArgumentException(String.format("Per instance RAM requested is not specified. Must specify RAM requested for function to be at least %s", minRam));
                }
                if (functionDetails.getResources().getRam() < minRam) {
                    throw new IllegalArgumentException(String.format("Per instance RAM requested, %s, for function is less than the minimum required, %s", functionDetails.getResources().getRam(), minRam));
                }
            }
        }
    }

    void validateMaxResourcesRequired(Function.FunctionDetails functionDetails) {
        if (this.functionInstanceMaxResources != null) {
            Double maxCpu = this.functionInstanceMaxResources.getCpu();
            Long maxRam = this.functionInstanceMaxResources.getRam();
            if (maxCpu != null && functionDetails.getResources().getCpu() > maxCpu) {
                throw new IllegalArgumentException(String.format("Per instance CPU requested, %s, for function is greater than the maximum required, %s", functionDetails.getResources().getCpu(), maxCpu));
            }
            if (maxRam != null && functionDetails.getResources().getRam() > maxRam) {
                throw new IllegalArgumentException(String.format("Per instance RAM requested, %s, for function is greater than the maximum required, %s", functionDetails.getResources().getRam(), maxRam));
            }
        }
    }

    void validateResourcesGranularityAndProportion(Function.FunctionDetails functionDetails) {
        long baseMillis = 1000L;
        long multiples = 0L;
        if (this.functionInstanceResourceGranularities != null) {
            long grnCpuMillis;
            Double grnCpu = this.functionInstanceResourceGranularities.getCpu();
            Long grnRam = this.functionInstanceResourceGranularities.getRam();
            if (grnCpu != null && (grnCpuMillis = Math.round(1000.0 * grnCpu)) > 0L) {
                long cpuMillis = Math.round(1000.0 * functionDetails.getResources().getCpu());
                if (cpuMillis == 0L || cpuMillis % grnCpuMillis != 0L) {
                    throw new IllegalArgumentException(String.format("Per instance cpu requested, %s, for function should be positive and a multiple of the granularity, %s", functionDetails.getResources().getCpu(), grnCpu));
                }
                if (this.functionInstanceResourceChangeInLockStep) {
                    multiples = cpuMillis / grnCpuMillis;
                }
            }
            if (grnRam != null && grnRam > 0L) {
                long ramMultiples;
                if (functionDetails.getResources().getRam() == 0L || functionDetails.getResources().getRam() % grnRam != 0L) {
                    throw new IllegalArgumentException(String.format("Per instance ram requested, %s, for function should be positive and a multiple of the granularity, %s", functionDetails.getResources().getRam(), grnRam));
                }
                if (this.functionInstanceResourceChangeInLockStep && multiples > 0L && multiples != (ramMultiples = functionDetails.getResources().getRam() / grnRam)) {
                    throw new IllegalArgumentException(String.format("Per instance cpu requested, %s, ram requested, %s, for function should be positive and the same multiple of the granularity, cpu, %s, ram, %s", functionDetails.getResources().getCpu(), functionDetails.getResources().getRam(), grnCpu, grnRam));
                }
            }
        }
    }

    public Optional<KubernetesFunctionAuthProvider> getAuthProvider() {
        return this.authProvider;
    }

    public Optional<KubernetesManifestCustomizer> getRuntimeCustomizer() {
        return this.manifestCustomizer;
    }

    private String getOverriddenNamespace(Function.FunctionDetails funcDetails) {
        Optional<KubernetesManifestCustomizer> manifestCustomizer = this.getRuntimeCustomizer();
        return manifestCustomizer.map(customizer -> customizer.customizeNamespace(funcDetails, this.jobNamespace)).orElse(this.jobNamespace);
    }

    private String getOverriddenName(Function.FunctionDetails funcDetails) {
        Optional<KubernetesManifestCustomizer> manifestCustomizer = this.getRuntimeCustomizer();
        return manifestCustomizer.map(customizer -> customizer.customizeName(funcDetails, this.jobName)).orElse(this.jobName);
    }

    public String getK8Uri() {
        return this.k8Uri;
    }

    public String getJobNamespace() {
        return this.jobNamespace;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getPulsarDockerImageName() {
        return this.pulsarDockerImageName;
    }

    public Map<String, String> getFunctionDockerImages() {
        return this.functionDockerImages;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getPulsarRootDir() {
        return this.pulsarRootDir;
    }

    public String getConfigAdminCLI() {
        return this.configAdminCLI;
    }

    public String getPulsarAdminUrl() {
        return this.pulsarAdminUrl;
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getPythonDependencyRepository() {
        return this.pythonDependencyRepository;
    }

    public String getPythonExtraDependencyRepository() {
        return this.pythonExtraDependencyRepository;
    }

    public String getExtraDependenciesDir() {
        return this.extraDependenciesDir;
    }

    public String getChangeConfigMap() {
        return this.changeConfigMap;
    }

    public String getChangeConfigMapNamespace() {
        return this.changeConfigMapNamespace;
    }

    public int getPercentMemoryPadding() {
        return this.percentMemoryPadding;
    }

    public double getCpuOverCommitRatio() {
        return this.cpuOverCommitRatio;
    }

    public double getMemoryOverCommitRatio() {
        return this.memoryOverCommitRatio;
    }

    public Boolean getSubmittingInsidePod() {
        return this.submittingInsidePod;
    }

    public Boolean getInstallUserCodeDependencies() {
        return this.installUserCodeDependencies;
    }

    public Map<String, String> getCustomLabels() {
        return this.customLabels;
    }

    public Integer getExpectedMetricsCollectionInterval() {
        return this.expectedMetricsCollectionInterval;
    }

    public String getStateStorageServiceUri() {
        return this.stateStorageServiceUri;
    }

    public AuthenticationConfig getAuthConfig() {
        return this.authConfig;
    }

    public String getJavaInstanceJarFile() {
        return this.javaInstanceJarFile;
    }

    public String getPythonInstanceFile() {
        return this.pythonInstanceFile;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public Resources getFunctionInstanceMinResources() {
        return this.functionInstanceMinResources;
    }

    public Resources getFunctionInstanceMaxResources() {
        return this.functionInstanceMaxResources;
    }

    public Resources getFunctionInstanceResourceGranularities() {
        return this.functionInstanceResourceGranularities;
    }

    public boolean isFunctionInstanceResourceChangeInLockStep() {
        return this.functionInstanceResourceChangeInLockStep;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Integer getGrpcPort() {
        return this.grpcPort;
    }

    public Integer getMetricsPort() {
        return this.metricsPort;
    }

    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    public String getFunctionInstanceClassPath() {
        return this.functionInstanceClassPath;
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public int getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public Timer getChangeConfigMapTimer() {
        return this.changeConfigMapTimer;
    }

    public AppsV1Api getAppsClient() {
        return this.appsClient;
    }

    public CoreV1Api getCoreClient() {
        return this.coreClient;
    }

    public SecretsProviderConfigurator getSecretsProviderConfigurator() {
        return this.secretsProviderConfigurator;
    }

    public Optional<KubernetesManifestCustomizer> getManifestCustomizer() {
        return this.manifestCustomizer;
    }

    public byte[] getServerCaBytes() {
        return this.serverCaBytes;
    }

    public void setK8Uri(String k8Uri) {
        this.k8Uri = k8Uri;
    }

    public void setJobNamespace(String jobNamespace) {
        this.jobNamespace = jobNamespace;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setPulsarDockerImageName(String pulsarDockerImageName) {
        this.pulsarDockerImageName = pulsarDockerImageName;
    }

    public void setFunctionDockerImages(Map<String, String> functionDockerImages) {
        this.functionDockerImages = functionDockerImages;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public void setPulsarRootDir(String pulsarRootDir) {
        this.pulsarRootDir = pulsarRootDir;
    }

    public void setConfigAdminCLI(String configAdminCLI) {
        this.configAdminCLI = configAdminCLI;
    }

    public void setPulsarAdminUrl(String pulsarAdminUrl) {
        this.pulsarAdminUrl = pulsarAdminUrl;
    }

    public void setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
    }

    public void setPythonDependencyRepository(String pythonDependencyRepository) {
        this.pythonDependencyRepository = pythonDependencyRepository;
    }

    public void setPythonExtraDependencyRepository(String pythonExtraDependencyRepository) {
        this.pythonExtraDependencyRepository = pythonExtraDependencyRepository;
    }

    public void setExtraDependenciesDir(String extraDependenciesDir) {
        this.extraDependenciesDir = extraDependenciesDir;
    }

    public void setChangeConfigMap(String changeConfigMap) {
        this.changeConfigMap = changeConfigMap;
    }

    public void setChangeConfigMapNamespace(String changeConfigMapNamespace) {
        this.changeConfigMapNamespace = changeConfigMapNamespace;
    }

    public void setPercentMemoryPadding(int percentMemoryPadding) {
        this.percentMemoryPadding = percentMemoryPadding;
    }

    public void setCpuOverCommitRatio(double cpuOverCommitRatio) {
        this.cpuOverCommitRatio = cpuOverCommitRatio;
    }

    public void setMemoryOverCommitRatio(double memoryOverCommitRatio) {
        this.memoryOverCommitRatio = memoryOverCommitRatio;
    }

    public void setSubmittingInsidePod(Boolean submittingInsidePod) {
        this.submittingInsidePod = submittingInsidePod;
    }

    public void setInstallUserCodeDependencies(Boolean installUserCodeDependencies) {
        this.installUserCodeDependencies = installUserCodeDependencies;
    }

    public void setCustomLabels(Map<String, String> customLabels) {
        this.customLabels = customLabels;
    }

    public void setExpectedMetricsCollectionInterval(Integer expectedMetricsCollectionInterval) {
        this.expectedMetricsCollectionInterval = expectedMetricsCollectionInterval;
    }

    public void setStateStorageServiceUri(String stateStorageServiceUri) {
        this.stateStorageServiceUri = stateStorageServiceUri;
    }

    public void setAuthConfig(AuthenticationConfig authConfig) {
        this.authConfig = authConfig;
    }

    public void setJavaInstanceJarFile(String javaInstanceJarFile) {
        this.javaInstanceJarFile = javaInstanceJarFile;
    }

    public void setPythonInstanceFile(String pythonInstanceFile) {
        this.pythonInstanceFile = pythonInstanceFile;
    }

    public void setFunctionInstanceMinResources(Resources functionInstanceMinResources) {
        this.functionInstanceMinResources = functionInstanceMinResources;
    }

    public void setFunctionInstanceMaxResources(Resources functionInstanceMaxResources) {
        this.functionInstanceMaxResources = functionInstanceMaxResources;
    }

    public void setFunctionInstanceResourceGranularities(Resources functionInstanceResourceGranularities) {
        this.functionInstanceResourceGranularities = functionInstanceResourceGranularities;
    }

    public void setFunctionInstanceResourceChangeInLockStep(boolean functionInstanceResourceChangeInLockStep) {
        this.functionInstanceResourceChangeInLockStep = functionInstanceResourceChangeInLockStep;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setGrpcPort(Integer grpcPort) {
        this.grpcPort = grpcPort;
    }

    public void setMetricsPort(Integer metricsPort) {
        this.metricsPort = metricsPort;
    }

    public void setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
    }

    public void setFunctionInstanceClassPath(String functionInstanceClassPath) {
        this.functionInstanceClassPath = functionInstanceClassPath;
    }

    public void setDownloadDirectory(String downloadDirectory) {
        this.downloadDirectory = downloadDirectory;
    }

    public void setGracePeriodSeconds(int gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
    }

    public void setChangeConfigMapTimer(Timer changeConfigMapTimer) {
        this.changeConfigMapTimer = changeConfigMapTimer;
    }

    public void setAppsClient(AppsV1Api appsClient) {
        this.appsClient = appsClient;
    }

    public void setCoreClient(CoreV1Api coreClient) {
        this.coreClient = coreClient;
    }

    public void setSecretsProviderConfigurator(SecretsProviderConfigurator secretsProviderConfigurator) {
        this.secretsProviderConfigurator = secretsProviderConfigurator;
    }

    public void setAuthProvider(Optional<KubernetesFunctionAuthProvider> authProvider) {
        this.authProvider = authProvider;
    }

    public void setManifestCustomizer(Optional<KubernetesManifestCustomizer> manifestCustomizer) {
        this.manifestCustomizer = manifestCustomizer;
    }

    public void setServerCaBytes(byte[] serverCaBytes) {
        this.serverCaBytes = serverCaBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesRuntimeFactory)) {
            return false;
        }
        KubernetesRuntimeFactory other = (KubernetesRuntimeFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPercentMemoryPadding() != other.getPercentMemoryPadding()) {
            return false;
        }
        if (Double.compare(this.getCpuOverCommitRatio(), other.getCpuOverCommitRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryOverCommitRatio(), other.getMemoryOverCommitRatio()) != 0) {
            return false;
        }
        if (this.isFunctionInstanceResourceChangeInLockStep() != other.isFunctionInstanceResourceChangeInLockStep()) {
            return false;
        }
        if (this.isAuthenticationEnabled() != other.isAuthenticationEnabled()) {
            return false;
        }
        if (this.getGracePeriodSeconds() != other.getGracePeriodSeconds()) {
            return false;
        }
        Boolean this$submittingInsidePod = this.getSubmittingInsidePod();
        Boolean other$submittingInsidePod = other.getSubmittingInsidePod();
        if (this$submittingInsidePod == null ? other$submittingInsidePod != null : !((Object)this$submittingInsidePod).equals(other$submittingInsidePod)) {
            return false;
        }
        Boolean this$installUserCodeDependencies = this.getInstallUserCodeDependencies();
        Boolean other$installUserCodeDependencies = other.getInstallUserCodeDependencies();
        if (this$installUserCodeDependencies == null ? other$installUserCodeDependencies != null : !((Object)this$installUserCodeDependencies).equals(other$installUserCodeDependencies)) {
            return false;
        }
        Integer this$expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        Integer other$expectedMetricsCollectionInterval = other.getExpectedMetricsCollectionInterval();
        if (this$expectedMetricsCollectionInterval == null ? other$expectedMetricsCollectionInterval != null : !((Object)this$expectedMetricsCollectionInterval).equals(other$expectedMetricsCollectionInterval)) {
            return false;
        }
        Integer this$grpcPort = this.getGrpcPort();
        Integer other$grpcPort = other.getGrpcPort();
        if (this$grpcPort == null ? other$grpcPort != null : !((Object)this$grpcPort).equals(other$grpcPort)) {
            return false;
        }
        Integer this$metricsPort = this.getMetricsPort();
        Integer other$metricsPort = other.getMetricsPort();
        if (this$metricsPort == null ? other$metricsPort != null : !((Object)this$metricsPort).equals(other$metricsPort)) {
            return false;
        }
        String this$k8Uri = this.getK8Uri();
        String other$k8Uri = other.getK8Uri();
        if (this$k8Uri == null ? other$k8Uri != null : !this$k8Uri.equals(other$k8Uri)) {
            return false;
        }
        String this$jobNamespace = this.getJobNamespace();
        String other$jobNamespace = other.getJobNamespace();
        if (this$jobNamespace == null ? other$jobNamespace != null : !this$jobNamespace.equals(other$jobNamespace)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$pulsarDockerImageName = this.getPulsarDockerImageName();
        String other$pulsarDockerImageName = other.getPulsarDockerImageName();
        if (this$pulsarDockerImageName == null ? other$pulsarDockerImageName != null : !this$pulsarDockerImageName.equals(other$pulsarDockerImageName)) {
            return false;
        }
        Map<String, String> this$functionDockerImages = this.getFunctionDockerImages();
        Map<String, String> other$functionDockerImages = other.getFunctionDockerImages();
        if (this$functionDockerImages == null ? other$functionDockerImages != null : !((Object)this$functionDockerImages).equals(other$functionDockerImages)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$pulsarRootDir = this.getPulsarRootDir();
        String other$pulsarRootDir = other.getPulsarRootDir();
        if (this$pulsarRootDir == null ? other$pulsarRootDir != null : !this$pulsarRootDir.equals(other$pulsarRootDir)) {
            return false;
        }
        String this$configAdminCLI = this.getConfigAdminCLI();
        String other$configAdminCLI = other.getConfigAdminCLI();
        if (this$configAdminCLI == null ? other$configAdminCLI != null : !this$configAdminCLI.equals(other$configAdminCLI)) {
            return false;
        }
        String this$pulsarAdminUrl = this.getPulsarAdminUrl();
        String other$pulsarAdminUrl = other.getPulsarAdminUrl();
        if (this$pulsarAdminUrl == null ? other$pulsarAdminUrl != null : !this$pulsarAdminUrl.equals(other$pulsarAdminUrl)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pythonDependencyRepository = this.getPythonDependencyRepository();
        String other$pythonDependencyRepository = other.getPythonDependencyRepository();
        if (this$pythonDependencyRepository == null ? other$pythonDependencyRepository != null : !this$pythonDependencyRepository.equals(other$pythonDependencyRepository)) {
            return false;
        }
        String this$pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        String other$pythonExtraDependencyRepository = other.getPythonExtraDependencyRepository();
        if (this$pythonExtraDependencyRepository == null ? other$pythonExtraDependencyRepository != null : !this$pythonExtraDependencyRepository.equals(other$pythonExtraDependencyRepository)) {
            return false;
        }
        String this$extraDependenciesDir = this.getExtraDependenciesDir();
        String other$extraDependenciesDir = other.getExtraDependenciesDir();
        if (this$extraDependenciesDir == null ? other$extraDependenciesDir != null : !this$extraDependenciesDir.equals(other$extraDependenciesDir)) {
            return false;
        }
        String this$changeConfigMap = this.getChangeConfigMap();
        String other$changeConfigMap = other.getChangeConfigMap();
        if (this$changeConfigMap == null ? other$changeConfigMap != null : !this$changeConfigMap.equals(other$changeConfigMap)) {
            return false;
        }
        String this$changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        String other$changeConfigMapNamespace = other.getChangeConfigMapNamespace();
        if (this$changeConfigMapNamespace == null ? other$changeConfigMapNamespace != null : !this$changeConfigMapNamespace.equals(other$changeConfigMapNamespace)) {
            return false;
        }
        Map<String, String> this$customLabels = this.getCustomLabels();
        Map<String, String> other$customLabels = other.getCustomLabels();
        if (this$customLabels == null ? other$customLabels != null : !((Object)this$customLabels).equals(other$customLabels)) {
            return false;
        }
        String this$stateStorageServiceUri = this.getStateStorageServiceUri();
        String other$stateStorageServiceUri = other.getStateStorageServiceUri();
        if (this$stateStorageServiceUri == null ? other$stateStorageServiceUri != null : !this$stateStorageServiceUri.equals(other$stateStorageServiceUri)) {
            return false;
        }
        AuthenticationConfig this$authConfig = this.getAuthConfig();
        AuthenticationConfig other$authConfig = other.getAuthConfig();
        if (this$authConfig == null ? other$authConfig != null : !((Object)this$authConfig).equals(other$authConfig)) {
            return false;
        }
        String this$javaInstanceJarFile = this.getJavaInstanceJarFile();
        String other$javaInstanceJarFile = other.getJavaInstanceJarFile();
        if (this$javaInstanceJarFile == null ? other$javaInstanceJarFile != null : !this$javaInstanceJarFile.equals(other$javaInstanceJarFile)) {
            return false;
        }
        String this$pythonInstanceFile = this.getPythonInstanceFile();
        String other$pythonInstanceFile = other.getPythonInstanceFile();
        if (this$pythonInstanceFile == null ? other$pythonInstanceFile != null : !this$pythonInstanceFile.equals(other$pythonInstanceFile)) {
            return false;
        }
        String this$logDirectory = this.getLogDirectory();
        String other$logDirectory = other.getLogDirectory();
        if (this$logDirectory == null ? other$logDirectory != null : !this$logDirectory.equals(other$logDirectory)) {
            return false;
        }
        Resources this$functionInstanceMinResources = this.getFunctionInstanceMinResources();
        Resources other$functionInstanceMinResources = other.getFunctionInstanceMinResources();
        if (this$functionInstanceMinResources == null ? other$functionInstanceMinResources != null : !((Object)this$functionInstanceMinResources).equals(other$functionInstanceMinResources)) {
            return false;
        }
        Resources this$functionInstanceMaxResources = this.getFunctionInstanceMaxResources();
        Resources other$functionInstanceMaxResources = other.getFunctionInstanceMaxResources();
        if (this$functionInstanceMaxResources == null ? other$functionInstanceMaxResources != null : !((Object)this$functionInstanceMaxResources).equals(other$functionInstanceMaxResources)) {
            return false;
        }
        Resources this$functionInstanceResourceGranularities = this.getFunctionInstanceResourceGranularities();
        Resources other$functionInstanceResourceGranularities = other.getFunctionInstanceResourceGranularities();
        if (this$functionInstanceResourceGranularities == null ? other$functionInstanceResourceGranularities != null : !((Object)this$functionInstanceResourceGranularities).equals(other$functionInstanceResourceGranularities)) {
            return false;
        }
        String this$narExtractionDirectory = this.getNarExtractionDirectory();
        String other$narExtractionDirectory = other.getNarExtractionDirectory();
        if (this$narExtractionDirectory == null ? other$narExtractionDirectory != null : !this$narExtractionDirectory.equals(other$narExtractionDirectory)) {
            return false;
        }
        String this$functionInstanceClassPath = this.getFunctionInstanceClassPath();
        String other$functionInstanceClassPath = other.getFunctionInstanceClassPath();
        if (this$functionInstanceClassPath == null ? other$functionInstanceClassPath != null : !this$functionInstanceClassPath.equals(other$functionInstanceClassPath)) {
            return false;
        }
        String this$downloadDirectory = this.getDownloadDirectory();
        String other$downloadDirectory = other.getDownloadDirectory();
        return !(this$downloadDirectory == null ? other$downloadDirectory != null : !this$downloadDirectory.equals(other$downloadDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesRuntimeFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPercentMemoryPadding();
        long $cpuOverCommitRatio = Double.doubleToLongBits(this.getCpuOverCommitRatio());
        result = result * 59 + (int)($cpuOverCommitRatio >>> 32 ^ $cpuOverCommitRatio);
        long $memoryOverCommitRatio = Double.doubleToLongBits(this.getMemoryOverCommitRatio());
        result = result * 59 + (int)($memoryOverCommitRatio >>> 32 ^ $memoryOverCommitRatio);
        result = result * 59 + (this.isFunctionInstanceResourceChangeInLockStep() ? 79 : 97);
        result = result * 59 + (this.isAuthenticationEnabled() ? 79 : 97);
        result = result * 59 + this.getGracePeriodSeconds();
        Boolean $submittingInsidePod = this.getSubmittingInsidePod();
        result = result * 59 + ($submittingInsidePod == null ? 43 : ((Object)$submittingInsidePod).hashCode());
        Boolean $installUserCodeDependencies = this.getInstallUserCodeDependencies();
        result = result * 59 + ($installUserCodeDependencies == null ? 43 : ((Object)$installUserCodeDependencies).hashCode());
        Integer $expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        result = result * 59 + ($expectedMetricsCollectionInterval == null ? 43 : ((Object)$expectedMetricsCollectionInterval).hashCode());
        Integer $grpcPort = this.getGrpcPort();
        result = result * 59 + ($grpcPort == null ? 43 : ((Object)$grpcPort).hashCode());
        Integer $metricsPort = this.getMetricsPort();
        result = result * 59 + ($metricsPort == null ? 43 : ((Object)$metricsPort).hashCode());
        String $k8Uri = this.getK8Uri();
        result = result * 59 + ($k8Uri == null ? 43 : $k8Uri.hashCode());
        String $jobNamespace = this.getJobNamespace();
        result = result * 59 + ($jobNamespace == null ? 43 : $jobNamespace.hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $pulsarDockerImageName = this.getPulsarDockerImageName();
        result = result * 59 + ($pulsarDockerImageName == null ? 43 : $pulsarDockerImageName.hashCode());
        Map<String, String> $functionDockerImages = this.getFunctionDockerImages();
        result = result * 59 + ($functionDockerImages == null ? 43 : ((Object)$functionDockerImages).hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $pulsarRootDir = this.getPulsarRootDir();
        result = result * 59 + ($pulsarRootDir == null ? 43 : $pulsarRootDir.hashCode());
        String $configAdminCLI = this.getConfigAdminCLI();
        result = result * 59 + ($configAdminCLI == null ? 43 : $configAdminCLI.hashCode());
        String $pulsarAdminUrl = this.getPulsarAdminUrl();
        result = result * 59 + ($pulsarAdminUrl == null ? 43 : $pulsarAdminUrl.hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pythonDependencyRepository = this.getPythonDependencyRepository();
        result = result * 59 + ($pythonDependencyRepository == null ? 43 : $pythonDependencyRepository.hashCode());
        String $pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        result = result * 59 + ($pythonExtraDependencyRepository == null ? 43 : $pythonExtraDependencyRepository.hashCode());
        String $extraDependenciesDir = this.getExtraDependenciesDir();
        result = result * 59 + ($extraDependenciesDir == null ? 43 : $extraDependenciesDir.hashCode());
        String $changeConfigMap = this.getChangeConfigMap();
        result = result * 59 + ($changeConfigMap == null ? 43 : $changeConfigMap.hashCode());
        String $changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        result = result * 59 + ($changeConfigMapNamespace == null ? 43 : $changeConfigMapNamespace.hashCode());
        Map<String, String> $customLabels = this.getCustomLabels();
        result = result * 59 + ($customLabels == null ? 43 : ((Object)$customLabels).hashCode());
        String $stateStorageServiceUri = this.getStateStorageServiceUri();
        result = result * 59 + ($stateStorageServiceUri == null ? 43 : $stateStorageServiceUri.hashCode());
        AuthenticationConfig $authConfig = this.getAuthConfig();
        result = result * 59 + ($authConfig == null ? 43 : ((Object)$authConfig).hashCode());
        String $javaInstanceJarFile = this.getJavaInstanceJarFile();
        result = result * 59 + ($javaInstanceJarFile == null ? 43 : $javaInstanceJarFile.hashCode());
        String $pythonInstanceFile = this.getPythonInstanceFile();
        result = result * 59 + ($pythonInstanceFile == null ? 43 : $pythonInstanceFile.hashCode());
        String $logDirectory = this.getLogDirectory();
        result = result * 59 + ($logDirectory == null ? 43 : $logDirectory.hashCode());
        Resources $functionInstanceMinResources = this.getFunctionInstanceMinResources();
        result = result * 59 + ($functionInstanceMinResources == null ? 43 : ((Object)$functionInstanceMinResources).hashCode());
        Resources $functionInstanceMaxResources = this.getFunctionInstanceMaxResources();
        result = result * 59 + ($functionInstanceMaxResources == null ? 43 : ((Object)$functionInstanceMaxResources).hashCode());
        Resources $functionInstanceResourceGranularities = this.getFunctionInstanceResourceGranularities();
        result = result * 59 + ($functionInstanceResourceGranularities == null ? 43 : ((Object)$functionInstanceResourceGranularities).hashCode());
        String $narExtractionDirectory = this.getNarExtractionDirectory();
        result = result * 59 + ($narExtractionDirectory == null ? 43 : $narExtractionDirectory.hashCode());
        String $functionInstanceClassPath = this.getFunctionInstanceClassPath();
        result = result * 59 + ($functionInstanceClassPath == null ? 43 : $functionInstanceClassPath.hashCode());
        String $downloadDirectory = this.getDownloadDirectory();
        result = result * 59 + ($downloadDirectory == null ? 43 : $downloadDirectory.hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesRuntimeFactory(k8Uri=" + this.getK8Uri() + ", jobNamespace=" + this.getJobNamespace() + ", jobName=" + this.getJobName() + ", pulsarDockerImageName=" + this.getPulsarDockerImageName() + ", functionDockerImages=" + this.getFunctionDockerImages() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", pulsarRootDir=" + this.getPulsarRootDir() + ", configAdminCLI=" + this.getConfigAdminCLI() + ", pulsarAdminUrl=" + this.getPulsarAdminUrl() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pythonDependencyRepository=" + this.getPythonDependencyRepository() + ", pythonExtraDependencyRepository=" + this.getPythonExtraDependencyRepository() + ", extraDependenciesDir=" + this.getExtraDependenciesDir() + ", changeConfigMap=" + this.getChangeConfigMap() + ", changeConfigMapNamespace=" + this.getChangeConfigMapNamespace() + ", percentMemoryPadding=" + this.getPercentMemoryPadding() + ", cpuOverCommitRatio=" + this.getCpuOverCommitRatio() + ", memoryOverCommitRatio=" + this.getMemoryOverCommitRatio() + ", submittingInsidePod=" + this.getSubmittingInsidePod() + ", installUserCodeDependencies=" + this.getInstallUserCodeDependencies() + ", customLabels=" + this.getCustomLabels() + ", expectedMetricsCollectionInterval=" + this.getExpectedMetricsCollectionInterval() + ", stateStorageServiceUri=" + this.getStateStorageServiceUri() + ", authConfig=" + this.getAuthConfig() + ", javaInstanceJarFile=" + this.getJavaInstanceJarFile() + ", pythonInstanceFile=" + this.getPythonInstanceFile() + ", logDirectory=" + this.getLogDirectory() + ", functionInstanceMinResources=" + this.getFunctionInstanceMinResources() + ", functionInstanceMaxResources=" + this.getFunctionInstanceMaxResources() + ", functionInstanceResourceGranularities=" + this.getFunctionInstanceResourceGranularities() + ", functionInstanceResourceChangeInLockStep=" + this.isFunctionInstanceResourceChangeInLockStep() + ", authenticationEnabled=" + this.isAuthenticationEnabled() + ", grpcPort=" + this.getGrpcPort() + ", metricsPort=" + this.getMetricsPort() + ", narExtractionDirectory=" + this.getNarExtractionDirectory() + ", functionInstanceClassPath=" + this.getFunctionInstanceClassPath() + ", downloadDirectory=" + this.getDownloadDirectory() + ", gracePeriodSeconds=" + this.getGracePeriodSeconds() + ")";
    }
}

