/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.checksum;

import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.IncrementalIntHash;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.checksum.Crc32cSse42Provider;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.checksum.IntHash;
import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.params.CrcParameters;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;

public class JniIntHash
implements IntHash {
    private final IncrementalIntHash hash = new Crc32cSse42Provider().getIncrementalInt(CrcParameters.CRC32C);

    @Override
    public int calculate(ByteBuf buffer) {
        return this.resume(0, buffer);
    }

    @Override
    public int resume(int current, ByteBuf buffer) {
        if (buffer.hasMemoryAddress()) {
            return this.hash.resume(current, buffer.memoryAddress() + (long)buffer.readerIndex(), buffer.readableBytes());
        }
        if (buffer.hasArray()) {
            return this.hash.resume(current, buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), buffer.readableBytes());
        }
        return this.hash.resume(current, buffer.nioBuffer());
    }
}

