/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BufferedReadChannel;

public class BufferedChannel
extends BufferedReadChannel
implements Closeable {
    protected final int writeCapacity;
    protected AtomicLong writeBufferStartPosition = new AtomicLong(0L);
    protected final ByteBuf writeBuffer;
    protected volatile long position;
    protected final long unpersistedBytesBound;
    private final boolean doRegularFlushes;
    protected final AtomicLong unpersistedBytes;
    private boolean closed = false;

    public BufferedChannel(ByteBufAllocator allocator, FileChannel fc, int capacity) throws IOException {
        this(allocator, fc, capacity, 0L);
    }

    public BufferedChannel(ByteBufAllocator allocator, FileChannel fc, int capacity, long unpersistedBytesBound) throws IOException {
        this(allocator, fc, capacity, capacity, unpersistedBytesBound);
    }

    public BufferedChannel(ByteBufAllocator allocator, FileChannel fc, int writeCapacity, int readCapacity, long unpersistedBytesBound) throws IOException {
        super(fc, readCapacity);
        this.writeCapacity = writeCapacity;
        this.position = fc.position();
        this.writeBufferStartPosition.set(this.position);
        this.writeBuffer = allocator.directBuffer(writeCapacity);
        this.unpersistedBytes = new AtomicLong(0L);
        this.unpersistedBytesBound = unpersistedBytesBound;
        this.doRegularFlushes = unpersistedBytesBound > 0L;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        ReferenceCountUtil.release(this.writeBuffer);
        this.fileChannel.close();
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf src) throws IOException {
        boolean shouldForceWrite = false;
        BufferedChannel bufferedChannel = this;
        synchronized (bufferedChannel) {
            int copied;
            int bytesToCopy;
            int len = src.readableBytes();
            for (copied = 0; copied < len; copied += bytesToCopy) {
                bytesToCopy = Math.min(src.readableBytes() - copied, this.writeBuffer.writableBytes());
                this.writeBuffer.writeBytes(src, src.readerIndex() + copied, bytesToCopy);
                if (this.writeBuffer.isWritable()) continue;
                this.flush();
            }
            this.position += (long)copied;
            if (this.doRegularFlushes) {
                this.unpersistedBytes.addAndGet(copied);
                if (this.unpersistedBytes.get() >= this.unpersistedBytesBound) {
                    this.flush();
                    shouldForceWrite = true;
                }
            }
        }
        if (shouldForceWrite) {
            this.forceWrite(false);
        }
    }

    public long position() {
        return this.position;
    }

    public long getFileChannelPosition() {
        return this.writeBufferStartPosition.get();
    }

    public void flushAndForceWrite(boolean forceMetadata) throws IOException {
        this.flush();
        this.forceWrite(forceMetadata);
    }

    public void flushAndForceWriteIfRegularFlush(boolean forceMetadata) throws IOException {
        if (this.doRegularFlushes) {
            this.flushAndForceWrite(forceMetadata);
        }
    }

    public synchronized void flush() throws IOException {
        ByteBuffer toWrite = this.writeBuffer.internalNioBuffer(0, this.writeBuffer.writerIndex());
        do {
            this.fileChannel.write(toWrite);
        } while (toWrite.hasRemaining());
        this.writeBuffer.clear();
        this.writeBufferStartPosition.set(this.fileChannel.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long forceWrite(boolean forceMetadata) throws IOException {
        long positionForceWrite = this.writeBufferStartPosition.get();
        if (this.unpersistedBytesBound > 0L) {
            BufferedChannel bufferedChannel = this;
            synchronized (bufferedChannel) {
                this.unpersistedBytes.set(this.writeBuffer.readableBytes());
            }
        }
        this.fileChannel.force(forceMetadata);
        return positionForceWrite;
    }

    @Override
    public synchronized int read(ByteBuf dest, long pos, int length) throws IOException {
        long prevPos = pos;
        while (length > 0) {
            int bytesToCopy;
            int positionInBuffer;
            if (this.writeBuffer != null && this.writeBufferStartPosition.get() <= pos) {
                positionInBuffer = (int)(pos - this.writeBufferStartPosition.get());
                bytesToCopy = Math.min(this.writeBuffer.writerIndex() - positionInBuffer, dest.writableBytes());
                if (bytesToCopy == 0) {
                    throw new IOException("Read past EOF");
                }
                dest.writeBytes(this.writeBuffer, positionInBuffer, bytesToCopy);
                pos += (long)bytesToCopy;
                length -= bytesToCopy;
                continue;
            }
            if (this.writeBuffer == null && this.writeBufferStartPosition.get() <= pos) break;
            if (this.readBufferStartPosition <= pos && pos < this.readBufferStartPosition + (long)this.readBuffer.writerIndex()) {
                positionInBuffer = (int)(pos - this.readBufferStartPosition);
                bytesToCopy = Math.min(this.readBuffer.writerIndex() - positionInBuffer, dest.writableBytes());
                dest.writeBytes(this.readBuffer, positionInBuffer, bytesToCopy);
                pos += (long)bytesToCopy;
                length -= bytesToCopy;
                continue;
            }
            this.readBufferStartPosition = pos;
            int readBytes = this.fileChannel.read(this.readBuffer.internalNioBuffer(0, this.readCapacity), this.readBufferStartPosition);
            if (readBytes <= 0) {
                throw new IOException("Reading from filechannel returned a non-positive value. Short read.");
            }
            this.readBuffer.writerIndex(readBytes);
        }
        return (int)(pos - prevPos);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.writeBuffer.clear();
    }

    public synchronized int getNumOfBytesInWriteBuffer() {
        return this.writeBuffer.readableBytes();
    }

    long getUnpersistedBytes() {
        return this.unpersistedBytes.get();
    }
}

