/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.ldb;

import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;

public class ArrayGroupSort {
    private final int keySize;
    private final int groupSize;

    public ArrayGroupSort(int keySize, int groupSize) {
        Preconditions.checkArgument(keySize > 0);
        Preconditions.checkArgument(groupSize > 0);
        Preconditions.checkArgument(keySize <= groupSize, "keySize need to be less or equal the groupSize");
        this.keySize = keySize;
        this.groupSize = groupSize;
    }

    public void sort(long[] array) {
        this.sort(array, 0, array.length);
    }

    public void sort(long[] array, int offset, int length) {
        Preconditions.checkArgument(length % this.groupSize == 0, "Array length must be multiple of groupSize");
        this.quickSort(array, offset, length + offset - this.groupSize);
    }

    private void quickSort(long[] array, int low, int high) {
        if (low < high) {
            int pivotIdx = this.partition(array, low, high);
            this.quickSort(array, low, pivotIdx - this.groupSize);
            this.quickSort(array, pivotIdx + this.groupSize, high);
        }
    }

    private int alignGroup(int count) {
        return count - count % this.groupSize;
    }

    private int partition(long[] array, int low, int high) {
        int mid = low + this.alignGroup((high - low) / 2);
        this.swap(array, mid, high);
        int i = low;
        for (int j = low; j < high; j += this.groupSize) {
            if (!this.isLess(array, j, high)) continue;
            this.swap(array, j, i);
            i += this.groupSize;
        }
        this.swap(array, i, high);
        return i;
    }

    private void swap(long[] array, int a, int b) {
        for (int k = 0; k < this.groupSize; ++k) {
            long tmp = array[a + k];
            array[a + k] = array[b + k];
            array[b + k] = tmp;
        }
    }

    private boolean isLess(long[] array, int idx1, int idx2) {
        for (int i = 0; i < this.keySize; ++i) {
            long k1 = array[idx1 + i];
            long k2 = array[idx2 + i];
            if (k1 < k2) {
                return true;
            }
            if (k1 <= k2) continue;
            return false;
        }
        return false;
    }
}

