/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LayoutManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.data.ACL;

public class ZkLayoutManager
implements LayoutManager {
    private final ZooKeeper zk;
    private final String ledgersLayout;
    private final List<ACL> acls;

    public ZkLayoutManager(ZooKeeper zk, String ledgersRoot, List<ACL> acls) {
        this.zk = zk;
        this.ledgersLayout = ledgersRoot + "/" + "LAYOUT";
        this.acls = acls;
    }

    @VisibleForTesting
    public ZooKeeper getZk() {
        return this.zk;
    }

    @Override
    public LedgerLayout readLedgerLayout() throws IOException {
        try {
            byte[] layoutData = this.zk.getData(this.ledgersLayout, false, null);
            return LedgerLayout.parseLayout(layoutData);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void storeLedgerLayout(LedgerLayout layout) throws IOException {
        try {
            this.zk.create(this.ledgersLayout, layout.serialize(), this.acls, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e) {
            throw new LayoutManager.LedgerLayoutExistsException(e);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    @Override
    public void deleteLedgerLayout() throws IOException {
        try {
            this.zk.delete(this.ledgersLayout, -1);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }
}

