/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.server.http.service;

import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerAuditService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(TriggerAuditService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;

    public TriggerAuditService(ServerConfiguration conf, BookKeeperAdmin bka) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bka = bka;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.PUT == request.getMethod()) {
            try {
                this.bka.triggerAudit();
            }
            catch (Exception e) {
                LOG.error("Meet Exception: ", (Throwable)e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Exception when do operation." + e.getMessage());
                return response;
            }
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody("Success trigger audit.");
            LOG.debug("response body:" + response.getBody());
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT method");
        return response;
    }
}

