/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Strings;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.Cli;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.CompositeConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BKCommand<CommandFlagsT extends CliFlags>
extends CliCommand<BKFlags, CommandFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(BKCommand.class);

    protected BKCommand(CliSpec<CommandFlagsT> spec) {
        super(spec);
    }

    @Override
    public Boolean apply(BKFlags globalFlags, String[] args) {
        CliSpec<CliFlags> newSpec = CliSpec.newBuilder(this.spec).withRunFunc(cmdFlags -> this.apply(globalFlags, cmdFlags)).build();
        return 0 == Cli.runCli(newSpec, args);
    }

    @InterfaceAudience.Private
    public int apply(String commandName, CompositeConfiguration conf, String[] args) {
        CliSpec<CliFlags> newSpec = CliSpec.newBuilder(this.spec).withName(commandName).withRunFunc(cmdFlags -> this.apply(null, conf, new BKFlags(), cmdFlags)).build();
        return Cli.runCli(newSpec, args);
    }

    protected boolean apply(BKFlags bkFlags, CommandFlagsT cmdFlags) {
        ServiceURI serviceURI = null;
        if (null != bkFlags.serviceUri && !this.acceptServiceUri(serviceURI = ServiceURI.create(bkFlags.serviceUri))) {
            log.error("Unresolvable service uri by command '{}' : {}", (Object)this.path(), (Object)bkFlags.serviceUri);
            return false;
        }
        CompositeConfiguration conf = new CompositeConfiguration();
        if (!Strings.isNullOrEmpty(bkFlags.configFile)) {
            try {
                URL configFileUrl = Paths.get(bkFlags.configFile, new String[0]).toUri().toURL();
                PropertiesConfiguration loadedConf = new PropertiesConfiguration(configFileUrl);
                conf.addConfiguration(loadedConf);
            }
            catch (MalformedURLException e) {
                log.error("Could not open configuration file : {}", (Object)bkFlags.configFile, (Object)e);
                throw new IllegalArgumentException(e);
            }
            catch (ConfigurationException e) {
                log.error("Malformed configuration file : {}", (Object)bkFlags.configFile, (Object)e);
                throw new IllegalArgumentException(e);
            }
        }
        return this.apply(serviceURI, conf, bkFlags, cmdFlags);
    }

    protected boolean acceptServiceUri(ServiceURI serviceURI) {
        return true;
    }

    protected abstract boolean apply(ServiceURI var1, CompositeConfiguration var2, BKFlags var3, CommandFlagsT var4);
}

