/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.validator.MultipleListenerValidator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConfigurationUtils.class);

    public static String getDefaultOrConfiguredAddress(String configuredAddress) {
        if (StringUtils.isBlank(configuredAddress)) {
            return ServiceConfigurationUtils.unsafeLocalhostResolve();
        }
        return configuredAddress;
    }

    public static String unsafeLocalhostResolve() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("Failed to resolve localhost name.", ex);
        }
    }

    public static String getAppliedAdvertisedAddress(ServiceConfiguration configuration, boolean ignoreAdvertisedListener) {
        String address;
        Map<String, AdvertisedListener> result = MultipleListenerValidator.validateAndAnalysisAdvertisedListener(configuration);
        String advertisedAddress = configuration.getAdvertisedAddress();
        if (advertisedAddress != null) {
            return advertisedAddress;
        }
        AdvertisedListener advertisedListener = result.get(configuration.getInternalListenerName());
        if (advertisedListener != null && !ignoreAdvertisedListener && (address = advertisedListener.getBrokerServiceUrl().getHost()) != null) {
            return address;
        }
        return ServiceConfigurationUtils.getDefaultOrConfiguredAddress(advertisedAddress);
    }
}

