/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Joiner;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.core.Response;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarAuthorizationProvider
implements AuthorizationProvider {
    private static final Logger log = LoggerFactory.getLogger(PulsarAuthorizationProvider.class);
    public ServiceConfiguration conf;
    protected PulsarResources pulsarResources;
    private static final String POLICY_ROOT = "/admin/policies/";
    public static final String POLICIES = "policies";
    private static final String POLICIES_READONLY_FLAG_PATH = "/admin/flags/policies-readonly";

    public PulsarAuthorizationProvider() {
    }

    public PulsarAuthorizationProvider(ServiceConfiguration conf, ConfigurationCacheService configCache) throws IOException {
        this.initialize(conf, configCache);
    }

    @Override
    public void initialize(ServiceConfiguration conf, ConfigurationCacheService configCache) throws IOException {
        Preconditions.checkNotNull(conf, "ServiceConfiguration can't be null");
        Preconditions.checkNotNull(configCache, "ConfigurationCacheService can't be null");
        this.conf = conf;
        this.pulsarResources = configCache.getPulsarResources();
    }

    @Override
    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.checkAuthorization(topicName, role, AuthAction.produce);
    }

    @Override
    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        CompletableFuture<Boolean> permissionFuture = new CompletableFuture<Boolean>();
        try {
            ((CompletableFuture)this.pulsarResources.getNamespaceResources().getAsync(POLICY_ROOT + topicName.getNamespace()).thenAccept(policies -> {
                if (!policies.isPresent()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Policies node couldn't be found for topic : {}", (Object)topicName);
                    }
                } else if (StringUtils.isNotBlank(subscription)) {
                    Set<String> roles = ((Policies)policies.get()).auth_policies.getSubscriptionAuthentication().get(subscription);
                    if (roles != null && !roles.isEmpty() && !roles.contains(role)) {
                        log.warn("[{}] is not authorized to subscribe on {}-{}", new Object[]{role, topicName, subscription});
                        PulsarServerException ex2 = new PulsarServerException(String.format("%s is not authorized to access subscription %s on topic %s", role, subscription, topicName));
                        permissionFuture.complete(false);
                        return;
                    }
                    switch (((Policies)policies.get()).subscription_auth_mode) {
                        case Prefix: {
                            if (subscription.startsWith(role)) break;
                            PulsarServerException ex3 = new PulsarServerException(String.format("Failed to create consumer - The subscription name needs to be prefixed by the authentication role, like %s-xxxx for topic: %s", role, topicName));
                            permissionFuture.completeExceptionally(ex3);
                            return;
                        }
                    }
                }
                ((CompletableFuture)this.checkAuthorization(topicName, role, AuthAction.consume).thenAccept(isAuthorized -> permissionFuture.complete((Boolean)isAuthorized))).exceptionally(ex -> {
                    log.warn("Client with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, ex.getMessage()});
                    permissionFuture.completeExceptionally((Throwable)ex);
                    return null;
                });
            })).exceptionally(ex -> {
                log.warn("Client with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, ex.getMessage()});
                permissionFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        catch (Exception e) {
            log.warn("Client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            permissionFuture.completeExceptionally(e);
        }
        return permissionFuture;
    }

    @Override
    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        CompletableFuture<Boolean> finalResult = new CompletableFuture<Boolean>();
        this.canProduceAsync(topicName, role, authenticationData).whenComplete((produceAuthorized, ex) -> {
            if (ex == null) {
                if (produceAuthorized.booleanValue()) {
                    finalResult.complete((Boolean)produceAuthorized);
                    return;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Topic [{}] Role [{}] exception occurred while trying to check Produce permissions. {}", new Object[]{topicName.toString(), role, ex.getMessage()});
            }
            this.canConsumeAsync(topicName, role, authenticationData, null).whenComplete((consumeAuthorized, e) -> {
                if (e == null) {
                    finalResult.complete((Boolean)consumeAuthorized);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Topic [{}] Role [{}] exception occurred while trying to check Consume permissions. {}", new Object[]{topicName.toString(), role, e.getMessage()});
                    }
                    finalResult.completeExceptionally((Throwable)e);
                }
            });
        });
        return finalResult;
    }

    @Override
    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.functions);
    }

    @Override
    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.sources);
    }

    @Override
    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.sinks);
    }

    private CompletableFuture<Boolean> allowConsumeOrProduceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        CompletableFuture<Boolean> finalResult = new CompletableFuture<Boolean>();
        this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.consume).whenComplete((consumeAuthorized, e) -> {
            if (e == null) {
                if (consumeAuthorized.booleanValue()) {
                    finalResult.complete((Boolean)consumeAuthorized);
                    return;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Namespace [{}] Role [{}] exception occurred while trying to check Consume permission. {}", new Object[]{namespaceName, role, e.getCause()});
            }
            this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authenticationData, AuthAction.produce).whenComplete((produceAuthorized, ex) -> {
                if (ex == null) {
                    finalResult.complete((Boolean)produceAuthorized);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Namespace [{}] Role [{}] exception occurred while trying to check Produce permission. {}", new Object[]{namespaceName, role, ex.getCause()});
                    }
                    finalResult.completeExceptionally(ex.getCause());
                }
            });
        });
        return finalResult;
    }

    private CompletableFuture<Boolean> allowTheSpecifiedActionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData, AuthAction authAction) {
        CompletableFuture<Boolean> permissionFuture = new CompletableFuture<Boolean>();
        try {
            ((CompletableFuture)this.pulsarResources.getNamespaceResources().getAsync(POLICY_ROOT + namespaceName.toString()).thenAccept(policies -> {
                if (!policies.isPresent()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Policies node couldn't be found for namespace : {}", (Object)namespaceName);
                    }
                } else {
                    Map<String, Set<AuthAction>> namespaceRoles = ((Policies)policies.get()).auth_policies.getNamespaceAuthentication();
                    Set<AuthAction> namespaceActions = namespaceRoles.get(role);
                    if (namespaceActions != null && namespaceActions.contains((Object)authAction)) {
                        permissionFuture.complete(true);
                        return;
                    }
                    if (this.conf.isAuthorizationAllowWildcardsMatching() && this.checkWildcardPermission(role, authAction, namespaceRoles)) {
                        permissionFuture.complete(true);
                        return;
                    }
                }
                permissionFuture.complete(false);
            })).exceptionally(ex -> {
                log.warn("Client  with Role - {} failed to get permissions for namespace - {}. {}", new Object[]{role, namespaceName, ex.getMessage()});
                permissionFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        catch (Exception e) {
            log.warn("Client  with Role - {} failed to get permissions for namespace - {}. {}", new Object[]{role, namespaceName, e.getMessage()});
            permissionFuture.completeExceptionally(e);
        }
        return permissionFuture;
    }

    @Override
    public CompletableFuture<Void> grantPermissionAsync(TopicName topicName, Set<AuthAction> actions, String role, String authDataJson) {
        return this.grantPermissionAsync(topicName.getNamespaceObject(), actions, role, authDataJson);
    }

    @Override
    public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespaceName, Set<AuthAction> actions, String role, String authDataJson) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            this.validatePoliciesReadOnlyAccess();
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            return result;
        }
        String policiesPath = String.format("/%s/%s/%s", "admin", POLICIES, namespaceName.toString());
        try {
            this.pulsarResources.getNamespaceResources().set(policiesPath, policies -> {
                policies.auth_policies.getNamespaceAuthentication().put(role, actions);
                return policies;
            });
            log.info("[{}] Successfully granted access for role {}: {} - namespace {}", new Object[]{role, role, actions, namespaceName});
            result.complete(null);
        }
        catch (MetadataStoreException.NotFoundException e) {
            log.warn("[{}] Failed to set permissions for namespace {}: does not exist", (Object)role, (Object)namespaceName);
            result.completeExceptionally(new IllegalArgumentException("Namespace does not exist" + namespaceName));
        }
        catch (MetadataStoreException.BadVersionException e) {
            log.warn("[{}] Failed to set permissions for namespace {}: concurrent modification", (Object)role, (Object)namespaceName);
            result.completeExceptionally(new IllegalStateException("Concurrent modification on zk path: " + policiesPath + ", " + e.getMessage()));
        }
        catch (Exception e) {
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{role, namespaceName, e});
            result.completeExceptionally(new IllegalStateException("Failed to get permissions for namespace " + namespaceName));
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
        return this.updateSubscriptionPermissionAsync(namespace, subscriptionName, roles, false);
    }

    @Override
    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
        return this.updateSubscriptionPermissionAsync(namespace, subscriptionName, Collections.singleton(role), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompletableFuture<Void> updateSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, boolean remove) {
        try {
            this.validatePoliciesReadOnlyAccess();
        }
        catch (Exception e) {
            return FutureUtil.failedFuture(e);
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        String policiesPath = String.format("/%s/%s/%s", "admin", POLICIES, namespace.toString());
        try {
            Policies policies = (Policies)this.pulsarResources.getNamespaceResources().get(policiesPath).orElseThrow(() -> new MetadataStoreException.NotFoundException(policiesPath + " not found"));
            if (remove) {
                if (policies.auth_policies.getSubscriptionAuthentication().get(subscriptionName) == null) {
                    log.info("[{}] Couldn't find role {} while revoking for sub = {}", new Object[]{namespace, subscriptionName, roles});
                    result.completeExceptionally(new IllegalArgumentException("couldn't find subscription"));
                    return result;
                }
                policies.auth_policies.getSubscriptionAuthentication().get(subscriptionName).removeAll(roles);
            } else {
                policies.auth_policies.getSubscriptionAuthentication().put(subscriptionName, roles);
            }
            this.pulsarResources.getNamespaceResources().set(policiesPath, data -> policies);
            log.info("[{}] Successfully granted access for role {} for sub = {}", new Object[]{namespace, subscriptionName, roles});
            result.complete(null);
            return result;
        }
        catch (MetadataStoreException.NotFoundException e) {
            log.warn("[{}] Failed to set permissions for namespace {}: does not exist", (Object)subscriptionName, (Object)namespace);
            result.completeExceptionally(new IllegalArgumentException("Namespace does not exist" + namespace));
            return result;
        }
        catch (MetadataStoreException.BadVersionException e) {
            log.warn("[{}] Failed to set permissions for {} on namespace {}: concurrent modification", new Object[]{subscriptionName, roles, namespace});
            result.completeExceptionally(new IllegalStateException("Concurrent modification on zk path: " + policiesPath + ", " + e.getMessage()));
            return result;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get permissions for role {} on namespace {}", new Object[]{subscriptionName, roles, namespace, e});
            result.completeExceptionally(new IllegalStateException("Failed to get permissions for namespace " + namespace));
        }
        return result;
    }

    private CompletableFuture<Boolean> checkAuthorization(TopicName topicName, String role, AuthAction action) {
        return this.checkPermission(topicName, role, action).thenApply(isPermission -> isPermission != false && this.checkCluster(topicName));
    }

    private boolean checkCluster(TopicName topicName) {
        if (topicName.isGlobal() || this.conf.getClusterName().equals(topicName.getCluster())) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Topic [{}] does not belong to local cluster [{}]", (Object)topicName.toString(), (Object)this.conf.getClusterName());
        }
        return false;
    }

    public CompletableFuture<Boolean> checkPermission(TopicName topicName, String role, AuthAction action) {
        CompletableFuture<Boolean> permissionFuture = new CompletableFuture<Boolean>();
        try {
            ((CompletableFuture)this.pulsarResources.getNamespaceResources().getAsync(POLICY_ROOT + topicName.getNamespace()).thenAccept(policies -> {
                if (!policies.isPresent()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Policies node couldn't be found for topic : {}", (Object)topicName);
                    }
                } else {
                    Set<AuthAction> topicActions;
                    Map<String, Set<AuthAction>> namespaceRoles = ((Policies)policies.get()).auth_policies.getNamespaceAuthentication();
                    Set<AuthAction> namespaceActions = namespaceRoles.get(role);
                    if (namespaceActions != null && namespaceActions.contains((Object)action)) {
                        permissionFuture.complete(true);
                        return;
                    }
                    Map<String, Set<AuthAction>> topicRoles = ((Policies)policies.get()).auth_policies.getTopicAuthentication().get(topicName.toString());
                    if (topicRoles != null && role != null && (topicActions = topicRoles.get(role)) != null && topicActions.contains((Object)action)) {
                        permissionFuture.complete(true);
                        return;
                    }
                    if (this.conf.isAuthorizationAllowWildcardsMatching()) {
                        if (this.checkWildcardPermission(role, action, namespaceRoles)) {
                            permissionFuture.complete(true);
                            return;
                        }
                        if (topicRoles != null && this.checkWildcardPermission(role, action, topicRoles)) {
                            permissionFuture.complete(true);
                            return;
                        }
                    }
                    if (topicName.isPartitioned() && (topicRoles = ((Policies)policies.get()).auth_policies.getTopicAuthentication().get(topicName.getPartitionedTopicName())) != null && (topicActions = topicRoles.get(role)) != null && topicActions.contains((Object)action)) {
                        permissionFuture.complete(true);
                        return;
                    }
                }
                permissionFuture.complete(false);
            })).exceptionally(ex -> {
                log.warn("Client with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, ex.getMessage()});
                permissionFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        catch (Exception e) {
            log.warn("Client with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            permissionFuture.completeExceptionally(e);
        }
        return permissionFuture;
    }

    private boolean checkWildcardPermission(String checkedRole, AuthAction checkedAction, Map<String, Set<AuthAction>> permissionMap) {
        for (Map.Entry<String, Set<AuthAction>> permissionData : permissionMap.entrySet()) {
            String permittedRole = permissionData.getKey();
            Set<AuthAction> permittedActions = permissionData.getValue();
            if (checkedRole == null) continue;
            if (permittedRole.charAt(permittedRole.length() - 1) == '*' && checkedRole.startsWith(permittedRole.substring(0, permittedRole.length() - 1)) && permittedActions.contains((Object)checkedAction)) {
                return true;
            }
            if (permittedRole.charAt(0) != '*' || !checkedRole.endsWith(permittedRole.substring(1)) || !permittedActions.contains((Object)checkedAction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    private void validatePoliciesReadOnlyAccess() {
        boolean arePoliciesReadOnly = true;
        try {
            arePoliciesReadOnly = this.pulsarResources.getNamespaceResources().exists(POLICIES_READONLY_FLAG_PATH);
        }
        catch (Exception e) {
            log.warn("Unable to fetch contents of [{}] from global zookeeper", (Object)POLICIES_READONLY_FLAG_PATH, (Object)e);
            throw new IllegalStateException("Unable to fetch content from global zk");
        }
        if (arePoliciesReadOnly) {
            if (log.isDebugEnabled()) {
                log.debug("Policies are read-only. Broker cannot do read-write operations");
            }
            throw new IllegalStateException("policies are in readonly mode");
        }
    }

    @Override
    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.validateTenantAdminAccess(tenantName, role, authData);
    }

    @Override
    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        if (log.isDebugEnabled()) {
            log.debug("Check allowNamespaceOperationAsync [{}] on [{}].", (Object)operation.name(), (Object)namespaceName);
        }
        return this.validateTenantAdminAccess(namespaceName.getTenant(), role, authData).thenCompose(isSuperUserOrAdmin -> {
            if (log.isDebugEnabled()) {
                log.debug("Verify if role {} is allowed to {} to namespace {}: isSuperUserOrAdmin={}", new Object[]{role, operation, namespaceName, isSuperUserOrAdmin});
            }
            if (isSuperUserOrAdmin.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            switch (operation) {
                case PACKAGES: {
                    return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authData, AuthAction.packages);
                }
                case GET_TOPIC: 
                case GET_TOPICS: 
                case GET_BUNDLE: {
                    return this.allowConsumeOrProduceOpsAsync(namespaceName, role, authData);
                }
                case UNSUBSCRIBE: 
                case CLEAR_BACKLOG: {
                    return this.allowTheSpecifiedActionOpsAsync(namespaceName, role, authData, AuthAction.consume);
                }
                case CREATE_TOPIC: 
                case DELETE_TOPIC: 
                case ADD_BUNDLE: 
                case DELETE_BUNDLE: 
                case GRANT_PERMISSION: 
                case GET_PERMISSION: 
                case REVOKE_PERMISSION: {
                    return CompletableFuture.completedFuture(false);
                }
            }
            return FutureUtil.failedFuture(new IllegalStateException("NamespaceOperation [" + operation.name() + "] is not supported."));
        });
    }

    @Override
    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return this.validateTenantAdminAccess(namespaceName.getTenant(), role, authData);
    }

    @Override
    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, String role, TopicOperation operation, AuthenticationDataSource authData) {
        if (log.isDebugEnabled()) {
            log.debug("Check allowTopicOperationAsync [{}] on [{}].", (Object)operation.name(), (Object)topicName);
        }
        return this.validateTenantAdminAccess(topicName.getTenant(), role, authData).thenCompose(isSuperUserOrAdmin -> {
            if (log.isDebugEnabled()) {
                log.debug("Verify if role {} is allowed to {} to topic {}: isSuperUserOrAdmin={}", new Object[]{role, operation, topicName, isSuperUserOrAdmin});
            }
            if (isSuperUserOrAdmin.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            switch (operation) {
                case LOOKUP: 
                case GET_STATS: 
                case GET_METADATA: {
                    return this.canLookupAsync(topicName, role, authData);
                }
                case PRODUCE: {
                    return this.canProduceAsync(topicName, role, authData);
                }
                case GET_SUBSCRIPTIONS: 
                case CONSUME: 
                case SUBSCRIBE: 
                case UNSUBSCRIBE: 
                case SKIP: 
                case EXPIRE_MESSAGES: 
                case PEEK_MESSAGES: 
                case RESET_CURSOR: 
                case SET_REPLICATED_SUBSCRIPTION_STATUS: {
                    return this.canConsumeAsync(topicName, role, authData, authData.getSubscription());
                }
                case TERMINATE: 
                case COMPACT: 
                case OFFLOAD: 
                case UNLOAD: 
                case ADD_BUNDLE_RANGE: 
                case GET_BUNDLE_RANGE: 
                case DELETE_BUNDLE_RANGE: {
                    return CompletableFuture.completedFuture(false);
                }
            }
            return FutureUtil.failedFuture(new IllegalStateException("TopicOperation [" + operation.name() + "] is not supported."));
        });
    }

    @Override
    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, String role, PolicyName policyName, PolicyOperation policyOperation, AuthenticationDataSource authData) {
        return this.validateTenantAdminAccess(topicName.getTenant(), role, authData);
    }

    private static String path(String ... parts) {
        StringBuilder sb = new StringBuilder();
        sb.append("/admin/");
        Joiner.on('/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    public CompletableFuture<Boolean> validateTenantAdminAccess(String tenantName, String role, AuthenticationDataSource authData) {
        return this.isSuperUser(role, authData, this.conf).thenCompose(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            try {
                TenantInfo tenantInfo = (TenantInfo)this.pulsarResources.getTenantResources().get(PulsarAuthorizationProvider.path(POLICIES, tenantName)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Tenant does not exist"));
                return this.isTenantAdmin(tenantName, role, tenantInfo, authData);
            }
            catch (MetadataStoreException.NotFoundException e) {
                log.warn("Failed to get tenant info data for non existing tenant {}", (Object)tenantName);
                throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
            }
            catch (Exception e) {
                log.error("Failed to get tenant {}", (Object)tenantName, (Object)e);
                throw new RestException(e);
            }
        });
    }
}

