/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.cache;

import java.util.Map;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooDefs;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationCacheService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationCacheService.class);
    private final ZooKeeperCache cache;
    private ZooKeeperDataCache<TenantInfoImpl> propertiesCache;
    private ZooKeeperDataCache<Policies> policiesCache;
    private ZooKeeperDataCache<ClusterDataImpl> clustersCache;
    private ZooKeeperChildrenCache clustersListCache;
    private ZooKeeperChildrenCache failureDomainListCache;
    private ZooKeeperDataCache<NamespaceIsolationPolicies> namespaceIsolationPoliciesCache;
    private ZooKeeperDataCache<FailureDomainImpl> failureDomainCache;
    private PulsarResources pulsarResources;
    public static final String POLICIES = "policies";
    public static final String RESOURCEGROUPS = "resourcegroups";
    public static final String FAILURE_DOMAIN = "failureDomain";
    public final String CLUSTER_FAILURE_DOMAIN_ROOT;
    public static final String POLICIES_ROOT = "/admin/policies";
    private static final String CLUSTERS_ROOT = "/admin/clusters";
    public static final String PARTITIONED_TOPICS_ROOT = "/admin/partitioned-topics";

    public ConfigurationCacheService(ZooKeeperCache cache, String configuredClusterName) throws PulsarServerException {
        this(cache, configuredClusterName, null);
    }

    public ConfigurationCacheService(ZooKeeperCache cache, String configuredClusterName, PulsarResources pulsarResources) throws PulsarServerException {
        this.cache = cache;
        this.pulsarResources = pulsarResources;
        this.CLUSTER_FAILURE_DOMAIN_ROOT = "/admin/clusters/" + configuredClusterName + "/" + FAILURE_DOMAIN;
        if (cache == null) {
            return;
        }
        this.initZK();
        this.propertiesCache = new ZooKeeperDataCache<TenantInfoImpl>(cache){

            @Override
            public TenantInfoImpl deserialize(String path, byte[] content) throws Exception {
                return ObjectMapperFactory.getThreadLocal().readValue(content, TenantInfoImpl.class);
            }
        };
        this.policiesCache = new ZooKeeperDataCache<Policies>(cache){

            @Override
            public Policies deserialize(String path, byte[] content) throws Exception {
                return ObjectMapperFactory.getThreadLocal().readValue(content, Policies.class);
            }
        };
        this.clustersCache = new ZooKeeperDataCache<ClusterDataImpl>(cache){

            @Override
            public ClusterDataImpl deserialize(String path, byte[] content) throws Exception {
                return ObjectMapperFactory.getThreadLocal().readValue(content, ClusterDataImpl.class);
            }
        };
        this.clustersListCache = new ZooKeeperChildrenCache(cache, CLUSTERS_ROOT);
        if (StringUtils.isNotBlank(configuredClusterName)) {
            this.createFailureDomainRoot(cache.getZooKeeper(), this.CLUSTER_FAILURE_DOMAIN_ROOT);
            this.failureDomainListCache = new ZooKeeperChildrenCache(cache, this.CLUSTER_FAILURE_DOMAIN_ROOT);
        }
        this.namespaceIsolationPoliciesCache = new ZooKeeperDataCache<NamespaceIsolationPolicies>(cache){

            @Override
            public NamespaceIsolationPolicies deserialize(String path, byte[] content) throws Exception {
                return new NamespaceIsolationPolicies(ObjectMapperFactory.getThreadLocal().readValue(content, new TypeReference<Map<String, NamespaceIsolationDataImpl>>(){}));
            }
        };
        this.failureDomainCache = new ZooKeeperDataCache<FailureDomainImpl>(cache){

            @Override
            public FailureDomainImpl deserialize(String path, byte[] content) throws Exception {
                return ObjectMapperFactory.getThreadLocal().readValue(content, FailureDomainImpl.class);
            }
        };
    }

    private void createFailureDomainRoot(ZooKeeper zk, String path) {
        try {
            String clusterZnodePath;
            int index = path.lastIndexOf(47);
            String string = clusterZnodePath = index > 0 ? path.substring(0, index) : null;
            if (zk.exists(clusterZnodePath, false) != null && zk.exists(path, false) == null) {
                try {
                    byte[] data = "".getBytes();
                    ZkUtils.createFullPathOptimistic(zk, path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    LOG.info("Successfully created failure-domain znode at {}", (Object)path);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {}
            }
        }
        catch (KeeperException.NodeExistsException index) {
        }
        catch (Exception e) {
            LOG.warn("Failed to create failure-domain znode {} ", (Object)path, (Object)e);
        }
    }

    private void initZK() throws PulsarServerException {
        String[] paths = new String[]{CLUSTERS_ROOT, POLICIES_ROOT};
        try {
            ZooKeeper zk = this.cache.getZooKeeper();
            for (String path : paths) {
                try {
                    if (zk.exists(path, false) != null) continue;
                    ZkUtils.createFullPathOptimistic(zk, path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new PulsarServerException(e);
        }
    }

    public ZooKeeperCache cache() {
        return this.cache;
    }

    public ZooKeeperDataCache<TenantInfoImpl> propertiesCache() {
        return this.propertiesCache;
    }

    public ZooKeeperDataCache<Policies> policiesCache() {
        return this.policiesCache;
    }

    public ZooKeeperDataCache<ClusterDataImpl> clustersCache() {
        return this.clustersCache;
    }

    public ZooKeeperChildrenCache clustersListCache() {
        return this.clustersListCache;
    }

    public ZooKeeperChildrenCache failureDomainListCache() {
        return this.failureDomainListCache;
    }

    public ZooKeeper getZooKeeper() {
        return this.cache.getZooKeeper();
    }

    public ZooKeeperDataCache<NamespaceIsolationPolicies> namespaceIsolationPoliciesCache() {
        return this.namespaceIsolationPoliciesCache;
    }

    public ZooKeeperDataCache<FailureDomainImpl> failureDomainCache() {
        return this.failureDomainCache;
    }

    public PulsarResources getPulsarResources() {
        return this.pulsarResources;
    }
}

