/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Joiner;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class BaseResources<T> {
    protected static final String BASE_POLICIES_PATH = "/admin/policies";
    private final MetadataStoreExtended store;
    private final MetadataCache<T> cache;
    private int operationTimeoutSec;

    public BaseResources(MetadataStoreExtended store, Class<T> clazz, int operationTimeoutSec) {
        this.store = store;
        this.cache = store.getMetadataCache(clazz);
        this.operationTimeoutSec = operationTimeoutSec;
    }

    public BaseResources(MetadataStoreExtended store, TypeReference<T> typeRef, int operationTimeoutSec) {
        this.store = store;
        this.cache = store.getMetadataCache(typeRef);
        this.operationTimeoutSec = operationTimeoutSec;
    }

    public List<String> getChildren(String path) throws MetadataStoreException {
        try {
            return this.getChildrenAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to get childeren of " + path, e);
        }
    }

    public CompletableFuture<List<String>> getChildrenAsync(String path) {
        return this.cache.getChildren(path);
    }

    public Optional<T> get(String path) throws MetadataStoreException {
        try {
            return this.getAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to get data from " + path, e);
        }
    }

    public CompletableFuture<Optional<T>> getAsync(String path) {
        return this.cache.get(path);
    }

    public void set(String path, Function<T, T> modifyFunction) throws MetadataStoreException {
        try {
            this.setAsync(path, modifyFunction).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to set data for " + path, e);
        }
    }

    public CompletableFuture<Void> setAsync(String path, Function<T, T> modifyFunction) {
        return this.cache.readModifyUpdate(path, modifyFunction).thenApply(__ -> null);
    }

    public void setWithCreate(String path, Function<Optional<T>, T> createFunction) throws MetadataStoreException {
        try {
            this.setWithCreateAsync(path, createFunction).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to set/create " + path, e);
        }
    }

    public CompletableFuture<Void> setWithCreateAsync(String path, Function<Optional<T>, T> createFunction) {
        return this.cache.readModifyUpdateOrCreate(path, createFunction).thenApply(__ -> null);
    }

    public void create(String path, T data) throws MetadataStoreException {
        try {
            this.createAsync(path, data).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to create " + path, e);
        }
    }

    public CompletableFuture<Void> createAsync(String path, T data) {
        return this.cache.create(path, data);
    }

    public void delete(String path) throws MetadataStoreException {
        try {
            this.deleteAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to delete " + path, e);
        }
    }

    public CompletableFuture<Void> deleteAsync(String path) {
        return this.cache.delete(path);
    }

    public boolean exists(String path) throws MetadataStoreException {
        try {
            return this.existsAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to check exist " + path, e);
        }
    }

    public int getOperationTimeoutSec() {
        return this.operationTimeoutSec;
    }

    public CompletableFuture<Boolean> existsAsync(String path) {
        return this.cache.exists(path);
    }

    protected static String joinPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        Joiner.on('/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    public MetadataStoreExtended getStore() {
        return this.store;
    }

    public MetadataCache<T> getCache() {
        return this.cache;
    }
}

