/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.metadata.api.MetadataStore;

public class TopicResources {
    private static final String MANAGED_LEDGER_PATH = "/managed-ledgers";
    private final MetadataStore store;

    public TopicResources(MetadataStore store) {
        this.store = store;
    }

    public CompletableFuture<List<String>> getExistingPartitions(TopicName topic) {
        return this.getExistingPartitions(topic.getNamespaceObject(), topic.getDomain());
    }

    public CompletableFuture<List<String>> getExistingPartitions(NamespaceName ns, TopicDomain domain) {
        String topicPartitionPath = "/managed-ledgers/" + ns + "/" + (Object)((Object)domain);
        return this.store.getChildren(topicPartitionPath).thenApply(topics -> topics.stream().map(s -> String.format("%s://%s/%s", domain.value(), ns, Codec.decode(s))).collect(Collectors.toList()));
    }
}

