/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Brokers;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.policies.data.BrokerInfo;
import org.apache.pulsar.common.policies.data.NamespaceOwnershipStatus;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Entity;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;

public class BrokersImpl
extends BaseResource
implements Brokers {
    private final WebTarget adminBrokers;

    public BrokersImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBrokers = web.path("admin/v2/brokers");
    }

    @Override
    public List<String> getActiveBrokers(String cluster) throws PulsarAdminException {
        try {
            return this.getActiveBrokersAsync(cluster).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<List<String>> getActiveBrokersAsync(String cluster) {
        WebTarget path = this.adminBrokers.path(cluster);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> brokers) {
                future.complete(brokers);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public BrokerInfo getLeaderBroker() throws PulsarAdminException {
        try {
            return this.getLeaderBrokerAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<BrokerInfo> getLeaderBrokerAsync() {
        WebTarget path = this.adminBrokers.path("leaderBroker");
        final CompletableFuture<BrokerInfo> future = new CompletableFuture<BrokerInfo>();
        this.asyncGetRequest(path, new InvocationCallback<BrokerInfo>(){

            @Override
            public void completed(BrokerInfo leaderBroker) {
                future.complete(leaderBroker);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public Map<String, NamespaceOwnershipStatus> getOwnedNamespaces(String cluster, String brokerUrl) throws PulsarAdminException {
        try {
            return this.getOwnedNamespacesAsync(cluster, brokerUrl).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Map<String, NamespaceOwnershipStatus>> getOwnedNamespacesAsync(String cluster, String brokerUrl) {
        WebTarget path = this.adminBrokers.path(cluster).path(brokerUrl).path("ownedNamespaces");
        final CompletableFuture<Map<String, NamespaceOwnershipStatus>> future = new CompletableFuture<Map<String, NamespaceOwnershipStatus>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, NamespaceOwnershipStatus>>(){

            @Override
            public void completed(Map<String, NamespaceOwnershipStatus> ownedNamespaces) {
                future.complete(ownedNamespaces);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void updateDynamicConfiguration(String configName, String configValue) throws PulsarAdminException {
        try {
            this.updateDynamicConfigurationAsync(configName, configValue).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> updateDynamicConfigurationAsync(String configName, String configValue) {
        String value = Codec.encode(configValue);
        WebTarget path = this.adminBrokers.path("configuration").path(configName).path(value);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void deleteDynamicConfiguration(String configName) throws PulsarAdminException {
        try {
            this.deleteDynamicConfigurationAsync(configName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteDynamicConfigurationAsync(String configName) {
        WebTarget path = this.adminBrokers.path("configuration").path(configName);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public Map<String, String> getAllDynamicConfigurations() throws PulsarAdminException {
        try {
            return this.getAllDynamicConfigurationsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Map<String, String>> getAllDynamicConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("values");
        final CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, String>>(){

            @Override
            public void completed(Map<String, String> allConfs) {
                future.complete(allConfs);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<String> getDynamicConfigurationNames() throws PulsarAdminException {
        try {
            return this.getDynamicConfigurationNamesAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<List<String>> getDynamicConfigurationNamesAsync() {
        WebTarget path = this.adminBrokers.path("configuration");
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<List<String>>(){

            @Override
            public void completed(List<String> confNames) {
                future.complete(confNames);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public Map<String, String> getRuntimeConfigurations() throws PulsarAdminException {
        try {
            return this.getRuntimeConfigurationsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Map<String, String>> getRuntimeConfigurationsAsync() {
        WebTarget path = this.adminBrokers.path("configuration").path("runtime");
        final CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<String, String>>(){

            @Override
            public void completed(Map<String, String> runtimeConfs) {
                future.complete(runtimeConfs);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public InternalConfigurationData getInternalConfigurationData() throws PulsarAdminException {
        try {
            return this.getInternalConfigurationDataAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<InternalConfigurationData> getInternalConfigurationDataAsync() {
        WebTarget path = this.adminBrokers.path("internal-configuration");
        final CompletableFuture<InternalConfigurationData> future = new CompletableFuture<InternalConfigurationData>();
        this.asyncGetRequest(path, new InvocationCallback<InternalConfigurationData>(){

            @Override
            public void completed(InternalConfigurationData internalConfigurationData) {
                future.complete(internalConfigurationData);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void backlogQuotaCheck() throws PulsarAdminException {
        try {
            this.backlogQuotaCheckAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> backlogQuotaCheckAsync() {
        WebTarget path = this.adminBrokers.path("backlogQuotaCheck");
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(path, new InvocationCallback<Void>(){

            @Override
            public void completed(Void unused) {
                future.complete(null);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    @Override
    public void healthcheck() throws PulsarAdminException {
        try {
            this.healthcheckAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> healthcheckAsync() {
        WebTarget path = this.adminBrokers.path("health");
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String result) {
                if (!"ok".equalsIgnoreCase(result.trim())) {
                    future.completeExceptionally(new PulsarAdminException("Healthcheck returned unexpected result: " + result));
                } else {
                    future.complete(null);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public String getVersion() throws PulsarAdminException {
        WebTarget path = this.adminBrokers.path("version");
        try {
            final CompletableFuture future = new CompletableFuture();
            this.asyncGetRequest(path, new InvocationCallback<String>(){

                @Override
                public void completed(String version) {
                    future.complete(version);
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BrokersImpl.this.getApiException(throwable.getCause()));
                }
            });
            return (String)future.get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }
}

