/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Lookup;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;

public class LookupImpl
extends BaseResource
implements Lookup {
    private final WebTarget v2lookup;
    private final boolean useTls;
    private final Topics topics;

    public LookupImpl(WebTarget web, Authentication auth, boolean useTls, long readTimeoutMs, Topics topics) {
        super(auth, readTimeoutMs);
        this.useTls = useTls;
        this.v2lookup = web.path("/lookup/v2");
        this.topics = topics;
    }

    @Override
    public String lookupTopic(String topic) throws PulsarAdminException {
        try {
            return this.lookupTopicAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<String> lookupTopicAsync(String topic) {
        TopicName topicName = TopicName.get(topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget path = this.v2lookup.path(prefix).path(topicName.getLookupName());
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<LookupData>(){

            @Override
            public void completed(LookupData lookupData) {
                if (LookupImpl.this.useTls) {
                    future.complete(lookupData.getBrokerUrlTls());
                } else {
                    future.complete(lookupData.getBrokerUrl());
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(LookupImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public Map<String, String> lookupPartitionedTopic(String topic) throws PulsarAdminException {
        try {
            return this.lookupPartitionedTopicAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Map<String, String>> lookupPartitionedTopicAsync(String topic) {
        CompletableFuture<Map<String, String>> future = new CompletableFuture<Map<String, String>>();
        ((CompletableFuture)this.topics.getPartitionedTopicMetadataAsync(topic).thenAccept(partitionedTopicMetadata -> {
            int partitions = partitionedTopicMetadata.partitions;
            if (partitions <= 0) {
                future.completeExceptionally(new PulsarAdminException("Topic " + topic + " is not a partitioned topic"));
                return;
            }
            LinkedHashMap<String, CompletableFuture<String>> lookupResult = new LinkedHashMap<String, CompletableFuture<String>>(partitions);
            for (int i = 0; i < partitions; ++i) {
                String partitionTopicName = topic + "-partition-" + i;
                lookupResult.put(partitionTopicName, this.lookupTopicAsync(partitionTopicName));
            }
            FutureUtil.waitForAll(new ArrayList(lookupResult.values())).whenComplete((url, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally(this.getApiException(throwable.getCause()));
                    return;
                }
                LinkedHashMap result = new LinkedHashMap();
                for (Map.Entry entry : lookupResult.entrySet()) {
                    try {
                        result.put(entry.getKey(), ((CompletableFuture)entry.getValue()).get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        future.completeExceptionally(e);
                        return;
                    }
                }
                future.complete(result);
            });
        })).exceptionally(throwable -> {
            future.completeExceptionally(this.getApiException(throwable.getCause()));
            return null;
        });
        return future;
    }

    @Override
    public String getBundleRange(String topic) throws PulsarAdminException {
        try {
            return this.getBundleRangeAsync(topic).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<String> getBundleRangeAsync(String topic) {
        TopicName topicName = TopicName.get(topic);
        String prefix = topicName.isV2() ? "/topic" : "/destination";
        WebTarget path = this.v2lookup.path(prefix).path(topicName.getLookupName()).path("bundle");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String bundleRange) {
                future.complete(bundleRange);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(LookupImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }
}

