/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;

public class LongSchema
extends AbstractSchema<Long> {
    private static final LongSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static LongSchema of() {
        return INSTANCE;
    }

    @Override
    public void validate(byte[] message) {
        if (message.length != 8) {
            throw new SchemaSerializationException("Size of data received by LongSchema is not 8");
        }
    }

    @Override
    public void validate(ByteBuf message) {
        if (message.readableBytes() != 8) {
            throw new SchemaSerializationException("Size of data received by LongSchema is not 8");
        }
    }

    @Override
    public byte[] encode(Long data) {
        if (null == data) {
            return null;
        }
        return new byte[]{(byte)(data >>> 56), (byte)(data >>> 48), (byte)(data >>> 40), (byte)(data >>> 32), (byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), data.byteValue()};
    }

    @Override
    public Long decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        long value = 0L;
        for (byte b : bytes) {
            value <<= 8;
            value |= (long)(b & 0xFF);
        }
        return value;
    }

    @Override
    public Long decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        this.validate(byteBuf);
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value <<= 8;
            value |= (long)(byteBuf.getByte(i) & 0xFF);
        }
        return value;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfoImpl().setName("INT64").setType(SchemaType.INT64).setSchema(new byte[0]);
        INSTANCE = new LongSchema();
    }
}

