/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.KubernetesFunctionAuthProvider;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.ApiException;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.apis.CoreV1Api;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1ObjectMeta;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1PodSpec;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1Secret;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1SecretVolumeSource;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1StatefulSet;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1Volume;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1VolumeMount;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.RandomStringUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.utils.Actions;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSecretsTokenAuthProvider
implements KubernetesFunctionAuthProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesSecretsTokenAuthProvider.class);
    private static final int NUM_RETRIES = 5;
    private static final long SLEEP_BETWEEN_RETRIES_MS = 500L;
    private static final String SECRET_NAME = "function-auth";
    private static final String DEFAULT_SECRET_MOUNT_DIR = "/etc/auth";
    private static final String FUNCTION_AUTH_TOKEN = "token";
    private static final String FUNCTION_CA_CERT = "ca.pem";
    private CoreV1Api coreClient;
    private byte[] caBytes;
    private Function<Function.FunctionDetails, String> getNamespaceFromDetails;

    @Override
    public void initialize(CoreV1Api coreClient) {
        this.coreClient = coreClient;
    }

    @Override
    public void setCaBytes(byte[] caBytes) {
        this.caBytes = caBytes;
    }

    @Override
    public void setNamespaceProviderFunc(Function<Function.FunctionDetails, String> getNamespaceFromDetails) {
        this.getNamespaceFromDetails = getNamespaceFromDetails;
    }

    private String getKubeNamespace(Function.FunctionDetails funcDetails) {
        return this.getNamespaceFromDetails.apply(funcDetails);
    }

    @Override
    public void configureAuthDataStatefulSet(V1StatefulSet statefulSet, Optional<FunctionAuthData> functionAuthData) {
        if (!functionAuthData.isPresent()) {
            return;
        }
        V1PodSpec podSpec = statefulSet.getSpec().getTemplate().getSpec();
        podSpec.setVolumes(Collections.singletonList(new V1Volume().name(SECRET_NAME).secret(new V1SecretVolumeSource().secretName(this.getSecretName(new String(functionAuthData.get().getData()))))));
        podSpec.getContainers().forEach(container -> container.setVolumeMounts(Collections.singletonList(new V1VolumeMount().name(SECRET_NAME).mountPath(DEFAULT_SECRET_MOUNT_DIR).readOnly(Boolean.valueOf(true)))));
    }

    @Override
    public void configureAuthenticationConfig(AuthenticationConfig authConfig, Optional<FunctionAuthData> functionAuthData) {
        if (!functionAuthData.isPresent()) {
            authConfig.setClientAuthenticationPlugin(null);
            authConfig.setClientAuthenticationParameters(null);
        } else {
            authConfig.setClientAuthenticationPlugin(AuthenticationToken.class.getName());
            authConfig.setClientAuthenticationParameters(String.format("file://%s/%s", DEFAULT_SECRET_MOUNT_DIR, FUNCTION_AUTH_TOKEN));
            if (this.caBytes != null) {
                authConfig.setTlsTrustCertsFilePath(String.format("%s/%s", DEFAULT_SECRET_MOUNT_DIR, FUNCTION_CA_CERT));
            }
        }
    }

    @Override
    public Optional<FunctionAuthData> cacheAuthData(Function.FunctionDetails funcDetails, AuthenticationDataSource authenticationDataSource) {
        String id = null;
        String tenant = funcDetails.getTenant();
        String namespace = funcDetails.getNamespace();
        String name = funcDetails.getName();
        try {
            String token = AuthenticationProviderToken.getToken(authenticationDataSource);
            if (token != null) {
                id = this.createSecret(token, funcDetails);
            }
        }
        catch (Exception e) {
            log.warn("Failed to get token for function {}", (Object)FunctionCommon.getFullyQualifiedName(tenant, namespace, name), (Object)e);
        }
        if (id != null) {
            return Optional.of(FunctionAuthData.builder().data(id.getBytes()).build());
        }
        return Optional.empty();
    }

    @Override
    public void cleanUpAuthData(Function.FunctionDetails funcDetails, Optional<FunctionAuthData> functionAuthData) throws Exception {
        if (!functionAuthData.isPresent()) {
            return;
        }
        String fqfn = FunctionCommon.getFullyQualifiedName(funcDetails.getTenant(), funcDetails.getNamespace(), funcDetails.getName());
        String secretId = new String(functionAuthData.get().getData());
        if (StringUtils.isBlank(secretId)) {
            log.warn("Secret name for function {} is empty.", (Object)fqfn);
            return;
        }
        String secretName = this.getSecretName(secretId);
        String kubeNamespace = this.getKubeNamespace(funcDetails);
        Actions.Action deleteSecrets = Actions.Action.builder().actionName(String.format("Deleting secrets for function %s", fqfn)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            try {
                this.coreClient.deleteNamespacedSecret(secretName, kubeNamespace, null, null, Integer.valueOf(0), null, "Foreground", null);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    log.warn("Secrets for function {} does not exist", (Object)fqfn);
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        Actions.Action waitForSecretsDeletion = Actions.Action.builder().actionName(String.format("Waiting for secrets for function %s to complete deletion", fqfn)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            try {
                this.coreClient.readNamespacedSecret(secretName, kubeNamespace, null, null, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return Actions.ActionResult.builder().success(true).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(false).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(deleteSecrets.toBuilder().continueOn(true).build()).addAction(waitForSecretsDeletion.toBuilder().continueOn(false).onSuccess(ignore -> success.set(true)).build()).addAction(deleteSecrets.toBuilder().continueOn(true).build()).addAction(waitForSecretsDeletion.toBuilder().onSuccess(ignore -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to delete secrets for function %s", fqfn));
        }
    }

    @Override
    public Optional<FunctionAuthData> updateAuthData(Function.FunctionDetails funcDetails, Optional<FunctionAuthData> existingFunctionAuthData, AuthenticationDataSource authenticationDataSource) throws Exception {
        String token;
        String secretId = existingFunctionAuthData.map(functionAuthData -> new String(functionAuthData.getData())).orElseGet(() -> RandomStringUtils.random(5, true, true).toLowerCase());
        try {
            token = AuthenticationProviderToken.getToken(authenticationDataSource);
        }
        catch (AuthenticationException e) {
            this.cleanUpAuthData(funcDetails, existingFunctionAuthData);
            return Optional.empty();
        }
        if (token != null) {
            this.upsertSecret(token, funcDetails, this.getSecretName(secretId));
            return Optional.of(FunctionAuthData.builder().data(secretId.getBytes()).build());
        }
        return existingFunctionAuthData;
    }

    @VisibleForTesting
    Map<String, byte[]> buildSecretMap(String token) {
        HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
        valueMap.put(FUNCTION_AUTH_TOKEN, token.getBytes());
        if (this.caBytes != null) {
            valueMap.put(FUNCTION_CA_CERT, this.caBytes);
        }
        return valueMap;
    }

    private void upsertSecret(String token, Function.FunctionDetails funcDetails, String secretName) throws InterruptedException {
        String tenant = funcDetails.getTenant();
        String namespace = funcDetails.getNamespace();
        String name = funcDetails.getName();
        String kubeNamespace = this.getKubeNamespace(funcDetails);
        Actions.Action createAuthSecret = Actions.Action.builder().actionName(String.format("Upsert authentication secret for function %s/%s/%s", tenant, namespace, name)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            String id = RandomStringUtils.random(5, true, true).toLowerCase();
            V1Secret v1Secret = new V1Secret().metadata(new V1ObjectMeta().name(secretName)).data(this.buildSecretMap(token));
            try {
                this.coreClient.createNamespacedSecret(kubeNamespace, v1Secret, null, null, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    try {
                        this.coreClient.replaceNamespacedSecret(secretName, kubeNamespace, v1Secret, null, null, null);
                        return Actions.ActionResult.builder().success(true).build();
                    }
                    catch (ApiException e1) {
                        String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                        return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
                    }
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(createAuthSecret.toBuilder().onSuccess(ignore -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to upsert authentication secret for function %s/%s/%s", tenant, namespace, name));
        }
    }

    private String createSecret(String token, Function.FunctionDetails funcDetails) throws ApiException, InterruptedException {
        String kubeNamespace = this.getKubeNamespace(funcDetails);
        String tenant = funcDetails.getTenant();
        String namespace = funcDetails.getNamespace();
        String name = funcDetails.getName();
        StringBuilder sb = new StringBuilder();
        Actions.Action createAuthSecret = Actions.Action.builder().actionName(String.format("Creating authentication secret for function %s/%s/%s", tenant, namespace, name)).numRetries(5).sleepBetweenInvocationsMs(500L).supplier(() -> {
            String id = RandomStringUtils.random(5, true, true).toLowerCase();
            V1Secret v1Secret = new V1Secret().metadata(new V1ObjectMeta().name(this.getSecretName(id))).data(this.buildSecretMap(token));
            try {
                this.coreClient.createNamespacedSecret(kubeNamespace, v1Secret, null, null, null);
            }
            catch (ApiException e) {
                if (e.getCode() == 409) {
                    return Actions.ActionResult.builder().errorMsg(String.format("Secret %s already present", id)).success(false).build();
                }
                String errorMsg = e.getResponseBody() != null ? e.getResponseBody() : e.getMessage();
                return Actions.ActionResult.builder().success(false).errorMsg(errorMsg).build();
            }
            sb.append(id.toCharArray());
            return Actions.ActionResult.builder().success(true).build();
        }).build();
        AtomicBoolean success = new AtomicBoolean(false);
        Actions.newBuilder().addAction(createAuthSecret.toBuilder().onSuccess(ignore -> success.set(true)).build()).run();
        if (!success.get()) {
            throw new RuntimeException(String.format("Failed to create authentication secret for function %s/%s/%s", tenant, namespace, name));
        }
        return sb.toString();
    }

    private String getSecretName(String id) {
        return "pf-secret-" + id;
    }
}

