/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.stats;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.util.RateLimiter;
import org.apache.pulsar.functions.instance.stats.ComponentStatsManager;
import org.apache.pulsar.functions.instance.stats.FunctionCollectorRegistry;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.EvictingQueue;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Counter;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Gauge;

public class SourceStatsManager
extends ComponentStatsManager {
    public static final String PULSAR_SOURCE_METRICS_PREFIX = "pulsar_source_";
    public static final String SYSTEM_EXCEPTIONS_TOTAL = "system_exceptions_total";
    public static final String SOURCE_EXCEPTIONS_TOTAL = "source_exceptions_total";
    public static final String LAST_INVOCATION = "last_invocation";
    public static final String RECEIVED_TOTAL = "received_total";
    public static final String WRITTEN_TOTAL = "written_total";
    public static final String SYSTEM_EXCEPTIONS_TOTAL_1min = "system_exceptions_total_1min";
    public static final String SOURCE_EXCEPTIONS_TOTAL_1min = "source_exceptions_total_1min";
    public static final String RECEIVED_TOTAL_1min = "received_total_1min";
    public static final String WRITTEN_TOTAL_1min = "written_total_1min";
    private final Counter statTotalRecordsReceived;
    private final Counter statTotalSysExceptions;
    private final Counter statTotalSourceExceptions;
    private final Counter statTotalWritten;
    private final Gauge statlastInvocation;
    private final Counter statTotalRecordsReceived1min;
    private final Counter statTotalSysExceptions1min;
    private final Counter statTotalSourceExceptions1min;
    private final Counter statTotalWritten1min;
    final Gauge sysExceptions;
    final Gauge sourceExceptions;
    private final Counter.Child _statTotalRecordsReceived;
    private final Counter.Child _statTotalSysExceptions;
    private final Counter.Child _statTotalSourceExceptions;
    private final Counter.Child _statTotalWritten;
    private final Gauge.Child _statlastInvocation;
    private Counter.Child _statTotalRecordsReceived1min;
    private Counter.Child _statTotalSysExceptions1min;
    private Counter.Child _statTotalSourceExceptions1min;
    private Counter.Child _statTotalWritten1min;
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSystemExceptions = EvictingQueue.create(10);
    private EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> latestSourceExceptions = EvictingQueue.create(10);
    protected final RateLimiter sysExceptionRateLimiter;
    protected final RateLimiter sourceExceptionRateLimiter;

    public SourceStatsManager(FunctionCollectorRegistry collectorRegistry, String[] metricsLabels, ScheduledExecutorService scheduledExecutorService) {
        super(collectorRegistry, metricsLabels, scheduledExecutorService);
        this.statTotalRecordsReceived = collectorRegistry.registerIfNotExist("pulsar_source_received_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_received_total")).help("Total number of records received from source.")).labelNames(metricsLabelNames)).create());
        this._statTotalRecordsReceived = (Counter.Child)this.statTotalRecordsReceived.labels(metricsLabels);
        this.statTotalSysExceptions = collectorRegistry.registerIfNotExist("pulsar_source_system_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_system_exceptions_total")).help("Total number of system exceptions.")).labelNames(metricsLabelNames)).create());
        this._statTotalSysExceptions = (Counter.Child)this.statTotalSysExceptions.labels(metricsLabels);
        this.statTotalSourceExceptions = collectorRegistry.registerIfNotExist("pulsar_source_source_exceptions_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_source_exceptions_total")).help("Total number of source exceptions.")).labelNames(metricsLabelNames)).create());
        this._statTotalSourceExceptions = (Counter.Child)this.statTotalSourceExceptions.labels(metricsLabels);
        this.statTotalWritten = collectorRegistry.registerIfNotExist("pulsar_source_written_total", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_written_total")).help("Total number of records written to a Pulsar topic.")).labelNames(metricsLabelNames)).create());
        this._statTotalWritten = (Counter.Child)this.statTotalWritten.labels(metricsLabels);
        this.statlastInvocation = collectorRegistry.registerIfNotExist("pulsar_source_last_invocation", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_last_invocation")).help("The timestamp of the last invocation of the source.")).labelNames(metricsLabelNames)).create());
        this._statlastInvocation = (Gauge.Child)this.statlastInvocation.labels(metricsLabels);
        this.statTotalRecordsReceived1min = collectorRegistry.registerIfNotExist("pulsar_source_received_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_received_total_1min")).help("Total number of records received from source in the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalRecordsReceived1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(metricsLabels);
        this.statTotalSysExceptions1min = collectorRegistry.registerIfNotExist("pulsar_source_system_exceptions_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_system_exceptions_total_1min")).help("Total number of system exceptions in the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalSysExceptions1min = (Counter.Child)this.statTotalSysExceptions1min.labels(metricsLabels);
        this.statTotalSourceExceptions1min = collectorRegistry.registerIfNotExist("pulsar_source_source_exceptions_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_source_exceptions_total_1min")).help("Total number of source exceptions in the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalSourceExceptions1min = (Counter.Child)this.statTotalSourceExceptions1min.labels(metricsLabels);
        this.statTotalWritten1min = collectorRegistry.registerIfNotExist("pulsar_source_written_total_1min", ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_source_written_total_1min")).help("Total number of records written to a Pulsar topic in the last 1 minute.")).labelNames(metricsLabelNames)).create());
        this._statTotalWritten1min = (Counter.Child)this.statTotalWritten1min.labels(metricsLabels);
        this.sysExceptions = collectorRegistry.registerIfNotExist("pulsar_source_system_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_system_exception")).labelNames(exceptionMetricsLabelNames)).help("Exception from system code.")).create());
        this.sourceExceptions = collectorRegistry.registerIfNotExist("pulsar_source_source_exception", ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_source_source_exception")).labelNames(exceptionMetricsLabelNames)).help("Exception from source.")).create());
        this.sysExceptionRateLimiter = new RateLimiter(scheduledExecutorService, 5L, 1L, TimeUnit.MINUTES);
        this.sourceExceptionRateLimiter = new RateLimiter(scheduledExecutorService, 5L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void reset() {
        this.statTotalRecordsReceived1min.clear();
        this._statTotalRecordsReceived1min = (Counter.Child)this.statTotalRecordsReceived1min.labels(this.metricsLabels);
        this.statTotalSysExceptions1min.clear();
        this._statTotalSysExceptions1min = (Counter.Child)this.statTotalSysExceptions1min.labels(this.metricsLabels);
        this.statTotalSourceExceptions1min.clear();
        this._statTotalSourceExceptions1min = (Counter.Child)this.statTotalSourceExceptions1min.labels(this.metricsLabels);
        this.statTotalWritten1min.clear();
        this._statTotalWritten1min = (Counter.Child)this.statTotalWritten1min.labels(this.metricsLabels);
    }

    @Override
    public void incrTotalReceived() {
        this._statTotalRecordsReceived.inc();
        this._statTotalRecordsReceived1min.inc();
    }

    @Override
    public void incrTotalProcessedSuccessfully() {
        this._statTotalWritten.inc();
        this._statTotalWritten1min.inc();
    }

    @Override
    public void incrSysExceptions(Throwable ex) {
        this._statTotalSysExceptions.inc();
        this._statTotalSysExceptions1min.inc();
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSystemExceptions.add(info);
        if (this.sysExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sysExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    @Override
    public void incrUserExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void incrSourceExceptions(Throwable ex) {
        this._statTotalSourceExceptions.inc();
        this._statTotalSourceExceptions1min.inc();
        long ts = System.currentTimeMillis();
        InstanceCommunication.FunctionStatus.ExceptionInformation info = this.getExceptionInfo(ex, ts);
        this.latestSourceExceptions.add(info);
        if (this.sourceExceptionRateLimiter.tryAcquire()) {
            String[] exceptionMetricsLabels = this.getExceptionMetricsLabels(ex);
            ((Gauge.Child)this.sourceExceptions.labels(exceptionMetricsLabels)).set(1.0);
        }
    }

    private String[] getExceptionMetricsLabels(Throwable ex) {
        String[] exceptionMetricsLabels = Arrays.copyOf(this.metricsLabels, this.metricsLabels.length + 1);
        exceptionMetricsLabels[exceptionMetricsLabels.length - 1] = ex.getMessage() != null ? ex.getMessage() : "";
        return exceptionMetricsLabels;
    }

    @Override
    public void incrSinkExceptions(Throwable ex) {
        this.incrSysExceptions(ex);
    }

    @Override
    public void setLastInvocation(long ts) {
        this._statlastInvocation.set(ts);
    }

    @Override
    public void processTimeStart() {
    }

    @Override
    public void processTimeEnd() {
    }

    @Override
    public double getTotalProcessedSuccessfully() {
        return this._statTotalWritten.get();
    }

    @Override
    public double getTotalRecordsReceived() {
        return this._statTotalRecordsReceived.get();
    }

    @Override
    public double getTotalSysExceptions() {
        return this._statTotalSysExceptions.get();
    }

    @Override
    public double getTotalUserExceptions() {
        return 0.0;
    }

    @Override
    public double getLastInvocation() {
        return this._statlastInvocation.get();
    }

    @Override
    public double getAvgProcessLatency() {
        return 0.0;
    }

    @Override
    public double getTotalProcessedSuccessfully1min() {
        return this._statTotalWritten1min.get();
    }

    @Override
    public double getTotalRecordsReceived1min() {
        return this._statTotalRecordsReceived1min.get();
    }

    @Override
    public double getTotalSysExceptions1min() {
        return this._statTotalSysExceptions1min.get();
    }

    @Override
    public double getTotalUserExceptions1min() {
        return 0.0;
    }

    @Override
    public double getAvgProcessLatency1min() {
        return 0.0;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestUserExceptions() {
        return EvictingQueue.create(0);
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSystemExceptions() {
        return this.latestSystemExceptions;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSourceExceptions() {
        return this.latestSourceExceptions;
    }

    @Override
    public EvictingQueue<InstanceCommunication.FunctionStatus.ExceptionInformation> getLatestSinkExceptions() {
        return EvictingQueue.create(0);
    }
}

