/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.cache.caffeine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.functions.runtime.shaded.com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import org.apache.pulsar.functions.runtime.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.pulsar.functions.runtime.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.pulsar.functions.runtime.shaded.com.github.benmanes.caffeine.cache.stats.CacheStats;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Collector;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.CounterMetricFamily;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.GaugeMetricFamily;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.SummaryMetricFamily;

public class CacheMetricsCollector
extends Collector {
    protected final ConcurrentMap<String, Cache> children = new ConcurrentHashMap<String, Cache>();

    public void addCache(String cacheName, Cache cache) {
        this.children.put(cacheName, cache);
    }

    public void addCache(String cacheName, AsyncLoadingCache cache) {
        this.children.put(cacheName, (Cache)cache.synchronous());
    }

    public Cache removeCache(String cacheName) {
        return (Cache)this.children.remove(cacheName);
    }

    public void clear() {
        this.children.clear();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        List<String> labelNames = Arrays.asList("cache");
        CounterMetricFamily cacheHitTotal = new CounterMetricFamily("caffeine_cache_hit_total", "Cache hit totals", labelNames);
        mfs.add(cacheHitTotal);
        CounterMetricFamily cacheMissTotal = new CounterMetricFamily("caffeine_cache_miss_total", "Cache miss totals", labelNames);
        mfs.add(cacheMissTotal);
        CounterMetricFamily cacheRequestsTotal = new CounterMetricFamily("caffeine_cache_requests_total", "Cache request totals, hits + misses", labelNames);
        mfs.add(cacheRequestsTotal);
        CounterMetricFamily cacheEvictionTotal = new CounterMetricFamily("caffeine_cache_eviction_total", "Cache eviction totals, doesn't include manually removed entries", labelNames);
        mfs.add(cacheEvictionTotal);
        GaugeMetricFamily cacheEvictionWeight = new GaugeMetricFamily("caffeine_cache_eviction_weight", "Cache eviction weight", labelNames);
        mfs.add(cacheEvictionWeight);
        CounterMetricFamily cacheLoadFailure = new CounterMetricFamily("caffeine_cache_load_failure_total", "Cache load failures", labelNames);
        mfs.add(cacheLoadFailure);
        CounterMetricFamily cacheLoadTotal = new CounterMetricFamily("caffeine_cache_loads_total", "Cache loads: both success and failures", labelNames);
        mfs.add(cacheLoadTotal);
        GaugeMetricFamily cacheSize = new GaugeMetricFamily("caffeine_cache_estimated_size", "Estimated cache size", labelNames);
        mfs.add(cacheSize);
        SummaryMetricFamily cacheLoadSummary = new SummaryMetricFamily("caffeine_cache_load_duration_seconds", "Cache load duration: both success and failures", labelNames);
        mfs.add(cacheLoadSummary);
        for (Map.Entry c : this.children.entrySet()) {
            List<String> cacheName = Arrays.asList((String)c.getKey());
            CacheStats stats = ((Cache)c.getValue()).stats();
            try {
                cacheEvictionWeight.addMetric(cacheName, stats.evictionWeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
            cacheHitTotal.addMetric(cacheName, stats.hitCount());
            cacheMissTotal.addMetric(cacheName, stats.missCount());
            cacheRequestsTotal.addMetric(cacheName, stats.requestCount());
            cacheEvictionTotal.addMetric(cacheName, stats.evictionCount());
            cacheSize.addMetric(cacheName, ((Cache)c.getValue()).estimatedSize());
            if (!(c.getValue() instanceof LoadingCache)) continue;
            cacheLoadFailure.addMetric(cacheName, stats.loadFailureCount());
            cacheLoadTotal.addMetric(cacheName, stats.loadCount());
            cacheLoadSummary.addMetric(cacheName, stats.loadCount(), (double)stats.totalLoadTime() / 1.0E9);
        }
        return mfs;
    }
}

