/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.op;

import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.RangeOption;

class RangeOpImpl<K, V>
implements RangeOp<K, V> {
    private final Recycler.Handle<RangeOpImpl<K, V>> handle;
    private K key;
    private RangeOption<K> option;

    @Override
    public OpType type() {
        return OpType.RANGE;
    }

    RangeOpImpl<K, V> key(K key) {
        ReferenceCountUtil.release(this.key);
        this.key = ReferenceCountUtil.retain(key);
        return this;
    }

    @Override
    public void close() {
        ReferenceCountUtil.release(this.key);
        this.key = null;
        if (null != this.option) {
            this.option.close();
            this.option = null;
        }
        this.handle.recycle(this);
    }

    public Recycler.Handle<RangeOpImpl<K, V>> handle() {
        return this.handle;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public RangeOption<K> option() {
        return this.option;
    }

    RangeOpImpl<K, V> option(RangeOption<K> option) {
        this.option = option;
        return this;
    }

    RangeOpImpl(Recycler.Handle<RangeOpImpl<K, V>> handle) {
        this.handle = handle;
    }

    public String toString() {
        return "RangeOpImpl(key=" + this.key() + ", option=" + this.option() + ")";
    }
}

