/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.coder;

import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.coder.Coder;

public class ByteArrayCoder
implements Coder<byte[]> {
    private static final ByteArrayCoder INSTANCE = new ByteArrayCoder();

    public static ByteArrayCoder of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(byte[] value) {
        return value;
    }

    @Override
    public void encode(byte[] value, ByteBuf destBuf) {
        destBuf.writeBytes(value);
    }

    @Override
    public int getSerializedSize(byte[] value) {
        return value.length;
    }

    @Override
    public byte[] decode(ByteBuf data) {
        return ByteBufUtil.getBytes(data);
    }

    private ByteArrayCoder() {
    }
}

