/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VarInt {
    private static long convertIntToLongNoSignExtend(int v) {
        return (long)v & 0xFFFFFFFFL;
    }

    public static void encode(int v, OutputStream buf) throws IOException {
        VarInt.encode(VarInt.convertIntToLongNoSignExtend(v), buf);
    }

    public static void encode(long v, OutputStream buf) throws IOException {
        do {
            long bits = v & 0x7FL;
            int b = (int)(bits | (long)((v >>>= 7) != 0L ? 128 : 0));
            buf.write(b);
        } while (v != 0L);
    }

    public static int decodeInt(InputStream buf) throws IOException {
        long r = VarInt.decodeLong(buf);
        if (r < 0L || r >= 0x100000000L) {
            throw new IOException("var int overflow " + r);
        }
        return (int)r;
    }

    public static long decodeLong(InputStream buf) throws IOException {
        int b;
        long result = 0L;
        int shift = 0;
        do {
            if ((b = buf.read()) < 0) {
                if (shift == 0) {
                    throw new EOFException();
                }
                throw new IOException("varint not terminated");
            }
            long bits = b & 0x7F;
            if (shift >= 64 || shift == 63 && bits > 1L) {
                throw new IOException("varint too long");
            }
            result |= bits << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return result;
    }

    public static int getLength(int v) {
        return VarInt.getLength(VarInt.convertIntToLongNoSignExtend(v));
    }

    public static int getLength(long v) {
        int result = 0;
        do {
            ++result;
        } while ((v >>>= 7) != 0L);
        return result;
    }
}

