/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.nio.channels.ClosedChannelException;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.group.ChannelGroup;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.processor.RequestProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BookieRequestHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(BookieRequestHandler.class);
    private final RequestProcessor requestProcessor;
    private final ChannelGroup allChannels;

    BookieRequestHandler(ServerConfiguration conf, RequestProcessor processor, ChannelGroup allChannels) {
        this.requestProcessor = processor;
        this.allChannels = allChannels;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("Channel connected  {}", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.allChannels.add(ctx.channel());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("Channels disconnected: {}", (Object)ctx.channel());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ClosedChannelException) {
            LOG.info("Client died before request could be completed on {}", (Object)ctx.channel(), (Object)cause);
            return;
        }
        LOG.error("Unhandled exception occurred in I/O thread or handler on {}", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof BookkeeperProtocol.Request) && !(msg instanceof BookieProtocol.Request)) {
            ctx.fireChannelRead(msg);
            return;
        }
        this.requestProcessor.processRequest(msg, ctx.channel());
    }
}

