/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc;

import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.IncrementOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Code;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.exceptions.MVCCStoreException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.journal.CommandProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.MVCCStoreImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.MVCCUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoDeleteOpImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoIncrementOpImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoPutOpImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoTxnOpImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.store.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MVCCCommandProcessor
implements CommandProcessor<MVCCStoreImpl<byte[], byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(MVCCCommandProcessor.class);

    public static MVCCCommandProcessor of() {
        return new MVCCCommandProcessor();
    }

    private void applyPutCommand(long revision, Command command, MVCCStoreImpl<byte[], byte[]> store) {
        try (ProtoPutOpImpl op = ProtoPutOpImpl.newPutOp(command);){
            this.applyPutOp(revision, op, true, store);
        }
    }

    private void applyPutOp(long revision, PutOp<byte[], byte[]> op, boolean ignoreSmallerRevision, MVCCStoreImpl<byte[], byte[]> localStore) {
        Throwable throwable = null;
        try (PutResult<byte[], byte[]> result = localStore.put(revision, op);){
            if (Code.OK == result.code() || ignoreSmallerRevision && Code.SMALLER_REVISION == result.code()) {
                return;
            }
            try {
                throw new MVCCStoreException(result.code(), "Failed to apply command " + op + " at revision " + revision + " to the state store " + localStore.name());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void applyDeleteCommand(long revision, Command command, MVCCStoreImpl<byte[], byte[]> store) {
        try (ProtoDeleteOpImpl op = ProtoDeleteOpImpl.newDeleteOp(command.getDeleteReq());){
            this.applyDeleteOp(revision, op, true, store);
        }
    }

    private void applyDeleteOp(long revision, DeleteOp<byte[], byte[]> op, boolean ignoreSmallerRevision, MVCCStoreImpl<byte[], byte[]> localStore) {
        Throwable throwable = null;
        try (DeleteResult<byte[], byte[]> result = localStore.delete(revision, op);){
            if (Code.OK == result.code() || ignoreSmallerRevision && Code.SMALLER_REVISION == result.code()) {
                return;
            }
            try {
                throw new MVCCStoreException(result.code(), "Failed to apply command " + op + " at revision " + revision + " to the state store " + localStore.name());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void applyTxnCommand(long revision, Command command, MVCCStoreImpl<byte[], byte[]> store) {
        try (ProtoTxnOpImpl op = ProtoTxnOpImpl.newTxnOp(command.getTxnReq());){
            this.applyTxnOp(revision, op, true, store);
        }
    }

    private void applyTxnOp(long revision, TxnOp<byte[], byte[]> op, boolean ignoreSmallerRevision, MVCCStoreImpl<byte[], byte[]> localStore) {
        Throwable throwable = null;
        try (TxnResult<byte[], byte[]> result = localStore.processTxn(revision, op);){
            if (log.isDebugEnabled()) {
                log.debug("Result after applying transaction {} : {} - success = {}", new Object[]{revision, result.code(), result.isSuccess()});
            }
            if (Code.OK == result.code() || ignoreSmallerRevision && Code.SMALLER_REVISION == result.code()) {
                return;
            }
            try {
                throw new MVCCStoreException(result.code(), "Failed to apply command " + op + " at revision " + revision + " to the state store " + localStore.name());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void applyIncrCommand(long revision, Command command, MVCCStoreImpl<byte[], byte[]> store) {
        try (ProtoIncrementOpImpl op = ProtoIncrementOpImpl.newIncrementOp(command);){
            this.applyIncrOp(revision, op, true, store);
        }
    }

    private void applyIncrOp(long revision, IncrementOp<byte[], byte[]> op, boolean ignoreSmallerRevision, MVCCStoreImpl<byte[], byte[]> localStore) {
        Throwable throwable = null;
        try (IncrementResult<byte[], byte[]> result = localStore.increment(revision, op);){
            if (Code.OK == result.code() || ignoreSmallerRevision && Code.SMALLER_REVISION == result.code()) {
                return;
            }
            try {
                throw new MVCCStoreException(result.code(), "Failed to apply command " + op + " at revision " + revision + " to the state store " + localStore.name());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public void applyCommand(long txid, ByteBuf cmdBuf, MVCCStoreImpl<byte[], byte[]> store) {
        Command command = MVCCUtils.newCommand(cmdBuf);
        switch (command.getReqCase()) {
            case NOP_REQ: {
                return;
            }
            case PUT_REQ: {
                this.applyPutCommand(txid, command, store);
                return;
            }
            case DELETE_REQ: {
                this.applyDeleteCommand(txid, command, store);
                return;
            }
            case TXN_REQ: {
                this.applyTxnCommand(txid, command, store);
                return;
            }
            case INCR_REQ: {
                this.applyIncrCommand(txid, command, store);
                return;
            }
        }
    }

    private MVCCCommandProcessor() {
    }
}

