/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.io.MoreFiles;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.io.RecursiveDeleteOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.exceptions.StateStoreException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.RocksdbRestoreTask;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.store.CheckpointMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointInfo
implements Comparable<CheckpointInfo> {
    private static final Logger log = LoggerFactory.getLogger(CheckpointInfo.class);
    final String id;
    CheckpointMetadata metadata;

    public CheckpointInfo(String id, InputStream is) throws IOException {
        this.id = id;
        this.metadata = CheckpointMetadata.parseFrom(is);
    }

    public CheckpointInfo(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public CheckpointMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Checkpoint{ID='" + this.id + "', createdAt: " + this.getCreatedAt() + " " + this.metadata + "}";
    }

    public static CheckpointInfo nullCheckpoint() {
        return new CheckpointInfo(UUID.randomUUID().toString()){

            @Override
            public CheckpointMetadata restore(String dbName, File dbPath, CheckpointStore store) throws StateStoreException {
                try {
                    Files.createDirectories(this.getCheckpointPath(dbPath), new FileAttribute[0]);
                    this.updateCurrent(dbPath);
                }
                catch (IOException ioe) {
                    throw new StateStoreException("Failed to create dir " + dbName, ioe);
                }
                return null;
            }

            @Override
            public Long getCreatedAt() {
                return 0L;
            }
        };
    }

    public void remove(File dbPath) {
        try {
            Path checkpointPath = this.getCheckpointPath(dbPath);
            if (checkpointPath.toFile().exists()) {
                MoreFiles.deleteRecursively(checkpointPath, RecursiveDeleteOption.ALLOW_INSECURE);
            }
        }
        catch (IOException ioe) {
            log.warn("Failed to remove unused checkpoint {} from {}", new Object[]{this.id, this.getCheckpointBaseDir(dbPath), ioe});
        }
    }

    public Long getCreatedAt() {
        return this.metadata.getCreatedAt();
    }

    public File getCheckpointBaseDir(File dbPath) {
        return new File(dbPath, "checkpoints");
    }

    public Path getCheckpointPath(File dbPath) {
        return Paths.get(this.getCheckpointBaseDir(dbPath).getAbsolutePath(), this.id);
    }

    public File getCurrentDir(File dbPath) {
        return new File(dbPath, "current");
    }

    public Path getCurrentPath(File dbPath) {
        return Paths.get(this.getCurrentDir(dbPath).getAbsolutePath(), new String[0]);
    }

    public void updateCurrent(File dbPath) throws IOException {
        Path currentPath = this.getCurrentPath(dbPath);
        Files.deleteIfExists(currentPath);
        Files.createSymbolicLink(currentPath, this.getCheckpointPath(dbPath), new FileAttribute[0]);
    }

    @Override
    public int compareTo(CheckpointInfo o) {
        return this.getCreatedAt().compareTo(o.getCreatedAt());
    }

    public CheckpointMetadata restore(File dbPath, RocksdbRestoreTask task) throws StateStoreException, IOException {
        task.restore(this.id, this.metadata);
        this.updateCurrent(dbPath);
        log.info("Successfully restore checkpoint {} to {}", (Object)this.id, (Object)this.getCheckpointPath(dbPath));
        return this.metadata;
    }

    public CheckpointMetadata restore(String dbName, File dbPath, CheckpointStore store) throws StateStoreException {
        try {
            File checkpointsDir = new File(dbPath, "checkpoints");
            RocksdbRestoreTask task = new RocksdbRestoreTask(dbName, checkpointsDir, store);
            return this.restore(dbPath, task);
        }
        catch (IOException ioe) {
            log.error("Failed to restore rocksdb {}", (Object)dbName, (Object)ioe);
            throw new StateStoreException("Failed to restore rocksdb " + dbName, ioe);
        }
    }
}

