/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.server.grpc;

import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.HandlerRegistry;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.server.conf.StorageServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.api.StorageContainerStore;

public class GrpcServerSpec {
    Supplier<StorageContainerStore> storeSupplier;
    StorageServerConfiguration storeServerConf;
    Endpoint endpoint;
    StatsLogger statsLogger;
    String localServerName;
    HandlerRegistry localHandlerRegistry;

    GrpcServerSpec(Supplier<StorageContainerStore> storeSupplier, StorageServerConfiguration storeServerConf, Endpoint endpoint, StatsLogger statsLogger, String localServerName, HandlerRegistry localHandlerRegistry) {
        this.storeSupplier = storeSupplier;
        this.storeServerConf = storeServerConf;
        this.endpoint = endpoint;
        this.statsLogger = statsLogger;
        this.localServerName = localServerName;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public static GrpcServerSpecBuilder builder() {
        return new GrpcServerSpecBuilder();
    }

    public GrpcServerSpec storeSupplier(Supplier<StorageContainerStore> storeSupplier) {
        this.storeSupplier = storeSupplier;
        return this;
    }

    public GrpcServerSpec storeServerConf(StorageServerConfiguration storeServerConf) {
        this.storeServerConf = storeServerConf;
        return this;
    }

    public GrpcServerSpec endpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GrpcServerSpec statsLogger(StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
        return this;
    }

    public GrpcServerSpec localServerName(String localServerName) {
        this.localServerName = localServerName;
        return this;
    }

    public GrpcServerSpec localHandlerRegistry(HandlerRegistry localHandlerRegistry) {
        this.localHandlerRegistry = localHandlerRegistry;
        return this;
    }

    public Supplier<StorageContainerStore> storeSupplier() {
        return this.storeSupplier;
    }

    public StorageServerConfiguration storeServerConf() {
        return this.storeServerConf;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public StatsLogger statsLogger() {
        return this.statsLogger;
    }

    public String localServerName() {
        return this.localServerName;
    }

    public HandlerRegistry localHandlerRegistry() {
        return this.localHandlerRegistry;
    }

    public static class GrpcServerSpecBuilder {
        private Supplier<StorageContainerStore> storeSupplier;
        private StorageServerConfiguration storeServerConf;
        private Endpoint endpoint;
        private StatsLogger statsLogger;
        private String localServerName;
        private HandlerRegistry localHandlerRegistry;

        GrpcServerSpecBuilder() {
        }

        public GrpcServerSpecBuilder storeSupplier(Supplier<StorageContainerStore> storeSupplier) {
            this.storeSupplier = storeSupplier;
            return this;
        }

        public GrpcServerSpecBuilder storeServerConf(StorageServerConfiguration storeServerConf) {
            this.storeServerConf = storeServerConf;
            return this;
        }

        public GrpcServerSpecBuilder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public GrpcServerSpecBuilder statsLogger(StatsLogger statsLogger) {
            this.statsLogger = statsLogger;
            return this;
        }

        public GrpcServerSpecBuilder localServerName(String localServerName) {
            this.localServerName = localServerName;
            return this;
        }

        public GrpcServerSpecBuilder localHandlerRegistry(HandlerRegistry localHandlerRegistry) {
            this.localHandlerRegistry = localHandlerRegistry;
            return this;
        }

        public GrpcServerSpec build() {
            return new GrpcServerSpec(this.storeSupplier, this.storeServerConf, this.endpoint, this.statsLogger, this.localServerName, this.localHandlerRegistry);
        }

        public String toString() {
            return "GrpcServerSpec.GrpcServerSpecBuilder(storeSupplier=" + this.storeSupplier + ", storeServerConf=" + this.storeServerConf + ", endpoint=" + this.endpoint + ", statsLogger=" + this.statsLogger + ", localServerName=" + this.localServerName + ", localHandlerRegistry=" + this.localHandlerRegistry + ")";
        }
    }
}

