/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.StatusCode;

public abstract class AsyncOperationProcessor<ReqT, RespT, StateT> {
    public CompletableFuture<RespT> process(StateT state, ReqT request, ScheduledExecutorService executor) {
        CompletableFuture future = FutureUtils.createFuture();
        executor.submit(() -> this.processRequest(future, state, request));
        return future;
    }

    protected abstract StatusCode verifyRequest(StateT var1, ReqT var2);

    protected abstract RespT failRequest(StatusCode var1);

    protected abstract CompletableFuture<RespT> doProcessRequest(StateT var1, ReqT var2);

    protected void processRequest(CompletableFuture<RespT> future, StateT state, ReqT request) {
        try {
            StatusCode code = this.verifyRequest(state, request);
            if (StatusCode.SUCCESS != code) {
                future.complete(this.failRequest(code));
            } else {
                this.doProcessRequest(state, request).whenComplete((value, causeB) -> {
                    if (null == causeB) {
                        future.complete(value);
                    } else {
                        future.completeExceptionally((Throwable)causeB);
                    }
                });
            }
        }
        catch (Throwable cause) {
            future.completeExceptionally(cause);
        }
    }
}

