/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.grpc;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.stub.StreamObserver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.GetActiveRangesRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.GetActiveRangesResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.MetaRangeServiceGrpc;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.api.metadata.RangeStoreService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.grpc.handler.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMetaRangeService
extends MetaRangeServiceGrpc.MetaRangeServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcMetaRangeService.class);
    private final RangeStoreService rangeStore;

    public GrpcMetaRangeService(RangeStoreService service) {
        this.rangeStore = service;
        log.info("Created MetaRange service");
    }

    @Override
    public void getActiveRanges(GetActiveRangesRequest request, StreamObserver<GetActiveRangesResponse> responseObserver) {
        this.rangeStore.getActiveRanges(request).whenComplete(new ResponseHandler<GetActiveRangesResponse>(responseObserver){

            @Override
            protected GetActiveRangesResponse createErrorResp(Throwable cause) {
                return GetActiveRangesResponse.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).build();
            }
        });
    }
}

