/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.kv;

import java.util.concurrent.ExecutionException;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.ByteString;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Code;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Result;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.exceptions.MVCCStoreException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.Compare;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.ResponseHeader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.ResponseOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(TableStoreUtils.class);
    static final byte SEP = 0;
    static final byte NO_ROUTING_KEY = 0;
    static final byte HAS_ROUTING_KEY = 1;

    static boolean hasRKey(ByteString rKey) {
        return null != rKey && rKey.size() > 0;
    }

    static byte[] newStoreKey(ByteString rKey, ByteString lKey) {
        boolean hasRkey = TableStoreUtils.hasRKey(rKey);
        int keyLen = hasRkey ? rKey.size() + lKey.size() + 2 : lKey.size() + 1;
        ByteBuf keyBuf = Unpooled.buffer(keyLen);
        if (hasRkey) {
            keyBuf.writeByte(1);
            keyBuf.writeBytes(rKey.asReadOnlyByteBuffer());
            keyBuf.writeByte(0);
            keyBuf.writeBytes(lKey.asReadOnlyByteBuffer());
        } else {
            keyBuf.writeByte(0);
            keyBuf.writeBytes(lKey.asReadOnlyByteBuffer());
        }
        return ByteBufUtil.getBytes(keyBuf);
    }

    static ByteString getLKey(byte[] storeKey, ByteString rKey) {
        boolean hasRKey = TableStoreUtils.hasRKey(rKey);
        int lKeyOffset = hasRKey ? rKey.size() + 2 : 1;
        return UnsafeByteOperations.unsafeWrap(storeKey, lKeyOffset, storeKey.length - lKeyOffset);
    }

    static StatusCode handleCause(Throwable cause) {
        if (cause instanceof ExecutionException) {
            return TableStoreUtils.handleCause(cause.getCause());
        }
        if (cause instanceof MVCCStoreException) {
            MVCCStoreException mse = (MVCCStoreException)cause;
            return TableStoreUtils.mvccCodeToStatusCode(mse.getCode());
        }
        return StatusCode.INTERNAL_SERVER_ERROR;
    }

    static StatusCode mvccCodeToStatusCode(Code code) {
        switch (code) {
            case OK: {
                return StatusCode.SUCCESS;
            }
            case INTERNAL_ERROR: {
                return StatusCode.INTERNAL_SERVER_ERROR;
            }
            case INVALID_ARGUMENT: {
                return StatusCode.BAD_REQUEST;
            }
            case ILLEGAL_OP: {
                return StatusCode.BAD_REQUEST;
            }
            case UNEXPECTED: {
                return StatusCode.UNEXPECTED;
            }
            case BAD_REVISION: {
                return StatusCode.BAD_REVISION;
            }
            case SMALLER_REVISION: {
                return StatusCode.BAD_REVISION;
            }
            case KEY_NOT_FOUND: {
                return StatusCode.KEY_NOT_FOUND;
            }
            case KEY_EXISTS: {
                return StatusCode.KEY_EXISTS;
            }
        }
        return StatusCode.INTERNAL_SERVER_ERROR;
    }

    static org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.KeyValue newKeyValue(ByteString rKey, KeyValue<byte[], byte[]> kv) {
        if (null == kv) {
            return null;
        }
        return org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.KeyValue.newBuilder().setKey(TableStoreUtils.getLKey(kv.key(), rKey)).setValue(UnsafeByteOperations.unsafeWrap(kv.value())).setCreateRevision(kv.createRevision()).setModRevision(kv.modifiedRevision()).setVersion(kv.version()).setIsNumber(kv.isNumber()).setNumberValue(kv.numberValue()).build();
    }

    static PutResponse processPutResult(RoutingHeader routingHeader, PutResult<byte[], byte[]> result) {
        ByteString rKey = routingHeader.getRKey();
        PutResponse.Builder putRespBuilder = PutResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build());
        if (null != result.prevKv()) {
            putRespBuilder = putRespBuilder.setPrevKv(TableStoreUtils.newKeyValue(rKey, result.prevKv()));
        }
        return putRespBuilder.build();
    }

    static IncrementResponse processIncrementResult(RoutingHeader routingHeader, IncrementResult<byte[], byte[]> result) {
        IncrementResponse.Builder putRespBuilder = IncrementResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build()).setTotalAmount(result.totalAmount());
        return putRespBuilder.build();
    }

    static RangeResponse processRangeResult(RoutingHeader routingHeader, RangeResult<byte[], byte[]> result) {
        ByteString rKey = routingHeader.getRKey();
        return RangeResponse.newBuilder().setCount(result.count()).setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build()).addAllKvs(Lists.transform(result.kvs(), kv -> TableStoreUtils.newKeyValue(rKey, kv))).setMore(result.more()).build();
    }

    static DeleteRangeResponse processDeleteResult(RoutingHeader routingHeader, DeleteResult<byte[], byte[]> result) {
        ByteString rKey = routingHeader.getRKey();
        return DeleteRangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build()).setDeleted(result.numDeleted()).addAllPrevKvs(Lists.transform(result.prevKvs(), kv -> TableStoreUtils.newKeyValue(rKey, kv))).build();
    }

    static TxnResponse processTxnResult(RoutingHeader routingHeader, TxnResult<byte[], byte[]> txnResult) {
        return TxnResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(txnResult.code())).setRoutingHeader(routingHeader).build()).setSucceeded(txnResult.isSuccess()).addAllResponses(Lists.transform(txnResult.results(), result -> TableStoreUtils.processTxnResult(routingHeader, result))).build();
    }

    static ResponseOp processTxnResult(RoutingHeader routingHeader, Result<byte[], byte[]> result) {
        ResponseOp.Builder respBuilder = ResponseOp.newBuilder();
        switch (result.type()) {
            case PUT: {
                PutResult putResult = (PutResult)result;
                respBuilder.setResponsePut(TableStoreUtils.processPutResult(routingHeader, putResult));
                break;
            }
            case DELETE: {
                DeleteResult delResult = (DeleteResult)result;
                respBuilder.setResponseDeleteRange(TableStoreUtils.processDeleteResult(routingHeader, delResult));
                break;
            }
            case RANGE: {
                RangeResult rangeResult = (RangeResult)result;
                respBuilder.setResponseRange(TableStoreUtils.processRangeResult(routingHeader, rangeResult));
                break;
            }
        }
        return respBuilder.build();
    }

    static CompareOp<byte[], byte[]> fromProtoCompare(OpFactory<byte[], byte[]> opFactory, RoutingHeader header, Compare compare) {
        ByteString rKey = header.getRKey();
        ByteString lKey = compare.getKey();
        byte[] storeKey = TableStoreUtils.newStoreKey(rKey, lKey);
        CompareResult result = TableStoreUtils.fromProtoCompareResult(compare.getResult());
        switch (compare.getTarget()) {
            case MOD: {
                return opFactory.compareModRevision(result, storeKey, compare.getModRevision());
            }
            case CREATE: {
                return opFactory.compareCreateRevision(result, storeKey, compare.getCreateRevision());
            }
            case VERSION: {
                return opFactory.compareVersion(result, storeKey, compare.getVersion());
            }
            case VALUE: {
                return opFactory.compareValue(result, storeKey, null == compare.getValue() || compare.getValue().size() == 0 ? null : compare.getValue().toByteArray());
            }
        }
        throw new IllegalArgumentException("Invalid compare target " + compare.getTarget());
    }

    static CompareResult fromProtoCompareResult(Compare.CompareResult result) {
        switch (result) {
            case LESS: {
                return CompareResult.LESS;
            }
            case EQUAL: {
                return CompareResult.EQUAL;
            }
            case GREATER: {
                return CompareResult.GREATER;
            }
            case NOT_EQUAL: {
                return CompareResult.NOT_EQUAL;
            }
        }
        throw new IllegalArgumentException("Invalid compare result " + result);
    }

    private TableStoreUtils() {
    }
}

