/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.routing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.MessageLite;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.Parser;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.CallOptions;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Channel;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ClientCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ClientInterceptor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ForwardingClientCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Metadata;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.MethodDescriptor;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TableServiceGrpc;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingHeaderProxyInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RoutingHeaderProxyInterceptor.class);
    private static final TableRequestMutator<PutRequest> PUT_INTERCEPTOR = (request, sid, rid, rk) -> PutRequest.newBuilder(request).setHeader(RoutingHeaderProxyInterceptor.newRoutingHeaderBuilder(request.getHeader(), sid, rid, rk)).build();
    private static final TableRequestMutator<RangeRequest> RANGE_INTERCEPTOR = (request, sid, rid, rk) -> RangeRequest.newBuilder(request).setHeader(RoutingHeaderProxyInterceptor.newRoutingHeaderBuilder(request.getHeader(), sid, rid, rk)).build();
    private static final TableRequestMutator<DeleteRangeRequest> DELETE_INTERCEPTOR = (request, sid, rid, rk) -> DeleteRangeRequest.newBuilder(request).setHeader(RoutingHeaderProxyInterceptor.newRoutingHeaderBuilder(request.getHeader(), sid, rid, rk)).build();
    private static final TableRequestMutator<IncrementRequest> INCR_INTERCEPTOR = (request, sid, rid, rk) -> IncrementRequest.newBuilder(request).setHeader(RoutingHeaderProxyInterceptor.newRoutingHeaderBuilder(request.getHeader(), sid, rid, rk)).build();
    private static final TableRequestMutator<TxnRequest> TXN_INTERCEPTOR = (request, sid, rid, rk) -> TxnRequest.newBuilder(request).setHeader(RoutingHeaderProxyInterceptor.newRoutingHeaderBuilder(request.getHeader(), sid, rid, rk)).build();
    private static Map<String, InterceptorDescriptor<?>> kvRpcMethods = new HashMap();

    private static RoutingHeader.Builder newRoutingHeaderBuilder(RoutingHeader header, Long sid, Long rid, byte[] rk) {
        return RoutingHeader.newBuilder(header).setStreamId(sid).setRangeId(rid).setRKey(UnsafeByteOperations.unsafeWrap(rk));
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (log.isTraceEnabled()) {
            log.trace("Intercepting method {} : req marshaller = {}, resp marshaller = {}", new Object[]{method.getFullMethodName(), method.getRequestMarshaller(), method.getResponseMarshaller()});
        }
        final InterceptorDescriptor<?> descriptor = kvRpcMethods.get(method.getFullMethodName());
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            private Long rid;
            private Long sid;
            private byte[] rk;
            {
                super(x0);
                this.rid = null;
                this.sid = null;
                this.rk = null;
            }

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                this.sid = (Long)headers.get(ProtocolConstants.SID_METADATA_KEY);
                this.rid = (Long)headers.get(ProtocolConstants.RID_METADATA_KEY);
                this.rk = (byte[])headers.get(ProtocolConstants.RK_METADATA_KEY);
                if (log.isTraceEnabled()) {
                    log.trace("Intercepting request with header : sid = {}, rid = {}, rk = {}", new Object[]{this.sid, this.rid, this.rk});
                }
                this.delegate().start(responseListener, headers);
            }

            public void sendMessage(ReqT message) {
                Object interceptedMessage = null == this.rid || null == this.sid || null == this.rk || null == descriptor ? RoutingHeaderProxyInterceptor.this.interceptMessage(method, message) : RoutingHeaderProxyInterceptor.this.interceptMessage(method, descriptor, message, this.sid, this.rid, this.rk);
                this.delegate().sendMessage(interceptedMessage);
            }
        };
    }

    private <ReqT, RespT> ReqT interceptMessage(MethodDescriptor<ReqT, RespT> method, ReqT message) {
        int bytes;
        InputStream is = method.getRequestMarshaller().stream(message);
        try {
            bytes = is.available();
        }
        catch (IOException e) {
            log.warn("Encountered exceptions in getting available bytes of message", (Throwable)e);
            throw new RuntimeException("Encountered exception in intercepting message", e);
        }
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        try {
            buffer.writeBytes(is, bytes);
        }
        catch (IOException e) {
            log.warn("Encountered exceptions in transferring bytes to the buffer", (Throwable)e);
            buffer.release();
            throw new RuntimeException("Encountered exceptions in transferring bytes to the buffer", e);
        }
        return (ReqT)method.getRequestMarshaller().parse((InputStream)new ByteBufInputStream(buffer, true));
    }

    private <ReqT, TableReqT extends MessageLite> ReqT interceptMessage(MethodDescriptor<ReqT, ?> method, InterceptorDescriptor<TableReqT> descriptor, ReqT message, Long sid, Long rid, byte[] rk) {
        if (null == descriptor) {
            return message;
        }
        try {
            return this.interceptTableRequest(method, descriptor, message, sid, rid, rk);
        }
        catch (Throwable t) {
            log.error("Failed to intercept table request (sid = {}, rid = {}, rk = {}) : ", new Object[]{sid, rid, Hex.encodeHexString(rk), t});
            return message;
        }
    }

    private <ReqT, TableReqT extends MessageLite> ReqT interceptTableRequest(MethodDescriptor<ReqT, ?> method, InterceptorDescriptor<TableReqT> interceptor, ReqT message, Long sid, Long rid, byte[] rk) throws IOException {
        MessageLite request;
        if (message.getClass() == interceptor.getClz()) {
            request = (MessageLite)message;
        } else {
            InputStream is = method.getRequestMarshaller().stream(message);
            request = (MessageLite)interceptor.getParser().parseFrom(is);
        }
        MessageLite interceptedMessage = interceptor.getInterceptor().intercept(request, sid, rid, rk);
        if (message.getClass() == interceptor.getClz()) {
            return (ReqT)interceptedMessage;
        }
        byte[] reqBytes = new byte[interceptedMessage.getSerializedSize()];
        interceptedMessage.writeTo(CodedOutputStream.newInstance(reqBytes));
        return (ReqT)method.getRequestMarshaller().parse((InputStream)new ByteArrayInputStream(reqBytes));
    }

    static {
        kvRpcMethods.put(TableServiceGrpc.getPutMethod().getFullMethodName(), InterceptorDescriptor.of(PutRequest.class, PutRequest.parser(), PUT_INTERCEPTOR));
        kvRpcMethods.put(TableServiceGrpc.getRangeMethod().getFullMethodName(), InterceptorDescriptor.of(RangeRequest.class, RangeRequest.parser(), RANGE_INTERCEPTOR));
        kvRpcMethods.put(TableServiceGrpc.getDeleteMethod().getFullMethodName(), InterceptorDescriptor.of(DeleteRangeRequest.class, DeleteRangeRequest.parser(), DELETE_INTERCEPTOR));
        kvRpcMethods.put(TableServiceGrpc.getIncrementMethod().getFullMethodName(), InterceptorDescriptor.of(IncrementRequest.class, IncrementRequest.parser(), INCR_INTERCEPTOR));
        kvRpcMethods.put(TableServiceGrpc.getTxnMethod().getFullMethodName(), InterceptorDescriptor.of(TxnRequest.class, TxnRequest.parser(), TXN_INTERCEPTOR));
    }

    private static class InterceptorDescriptor<T extends MessageLite> {
        private final Class<T> clz;
        private final Parser<T> parser;
        private final TableRequestMutator<T> interceptor;

        private InterceptorDescriptor(Class<T> clz, Parser<T> parser, TableRequestMutator<T> interceptor) {
            this.clz = clz;
            this.parser = parser;
            this.interceptor = interceptor;
        }

        public static <T extends MessageLite> InterceptorDescriptor<T> of(Class<T> clz, Parser<T> parser, TableRequestMutator<T> interceptor) {
            return new InterceptorDescriptor<T>(clz, parser, interceptor);
        }

        public Class<T> getClz() {
            return this.clz;
        }

        public Parser<T> getParser() {
            return this.parser;
        }

        public TableRequestMutator<T> getInterceptor() {
            return this.interceptor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InterceptorDescriptor)) {
                return false;
            }
            InterceptorDescriptor other = (InterceptorDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$clz = this.getClz();
            Class<T> other$clz = other.getClz();
            if (this$clz == null ? other$clz != null : !this$clz.equals(other$clz)) {
                return false;
            }
            Parser<T> this$parser = this.getParser();
            Parser<T> other$parser = other.getParser();
            if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
                return false;
            }
            TableRequestMutator<T> this$interceptor = this.getInterceptor();
            TableRequestMutator<T> other$interceptor = other.getInterceptor();
            return !(this$interceptor == null ? other$interceptor != null : !this$interceptor.equals(other$interceptor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InterceptorDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $clz = this.getClz();
            result = result * 59 + ($clz == null ? 43 : $clz.hashCode());
            Parser<T> $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            TableRequestMutator<T> $interceptor = this.getInterceptor();
            result = result * 59 + ($interceptor == null ? 43 : $interceptor.hashCode());
            return result;
        }

        public String toString() {
            return "RoutingHeaderProxyInterceptor.InterceptorDescriptor(clz=" + this.getClz() + ", parser=" + this.getParser() + ", interceptor=" + this.getInterceptor() + ")";
        }
    }

    private static interface TableRequestMutator<ReqT> {
        public ReqT intercept(ReqT var1, Long var2, Long var3, byte[] var4);
    }
}

