/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.sc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Maps;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.exceptions.ObjectClosedException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.api.sc.StorageContainer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.api.sc.StorageContainerFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.api.sc.StorageContainerRegistry;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.exceptions.StorageException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.sc.StorageContainer404;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerRegistryImpl
implements StorageContainerRegistry {
    private static final Logger log = LoggerFactory.getLogger(StorageContainerRegistryImpl.class);
    private static final String COMPONENT_NAME = StorageContainerRegistry.class.getSimpleName();
    private final StorageContainerFactory scFactory;
    private final ConcurrentMap<Long, StorageContainer> containers;
    private final ReentrantReadWriteLock closeLock;
    private boolean closed = false;

    public StorageContainerRegistryImpl(StorageContainerFactory factory) {
        this.scFactory = factory;
        this.containers = Maps.newConcurrentMap();
        this.closeLock = new ReentrantReadWriteLock();
    }

    @VisibleForTesting
    public void setStorageContainer(long scId, StorageContainer group) {
        this.containers.put(scId, group);
    }

    @Override
    public int getNumStorageContainers() {
        return this.containers.size();
    }

    @Override
    public StorageContainer getStorageContainer(long storageContainerId) {
        return this.getStorageContainer(storageContainerId, StorageContainer404.of());
    }

    @Override
    public StorageContainer getStorageContainer(long storageContainerId, StorageContainer defaultContainer) {
        return this.containers.getOrDefault(storageContainerId, defaultContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<StorageContainer> startStorageContainer(long scId) {
        this.closeLock.readLock().lock();
        try {
            CompletableFuture<StorageContainer> completableFuture = this.unsafeStartStorageContainer(scId);
            return completableFuture;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private CompletableFuture<StorageContainer> unsafeStartStorageContainer(long scId) {
        if (this.closed) {
            return FutureUtils.exception(new ObjectClosedException(COMPONENT_NAME));
        }
        if (this.containers.containsKey(scId)) {
            return FutureUtils.exception(new StorageException("StorageContainer " + scId + " already registered"));
        }
        StorageContainer newStorageContainer = this.scFactory.createStorageContainer(scId);
        StorageContainer oldStorageContainer = this.containers.putIfAbsent(scId, newStorageContainer);
        if (null != oldStorageContainer) {
            newStorageContainer.close();
            return FutureUtils.exception(new StorageException("StorageContainer " + scId + " already registered"));
        }
        log.info("Registered StorageContainer ('{}').", (Object)scId);
        return newStorageContainer.start().whenComplete((container, cause) -> {
            if (null != cause) {
                if (this.containers.remove(scId, newStorageContainer)) {
                    log.warn("De-registered StorageContainer ('{}') when failed to start", (Object)scId, cause);
                } else {
                    log.warn("Fail to de-register StorageContainer ('{}') when failed to start", (Object)scId, cause);
                }
                log.info("Release resources hold by StorageContainer ('{}') during de-register", (Object)scId);
                newStorageContainer.stop().exceptionally(throwable -> {
                    log.error("Stop StorageContainer ('{}') fail during de-register", (Object)scId);
                    return null;
                });
            } else {
                log.info("Successfully started registered StorageContainer ('{}').", (Object)scId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> stopStorageContainer(long scId, StorageContainer container) {
        this.closeLock.readLock().lock();
        try {
            CompletableFuture<Void> completableFuture = this.unsafeStopStorageContainer(scId, container);
            return completableFuture;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private CompletableFuture<Void> unsafeStopStorageContainer(long scId, StorageContainer container) {
        if (this.closed) {
            return FutureUtils.exception(new ObjectClosedException(COMPONENT_NAME));
        }
        if (null == container) {
            StorageContainer existingContainer = (StorageContainer)this.containers.remove(scId);
            if (null != existingContainer) {
                log.info("Unregistered StorageContainer ('{}').", (Object)scId);
                return existingContainer.stop();
            }
            return FutureUtils.Void();
        }
        boolean removed = this.containers.remove(scId, container);
        if (removed) {
            log.info("Unregistered StorageContainer ('{}').", (Object)scId);
        }
        return container.stop();
    }

    @Override
    public void close() {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.containers.values().forEach(StorageContainer::close);
        this.containers.clear();
    }
}

