/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.EntryFormatter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.io.HexDump;

public class HexDumpEntryFormatter
extends EntryFormatter {
    @Override
    public void formatEntry(byte[] data) {
        try {
            HexDump.dump(data, 0L, System.out, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Warn: Index is outside the data array's bounds : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println("Warn: The output stream is null : " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Warn: Something has gone wrong writing the data to stream : " + e.getMessage());
        }
    }

    @Override
    public void formatEntry(InputStream input) {
        try {
            byte[] data = new byte[input.available()];
            input.read(data, 0, data.length);
            this.formatEntry(data);
        }
        catch (IOException ie) {
            System.out.println("Warn: Unreadable entry : " + ie.getMessage());
        }
    }
}

