/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.admin;

import java.lang.reflect.InvocationTargetException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.admin.AdminServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.admin.DummyAdminServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AdminServerFactory.class);

    public static AdminServer createAdminServer() {
        if (!"false".equals(System.getProperty("zookeeper.admin.enableServer"))) {
            try {
                Class<?> jettyAdminServerC = Class.forName("org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.admin.JettyAdminServer");
                Object adminServer = jettyAdminServerC.getConstructor(new Class[0]).newInstance(new Object[0]);
                return (AdminServer)adminServer;
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Unable to start JettyAdminServer", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.warn("Unable to start JettyAdminServer", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Unable to start JettyAdminServer", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.warn("Unable to start JettyAdminServer", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.warn("Unable to start JettyAdminServer", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.warn("Unable to load jetty, not starting JettyAdminServer", (Throwable)e);
            }
        }
        return new DummyAdminServer();
    }
}

