/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.rocksdb;

import java.nio.ByteBuffer;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.AbstractRocksIterator;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.DirectSlice;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.RocksDBException;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.WriteBatchWithIndex;

public class WBWIRocksIterator
extends AbstractRocksIterator<WriteBatchWithIndex> {
    private final WriteEntry entry = new WriteEntry();

    protected WBWIRocksIterator(WriteBatchWithIndex writeBatchWithIndex, long l) {
        super(writeBatchWithIndex, l);
    }

    public WriteEntry entry() {
        assert (this.isOwningHandle());
        long[] lArray = this.entry1(this.nativeHandle_);
        this.entry.type = WriteType.fromId((byte)lArray[0]);
        this.entry.key.resetNativeHandle(lArray[1], lArray[1] != 0L);
        this.entry.value.resetNativeHandle(lArray[2], lArray[2] != 0L);
        return this.entry;
    }

    @Override
    protected final native void disposeInternal(long var1);

    @Override
    final native boolean isValid0(long var1);

    @Override
    final native void seekToFirst0(long var1);

    @Override
    final native void seekToLast0(long var1);

    @Override
    final native void next0(long var1);

    @Override
    final native void prev0(long var1);

    @Override
    final native void refresh0(long var1) throws RocksDBException;

    @Override
    final native void seek0(long var1, byte[] var3, int var4);

    @Override
    final native void seekForPrev0(long var1, byte[] var3, int var4);

    @Override
    final native void status0(long var1) throws RocksDBException;

    @Override
    final native void seekDirect0(long var1, ByteBuffer var3, int var4, int var5);

    private native long[] entry1(long var1);

    @Override
    public void close() {
        this.entry.close();
        super.close();
    }

    @Override
    void seekForPrevDirect0(long l, ByteBuffer byteBuffer, int n, int n2) {
        throw new IllegalAccessError("Not implemented");
    }

    public static class WriteEntry
    implements AutoCloseable {
        WriteType type = null;
        final DirectSlice key;
        final DirectSlice value;

        private WriteEntry() {
            this.key = new DirectSlice();
            this.value = new DirectSlice();
        }

        public WriteEntry(WriteType writeType, DirectSlice directSlice, DirectSlice directSlice2) {
            this.type = writeType;
            this.key = directSlice;
            this.value = directSlice2;
        }

        public WriteType getType() {
            return this.type;
        }

        public DirectSlice getKey() {
            return this.key;
        }

        public DirectSlice getValue() {
            if (!this.value.isOwningHandle()) {
                return null;
            }
            return this.value;
        }

        public int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object instanceof WriteEntry) {
                WriteEntry writeEntry = (WriteEntry)object;
                return this.type.equals((Object)writeEntry.type) && this.key.equals(writeEntry.key) && this.value.equals(writeEntry.value);
            }
            return false;
        }

        @Override
        public void close() {
            this.value.close();
            this.key.close();
        }
    }

    public static enum WriteType {
        PUT(0),
        MERGE(1),
        DELETE(2),
        SINGLE_DELETE(3),
        DELETE_RANGE(4),
        LOG(5),
        XID(6);

        final byte id;

        private WriteType(byte by) {
            this.id = by;
        }

        public static WriteType fromId(byte by) {
            for (WriteType writeType : WriteType.values()) {
                if (by != writeType.id) continue;
                return writeType;
            }
            throw new IllegalArgumentException("No WriteType with id=" + by);
        }
    }
}

