/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Actions {
    private static final Logger log = LoggerFactory.getLogger(Actions.class);
    private List<Action> actions = new LinkedList<Action>();

    private Actions() {
    }

    public Actions addAction(Action action) {
        action.verifyAction();
        this.actions.add(action);
        return this;
    }

    public static Actions newBuilder() {
        return new Actions();
    }

    public int numActions() {
        return this.actions.size();
    }

    public void run() throws InterruptedException {
        for (Action action : this.actions) {
            boolean success;
            try {
                success = this.runAction(action);
            }
            catch (Exception e) {
                log.error("Uncaught exception thrown when running action [ {} ]:", (Object)action.getActionName(), (Object)e);
                success = false;
            }
            if (action.getContinueOn() != null && success == action.getContinueOn()) continue;
        }
    }

    private boolean runAction(Action action) throws InterruptedException {
        for (int i = 0; i < action.getNumRetries(); ++i) {
            ActionResult actionResult = action.getSupplier().get();
            if (actionResult.isSuccess()) {
                log.info("Sucessfully completed action [ {} ]", (Object)action.getActionName());
                if (action.getOnSuccess() != null) {
                    action.getOnSuccess().accept(actionResult);
                }
                return true;
            }
            if (actionResult.getErrorMsg() != null) {
                log.warn("Error completing action [ {} ] :- {} - [ATTEMPT] {}/{}", new Object[]{action.getActionName(), actionResult.getErrorMsg(), i + 1, action.getNumRetries()});
            } else {
                log.warn("Error completing action [ {} ] [ATTEMPT] {}/{}", new Object[]{action.getActionName(), i + 1, action.getNumRetries()});
            }
            Thread.sleep(action.sleepBetweenInvocationsMs);
        }
        log.error("Failed completing action [ {} ]. Giving up!", (Object)action.getActionName());
        if (action.getOnFail() != null) {
            action.getOnFail().accept(action.getSupplier().get());
        }
        return false;
    }

    public static class ActionResult {
        private boolean success;
        private String errorMsg;
        private Object result;

        ActionResult(boolean success, String errorMsg, Object result) {
            this.success = success;
            this.errorMsg = errorMsg;
            this.result = result;
        }

        public static ActionResultBuilder builder() {
            return new ActionResultBuilder();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public Object getResult() {
            return this.result;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionResult)) {
                return false;
            }
            ActionResult other = (ActionResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
                return false;
            }
            Object this$result = this.getResult();
            Object other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActionResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            Object $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "Actions.ActionResult(success=" + this.isSuccess() + ", errorMsg=" + this.getErrorMsg() + ", result=" + this.getResult() + ")";
        }

        public static class ActionResultBuilder {
            private boolean success;
            private String errorMsg;
            private Object result;

            ActionResultBuilder() {
            }

            public ActionResultBuilder success(boolean success) {
                this.success = success;
                return this;
            }

            public ActionResultBuilder errorMsg(String errorMsg) {
                this.errorMsg = errorMsg;
                return this;
            }

            public ActionResultBuilder result(Object result) {
                this.result = result;
                return this;
            }

            public ActionResult build() {
                return new ActionResult(this.success, this.errorMsg, this.result);
            }

            public String toString() {
                return "Actions.ActionResult.ActionResultBuilder(success=" + this.success + ", errorMsg=" + this.errorMsg + ", result=" + this.result + ")";
            }
        }
    }

    public static class Action {
        private String actionName;
        private int numRetries = 1;
        private Supplier<ActionResult> supplier;
        private long sleepBetweenInvocationsMs = 500L;
        private Boolean continueOn;
        private Consumer<ActionResult> onFail;
        private Consumer<ActionResult> onSuccess;

        public void verifyAction() {
            if (StringUtils.isBlank(this.actionName)) {
                throw new RuntimeException("Action name is empty!");
            }
            if (this.supplier == null) {
                throw new RuntimeException("Supplier is not specified!");
            }
        }

        Action(String actionName, int numRetries, Supplier<ActionResult> supplier, long sleepBetweenInvocationsMs, Boolean continueOn, Consumer<ActionResult> onFail, Consumer<ActionResult> onSuccess) {
            this.actionName = actionName;
            this.numRetries = numRetries;
            this.supplier = supplier;
            this.sleepBetweenInvocationsMs = sleepBetweenInvocationsMs;
            this.continueOn = continueOn;
            this.onFail = onFail;
            this.onSuccess = onSuccess;
        }

        public static ActionBuilder builder() {
            return new ActionBuilder();
        }

        public ActionBuilder toBuilder() {
            return new ActionBuilder().actionName(this.actionName).numRetries(this.numRetries).supplier(this.supplier).sleepBetweenInvocationsMs(this.sleepBetweenInvocationsMs).continueOn(this.continueOn).onFail(this.onFail).onSuccess(this.onSuccess);
        }

        public String getActionName() {
            return this.actionName;
        }

        public int getNumRetries() {
            return this.numRetries;
        }

        public Supplier<ActionResult> getSupplier() {
            return this.supplier;
        }

        public long getSleepBetweenInvocationsMs() {
            return this.sleepBetweenInvocationsMs;
        }

        public Boolean getContinueOn() {
            return this.continueOn;
        }

        public Consumer<ActionResult> getOnFail() {
            return this.onFail;
        }

        public Consumer<ActionResult> getOnSuccess() {
            return this.onSuccess;
        }

        public void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public void setNumRetries(int numRetries) {
            this.numRetries = numRetries;
        }

        public void setSupplier(Supplier<ActionResult> supplier) {
            this.supplier = supplier;
        }

        public void setSleepBetweenInvocationsMs(long sleepBetweenInvocationsMs) {
            this.sleepBetweenInvocationsMs = sleepBetweenInvocationsMs;
        }

        public void setContinueOn(Boolean continueOn) {
            this.continueOn = continueOn;
        }

        public void setOnFail(Consumer<ActionResult> onFail) {
            this.onFail = onFail;
        }

        public void setOnSuccess(Consumer<ActionResult> onSuccess) {
            this.onSuccess = onSuccess;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNumRetries() != other.getNumRetries()) {
                return false;
            }
            if (this.getSleepBetweenInvocationsMs() != other.getSleepBetweenInvocationsMs()) {
                return false;
            }
            Boolean this$continueOn = this.getContinueOn();
            Boolean other$continueOn = other.getContinueOn();
            if (this$continueOn == null ? other$continueOn != null : !((Object)this$continueOn).equals(other$continueOn)) {
                return false;
            }
            String this$actionName = this.getActionName();
            String other$actionName = other.getActionName();
            if (this$actionName == null ? other$actionName != null : !this$actionName.equals(other$actionName)) {
                return false;
            }
            Supplier<ActionResult> this$supplier = this.getSupplier();
            Supplier<ActionResult> other$supplier = other.getSupplier();
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            Consumer<ActionResult> this$onFail = this.getOnFail();
            Consumer<ActionResult> other$onFail = other.getOnFail();
            if (this$onFail == null ? other$onFail != null : !this$onFail.equals(other$onFail)) {
                return false;
            }
            Consumer<ActionResult> this$onSuccess = this.getOnSuccess();
            Consumer<ActionResult> other$onSuccess = other.getOnSuccess();
            return !(this$onSuccess == null ? other$onSuccess != null : !this$onSuccess.equals(other$onSuccess));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNumRetries();
            long $sleepBetweenInvocationsMs = this.getSleepBetweenInvocationsMs();
            result = result * 59 + (int)($sleepBetweenInvocationsMs >>> 32 ^ $sleepBetweenInvocationsMs);
            Boolean $continueOn = this.getContinueOn();
            result = result * 59 + ($continueOn == null ? 43 : ((Object)$continueOn).hashCode());
            String $actionName = this.getActionName();
            result = result * 59 + ($actionName == null ? 43 : $actionName.hashCode());
            Supplier<ActionResult> $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            Consumer<ActionResult> $onFail = this.getOnFail();
            result = result * 59 + ($onFail == null ? 43 : $onFail.hashCode());
            Consumer<ActionResult> $onSuccess = this.getOnSuccess();
            result = result * 59 + ($onSuccess == null ? 43 : $onSuccess.hashCode());
            return result;
        }

        public String toString() {
            return "Actions.Action(actionName=" + this.getActionName() + ", numRetries=" + this.getNumRetries() + ", supplier=" + this.getSupplier() + ", sleepBetweenInvocationsMs=" + this.getSleepBetweenInvocationsMs() + ", continueOn=" + this.getContinueOn() + ", onFail=" + this.getOnFail() + ", onSuccess=" + this.getOnSuccess() + ")";
        }

        public static class ActionBuilder {
            private String actionName;
            private int numRetries;
            private Supplier<ActionResult> supplier;
            private long sleepBetweenInvocationsMs;
            private Boolean continueOn;
            private Consumer<ActionResult> onFail;
            private Consumer<ActionResult> onSuccess;

            ActionBuilder() {
            }

            public ActionBuilder actionName(String actionName) {
                this.actionName = actionName;
                return this;
            }

            public ActionBuilder numRetries(int numRetries) {
                this.numRetries = numRetries;
                return this;
            }

            public ActionBuilder supplier(Supplier<ActionResult> supplier) {
                this.supplier = supplier;
                return this;
            }

            public ActionBuilder sleepBetweenInvocationsMs(long sleepBetweenInvocationsMs) {
                this.sleepBetweenInvocationsMs = sleepBetweenInvocationsMs;
                return this;
            }

            public ActionBuilder continueOn(Boolean continueOn) {
                this.continueOn = continueOn;
                return this;
            }

            public ActionBuilder onFail(Consumer<ActionResult> onFail) {
                this.onFail = onFail;
                return this;
            }

            public ActionBuilder onSuccess(Consumer<ActionResult> onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            public Action build() {
                return new Action(this.actionName, this.numRetries, this.supplier, this.sleepBetweenInvocationsMs, this.continueOn, this.onFail, this.onSuccess);
            }

            public String toString() {
                return "Actions.Action.ActionBuilder(actionName=" + this.actionName + ", numRetries=" + this.numRetries + ", supplier=" + this.supplier + ", sleepBetweenInvocationsMs=" + this.sleepBetweenInvocationsMs + ", continueOn=" + this.continueOn + ", onFail=" + this.onFail + ", onSuccess=" + this.onSuccess + ")";
            }
        }
    }
}

