/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.impl.LocalMemoryMetadataStore;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;

public final class MetadataStoreFactory {
    public static MetadataStore create(String metadataURL, MetadataStoreConfig metadataStoreConfig) throws MetadataStoreException {
        if (metadataURL.startsWith("memory://")) {
            return new LocalMemoryMetadataStore(metadataURL, metadataStoreConfig);
        }
        return new ZKMetadataStore(metadataURL, metadataStoreConfig);
    }

    private MetadataStoreFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

