/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shaded.com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRegion;
import com.yahoo.memory.NativeMemory;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import org.apache.pulsar.shaded.com.yahoo.sketches.Family;
import org.apache.pulsar.shaded.com.yahoo.sketches.HashOperations;
import org.apache.pulsar.shaded.com.yahoo.sketches.QuickSelect;
import org.apache.pulsar.shaded.com.yahoo.sketches.ResizeFactor;
import org.apache.pulsar.shaded.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.shaded.com.yahoo.sketches.Util;
import org.apache.pulsar.shaded.com.yahoo.sketches.tuple.CompactSketch;
import org.apache.pulsar.shaded.com.yahoo.sketches.tuple.DeserializeResult;
import org.apache.pulsar.shaded.com.yahoo.sketches.tuple.SerializerDeserializer;
import org.apache.pulsar.shaded.com.yahoo.sketches.tuple.Sketch;
import org.apache.pulsar.shaded.com.yahoo.sketches.tuple.Summary;
import org.apache.pulsar.shaded.com.yahoo.sketches.tuple.SummaryFactory;

class QuickSelectSketch<S extends Summary>
extends Sketch<S> {
    private static final byte serialVersionUID = 1;
    static final int DEFAULT_LG_RESIZE_FACTOR = 3;
    private final int nomEntries_;
    private int lgCurrentCapacity_;
    private final int lgResizeFactor_;
    private int count_;
    private final SummaryFactory<S> summaryFactory_;
    private final float samplingProbability_;
    private int rebuildThreshold_;

    QuickSelectSketch(int nomEntries, SummaryFactory<S> summaryFactory) {
        this(nomEntries, 3, summaryFactory);
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, SummaryFactory<S> summaryFactory) {
        this(nomEntries, lgResizeFactor, 1.0f, summaryFactory);
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory) {
        this(nomEntries, lgResizeFactor, samplingProbability, summaryFactory, 1 << Util.startingSubMultiple(Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomEntries) * 2), ResizeFactor.getRF(lgResizeFactor), 5));
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory, int startingSize) {
        this.nomEntries_ = Util.ceilingPowerOf2(nomEntries);
        this.lgResizeFactor_ = lgResizeFactor;
        this.samplingProbability_ = samplingProbability;
        this.summaryFactory_ = summaryFactory;
        this.theta_ = (long)(9.223372036854776E18 * (double)samplingProbability);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingSize);
        this.keys_ = new long[startingSize];
        this.summaries_ = (Summary[])Array.newInstance(this.summaryFactory_.newSummary().getClass(), startingSize);
        this.setRebuildThreshold();
    }

    QuickSelectSketch(Memory mem) {
        boolean hasEntries;
        boolean isThetaIncluded;
        boolean isBigEndian;
        int offset = 0;
        byte preambleLongs = mem.getByte(offset++);
        byte version = mem.getByte(offset++);
        byte familyId = mem.getByte(offset++);
        SerializerDeserializer.validateFamily(familyId, preambleLongs);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        SerializerDeserializer.validateType(mem.getByte(offset++), SerializerDeserializer.SketchType.QuickSelectSketch);
        byte flags = mem.getByte(offset++);
        boolean bl = isBigEndian = (flags & 1 << Flags.IS_BIG_ENDIAN.ordinal()) > 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Endian byte order mismatch");
        }
        this.nomEntries_ = 1 << mem.getByte(offset++);
        this.lgCurrentCapacity_ = mem.getByte(offset++);
        this.lgResizeFactor_ = mem.getByte(offset++);
        boolean isInSamplingMode = (flags & 1 << Flags.IS_IN_SAMPLING_MODE.ordinal()) > 0;
        float f = this.samplingProbability_ = isInSamplingMode ? mem.getFloat(offset) : 1.0f;
        if (isInSamplingMode) {
            offset += 4;
        }
        boolean bl2 = isThetaIncluded = (flags & 1 << Flags.IS_THETA_INCLUDED.ordinal()) > 0;
        if (isThetaIncluded) {
            this.theta_ = mem.getLong(offset);
            offset += 8;
        } else {
            this.theta_ = (long)(9.223372036854776E18 * (double)this.samplingProbability_);
        }
        int count = 0;
        boolean bl3 = hasEntries = (flags & 1 << Flags.HAS_ENTRIES.ordinal()) > 0;
        if (hasEntries) {
            count = mem.getInt(offset);
            offset += 4;
        }
        DeserializeResult factoryResult = SerializerDeserializer.deserializeFromMemory(mem, offset);
        this.summaryFactory_ = (SummaryFactory)factoryResult.getObject();
        offset += factoryResult.getSize();
        int currentCapacity = 1 << this.lgCurrentCapacity_;
        this.keys_ = new long[currentCapacity];
        this.summaries_ = (Summary[])Array.newInstance(this.summaryFactory_.newSummary().getClass(), currentCapacity);
        MemoryRegion memRegion = new MemoryRegion(mem, 0L, mem.getCapacity());
        for (int i = 0; i < count; ++i) {
            long key = mem.getLong(offset);
            memRegion.reassign(offset += 8, mem.getCapacity() - (long)offset);
            DeserializeResult<S> summaryResult = this.summaryFactory_.summaryFromMemory(memRegion);
            Summary summary = (Summary)summaryResult.getObject();
            offset += summaryResult.getSize();
            this.insert(key, summary);
        }
        this.isEmpty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
        this.setRebuildThreshold();
    }

    @Override
    public S[] getSummaries() {
        Summary[] summaries = (Summary[])Array.newInstance(this.summaryFactory_.newSummary().getClass(), this.count_);
        int i = 0;
        for (int j = 0; j < this.summaries_.length; ++j) {
            if (this.summaries_[j] == null) continue;
            summaries[i++] = this.summaries_[j].copy();
        }
        return summaries;
    }

    @Override
    public int getRetainedEntries() {
        return this.count_;
    }

    public void trim() {
        if (this.count_ > this.nomEntries_) {
            this.updateTheta();
            this.rebuild(this.keys_.length);
        }
    }

    public CompactSketch<S> compact() {
        long[] keys = new long[this.getRetainedEntries()];
        Summary[] summaries = (Summary[])Array.newInstance(this.summaries_.getClass().getComponentType(), this.getRetainedEntries());
        int i = 0;
        for (int j = 0; j < this.keys_.length; ++j) {
            if (this.summaries_[j] == null) continue;
            keys[i] = this.keys_[j];
            summaries[i] = this.summaries_[j].copy();
            ++i;
        }
        return new CompactSketch(keys, summaries, this.theta_, this.isEmpty_);
    }

    @Override
    public byte[] toByteArray() {
        boolean isThetaIncluded;
        byte[] summaryFactoryBytes = SerializerDeserializer.toByteArray(this.summaryFactory_);
        Object summariesBytes = null;
        int summariesBytesLength = 0;
        if (this.count_ > 0) {
            summariesBytes = new byte[this.count_][];
            int i = 0;
            for (int j = 0; j < this.summaries_.length; ++j) {
                if (this.summaries_[j] == null) continue;
                summariesBytes[i] = this.summaries_[j].toByteArray();
                summariesBytesLength += summariesBytes[i].length;
                ++i;
            }
        }
        int sizeBytes = 8;
        if (this.isInSamplingMode()) {
            sizeBytes += 4;
        }
        boolean bl = this.isInSamplingMode() ? (float)this.theta_ < this.samplingProbability_ : (isThetaIncluded = this.theta_ < Long.MAX_VALUE);
        if (isThetaIncluded) {
            sizeBytes += 8;
        }
        if (this.count_ > 0) {
            sizeBytes += 4;
        }
        byte[] bytes = new byte[sizeBytes += 8 * this.count_ + summaryFactoryBytes.length + summariesBytesLength];
        NativeMemory mem = new NativeMemory(bytes);
        int offset = 0;
        mem.putByte(offset++, (byte)1);
        mem.putByte(offset++, (byte)1);
        mem.putByte(offset++, (byte)Family.TUPLE.getID());
        mem.putByte(offset++, (byte)SerializerDeserializer.SketchType.QuickSelectSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        mem.putByte(offset++, (byte)((isBigEndian ? 1 << Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isInSamplingMode() ? 1 << Flags.IS_IN_SAMPLING_MODE.ordinal() : 0) | (this.isEmpty_ ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (this.count_ > 0 ? 1 << Flags.HAS_ENTRIES.ordinal() : 0) | (isThetaIncluded ? 1 << Flags.IS_THETA_INCLUDED.ordinal() : 0)));
        mem.putByte(offset++, (byte)Integer.numberOfTrailingZeros(this.nomEntries_));
        mem.putByte(offset++, (byte)this.lgCurrentCapacity_);
        mem.putByte(offset++, (byte)this.lgResizeFactor_);
        if (this.samplingProbability_ < 1.0f) {
            mem.putFloat(offset, this.samplingProbability_);
            offset += 4;
        }
        if (isThetaIncluded) {
            mem.putLong(offset, this.theta_);
            offset += 8;
        }
        if (this.count_ > 0) {
            mem.putInt(offset, this.count_);
            offset += 4;
        }
        mem.putByteArray(offset, summaryFactoryBytes, 0, summaryFactoryBytes.length);
        offset += summaryFactoryBytes.length;
        if (this.count_ > 0) {
            int i = 0;
            for (int j = 0; j < this.keys_.length; ++j) {
                if (this.summaries_[j] == null) continue;
                mem.putLong(offset, this.keys_[j]);
                mem.putByteArray(offset += 8, summariesBytes[i], 0, summariesBytes[i].length);
                offset += summariesBytes[i].length;
                ++i;
            }
        }
        return bytes;
    }

    void merge(long key, S summary) {
        this.isEmpty_ = false;
        if (key < this.theta_) {
            int index = this.findOrInsert(key);
            if (index < 0) {
                this.summaries_[index ^ 0xFFFFFFFF] = summary.copy();
            } else {
                this.summaries_[index] = this.summaryFactory_.getSummarySetOperations().union(this.summaries_[index], (Summary)summary);
            }
            this.rebuildIfNeeded();
        }
    }

    boolean isInSamplingMode() {
        return this.samplingProbability_ < 1.0f;
    }

    void setThetaLong(long theta) {
        this.theta_ = theta;
    }

    void setNotEmpty() {
        this.isEmpty_ = false;
    }

    SummaryFactory<S> getSummaryFactory() {
        return this.summaryFactory_;
    }

    int findOrInsert(long key) {
        int index = HashOperations.hashSearchOrInsert(this.keys_, this.lgCurrentCapacity_, key);
        if (index < 0) {
            ++this.count_;
        }
        return index;
    }

    S find(long key) {
        int index = HashOperations.hashSearch(this.keys_, this.lgCurrentCapacity_, key);
        if (index == -1) {
            return null;
        }
        return (S)this.summaries_[index];
    }

    boolean rebuildIfNeeded() {
        if (this.count_ < this.rebuildThreshold_) {
            return false;
        }
        if (this.keys_.length > this.nomEntries_) {
            this.updateTheta();
            this.rebuild();
        } else {
            this.rebuild(this.keys_.length * (1 << this.lgResizeFactor_));
        }
        return true;
    }

    void rebuild() {
        this.rebuild(this.keys_.length);
    }

    void insert(long key, S summary) {
        int index = HashOperations.hashInsertOnly(this.keys_, this.lgCurrentCapacity_, key);
        this.summaries_[index] = summary;
        ++this.count_;
    }

    private void updateTheta() {
        long[] keys = new long[this.count_];
        int i = 0;
        for (int j = 0; j < this.keys_.length; ++j) {
            if (this.summaries_[j] == null) continue;
            keys[i++] = this.keys_[j];
        }
        this.theta_ = QuickSelect.select(keys, 0, this.count_ - 1, this.nomEntries_);
    }

    private void rebuild(int newSize) {
        long[] oldKeys = this.keys_;
        Summary[] oldSummaries = this.summaries_;
        this.keys_ = new long[newSize];
        this.summaries_ = (Summary[])Array.newInstance(oldSummaries.getClass().getComponentType(), newSize);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(newSize);
        this.count_ = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldSummaries[i] == null || oldKeys[i] >= this.theta_) continue;
            this.insert(oldKeys[i], oldSummaries[i]);
        }
        this.setRebuildThreshold();
    }

    private void setRebuildThreshold() {
        this.rebuildThreshold_ = this.keys_.length > this.nomEntries_ ? (int)((double)this.keys_.length * 0.9375) : (int)((double)this.keys_.length * 0.5);
    }

    private static enum Flags {
        IS_BIG_ENDIAN,
        IS_IN_SAMPLING_MODE,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

